/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class PolygonTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;

    public PolygonTypeBinding(GeometryFactory gFactory) {
        this.gFactory = gFactory;
    }

    public QName getTarget() {
        return GML.PolygonType;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Class getType() {
        return Polygon.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LinearRing exterior = (LinearRing)node.getChildValue("exterior");
        LinearRing[] interior = null;
        if (node.hasChild("interior")) {
            List list = node.getChildValues("interior");
            interior = list.toArray(new LinearRing[list.size()]);
        }
        return this.gFactory.createPolygon(exterior, interior);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        int n;
        Polygon polygon = (Polygon)object;
        if ("exterior".equals(name.getLocalPart())) {
            return polygon.getExteriorRing();
        }
        if ("interior".equals(name.getLocalPart()) && (n = polygon.getNumInteriorRing()) > 0) {
            LineString[] interior = new LineString[n];
            int i = 0;
            while (i < n) {
                interior[i] = polygon.getInteriorRingN(i);
                ++i;
            }
            return interior;
        }
        return null;
    }
}

