/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class RingTypeBinding
extends AbstractComplexBinding {
    protected GeometryFactory gf;

    public RingTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    public QName getTarget() {
        return GML.RingType;
    }

    public Class getType() {
        return LinearRing.class;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List curveMemberList = node.getChildValues(MultiLineString.class);
        ArrayList<LineString> curveMembers = new ArrayList<LineString>();
        for (MultiLineString curveMember : curveMemberList) {
            for (int i = 0; i < curveMember.getNumGeometries(); ++i) {
                LineString lineString = (LineString)curveMember.getGeometryN(i);
                curveMembers.add(lineString);
            }
        }
        MultiLineString multiLineString = this.gf.createMultiLineString(GeometryFactory.toLineStringArray(curveMembers));
        return this.gf.createLinearRing(multiLineString.getCoordinates());
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("curveMember".equals(name.getLocalPart())) {
            LinearRing ring = (LinearRing)object;
            return (MultiLineString)ring.getGeometryN(0);
        }
        return null;
    }
}

