/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.bindings;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EFactory;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GML;
import org.geotools.wfs.CompositeFeatureCollection;
import org.geotools.wfs.WFS;
import org.geotools.xml.AbstractComplexEMFBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureCollectionTypeBinding
extends AbstractComplexEMFBinding {
    public FeatureCollectionTypeBinding(WfsFactory factory) {
        super((EFactory)factory);
    }

    public QName getTarget() {
        return WFS.FeatureCollectionType;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        FeatureCollectionType fc = (FeatureCollectionType)object;
        if (!fc.getFeature().isEmpty()) {
            FeatureCollection first = (FeatureCollection)fc.getFeature().get(0);
            if (GML.boundedBy.equals(name)) {
                if (fc.getFeature().size() == 1) {
                    return first.getBounds();
                }
                ReferencedEnvelope bounds = new ReferencedEnvelope(first.getBounds());
                for (int i = 1; i < fc.getFeature().size(); ++i) {
                    FeatureCollection features = (FeatureCollection)fc.getFeature().get(i);
                    bounds.expandToInclude((Envelope)features.getBounds());
                }
                return bounds;
            }
            if (GML.featureMember.equals(name)) {
                if (fc.getFeature().size() > 1) {
                    return new CompositeFeatureCollection((List)fc.getFeature());
                }
                return first;
            }
        }
        return super.getProperty(object, name);
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        FeatureCollectionType fct = (FeatureCollectionType)super.parse(instance, node, value);
        DefaultFeatureCollection fc = new DefaultFeatureCollection(null, null);
        SimpleFeature[] featureMembers = (SimpleFeature[])node.getChildValue(SimpleFeature[].class);
        if (featureMembers != null) {
            for (int i = 0; i < featureMembers.length; ++i) {
                fc.add((Feature)featureMembers[i]);
            }
        } else {
            List featureMember = node.getChildValues(SimpleFeature.class);
            for (SimpleFeature f : featureMember) {
                fc.add((Feature)f);
            }
        }
        if (!fc.isEmpty()) {
            fct.getFeature().add((Object)fc);
        }
        return fct;
    }
}

