/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.memcached.BufferWrapper;
import org.glassfish.grizzly.memcached.CacheBuilder;
import org.glassfish.grizzly.memcached.CommandOpcodes;
import org.glassfish.grizzly.memcached.ConsistentHashStore;
import org.glassfish.grizzly.memcached.GrizzlyMemcachedCacheManager;
import org.glassfish.grizzly.memcached.MemcachedCache;
import org.glassfish.grizzly.memcached.MemcachedClientFilter;
import org.glassfish.grizzly.memcached.MemcachedRequest;
import org.glassfish.grizzly.memcached.ValueWithCas;
import org.glassfish.grizzly.memcached.ValueWithKey;
import org.glassfish.grizzly.memcached.pool.BaseObjectPool;
import org.glassfish.grizzly.memcached.pool.NoValidObjectException;
import org.glassfish.grizzly.memcached.pool.ObjectPool;
import org.glassfish.grizzly.memcached.pool.PoolExhaustedException;
import org.glassfish.grizzly.memcached.pool.PoolableObjectFactory;
import org.glassfish.grizzly.memcached.zookeeper.BarrierListener;
import org.glassfish.grizzly.memcached.zookeeper.CacheServerListBarrierListener;
import org.glassfish.grizzly.memcached.zookeeper.PreferRemoteConfigBarrierListener;
import org.glassfish.grizzly.memcached.zookeeper.ZKClient;
import org.glassfish.grizzly.memcached.zookeeper.ZooKeeperSupportCache;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.DataStructures;

public class GrizzlyMemcachedCache<K, V>
implements MemcachedCache<K, V>,
ZooKeeperSupportCache {
    private static final Logger logger = Grizzly.logger(GrizzlyMemcachedCache.class);
    private static final AtomicInteger opaqueIndex = new AtomicInteger();
    private final String cacheName;
    private final TCPNIOTransport transport;
    private final long connectTimeoutInMillis;
    private final long writeTimeoutInMillis;
    private final long responseTimeoutInMillis;
    public static final String CONNECTION_POOL_ATTRIBUTE_NAME = "GrizzlyMemcachedCache.ConnectionPool";
    private final Attribute<ObjectPool<SocketAddress, Connection<SocketAddress>>> connectionPoolAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("GrizzlyMemcachedCache.ConnectionPool");
    private final ObjectPool<SocketAddress, Connection<SocketAddress>> connectionPool;
    private final Set<SocketAddress> servers;
    private final long healthMonitorIntervalInSecs;
    private final ScheduledFuture<?> scheduledFuture;
    private final HealthMonitorTask healthMonitorTask;
    private final ScheduledExecutorService scheduledExecutor;
    private final boolean failover;
    private final boolean preferRemoteConfig;
    private final ConsistentHashStore<SocketAddress> consistentHash = new ConsistentHashStore();
    private final ZKClient zkClient;
    private final CacheServerListBarrierListener zkListener;
    private String zooKeeperServerListPath;
    private MemcachedClientFilter clientFilter;

    private GrizzlyMemcachedCache(Builder<K, V> builder) {
        this.cacheName = ((Builder)builder).cacheName;
        this.transport = ((Builder)builder).transport;
        this.connectTimeoutInMillis = ((Builder)builder).connectTimeoutInMillis;
        this.writeTimeoutInMillis = ((Builder)builder).writeTimeoutInMillis;
        this.responseTimeoutInMillis = ((Builder)builder).responseTimeoutInMillis;
        this.healthMonitorIntervalInSecs = ((Builder)builder).healthMonitorIntervalInSecs;
        BaseObjectPool.Builder<SocketAddress, Connection<SocketAddress>> connectionPoolBuilder = new BaseObjectPool.Builder<SocketAddress, Connection<SocketAddress>>(new PoolableObjectFactory<SocketAddress, Connection<SocketAddress>>(){

            @Override
            public Connection<SocketAddress> createObject(SocketAddress key) throws Exception {
                Connection connection;
                TCPNIOConnectorHandler connectorHandler = TCPNIOConnectorHandler.builder((TCPNIOTransport)GrizzlyMemcachedCache.this.transport).setReuseAddress(true).build();
                Future future = connectorHandler.connect((Object)key);
                try {
                    connection = GrizzlyMemcachedCache.this.connectTimeoutInMillis < 0L ? (Connection)future.get() : (Connection)future.get(GrizzlyMemcachedCache.this.connectTimeoutInMillis, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    Connection c;
                    if (!future.cancel(false) && future.isDone() && (c = (Connection)future.get()) != null && c.isOpen()) {
                        c.closeSilently();
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "failed to get the connection. address=" + key, ie);
                    }
                    throw ie;
                }
                catch (ExecutionException ee) {
                    Connection c;
                    if (!future.cancel(false) && future.isDone() && (c = (Connection)future.get()) != null && c.isOpen()) {
                        c.closeSilently();
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "failed to get the connection. address=" + key, ee);
                    }
                    throw ee;
                }
                catch (TimeoutException te) {
                    Connection c;
                    if (!future.cancel(false) && future.isDone() && (c = (Connection)future.get()) != null && c.isOpen()) {
                        c.closeSilently();
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "failed to get the connection. address=" + key, te);
                    }
                    throw te;
                }
                if (connection != null) {
                    GrizzlyMemcachedCache.this.connectionPoolAttribute.set((AttributeStorage)connection, (Object)GrizzlyMemcachedCache.this.connectionPool);
                    return connection;
                }
                throw new IllegalStateException("connection must not be null");
            }

            @Override
            public void destroyObject(SocketAddress key, Connection<SocketAddress> value) throws Exception {
                if (value != null) {
                    AttributeHolder attributeHolder;
                    if (value.isOpen()) {
                        value.closeSilently();
                    }
                    if ((attributeHolder = value.getAttributes()) != null) {
                        attributeHolder.removeAttribute(GrizzlyMemcachedCache.CONNECTION_POOL_ATTRIBUTE_NAME);
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "the connection has been destroyed. key={0}, value={1}", new Object[]{key, value});
                    }
                }
            }

            @Override
            public boolean validateObject(SocketAddress key, Connection<SocketAddress> value) throws Exception {
                return GrizzlyMemcachedCache.this.validateConnectionWithNoopCommand((Connection<SocketAddress>)value);
            }
        });
        connectionPoolBuilder.min(((Builder)builder).minConnectionPerServer);
        connectionPoolBuilder.max(((Builder)builder).maxConnectionPerServer);
        connectionPoolBuilder.keepAliveTimeoutInSecs(((Builder)builder).keepAliveTimeoutInSecs);
        connectionPoolBuilder.disposable(((Builder)builder).allowDisposableConnection);
        connectionPoolBuilder.borrowValidation(((Builder)builder).borrowValidation);
        connectionPoolBuilder.returnValidation(((Builder)builder).returnValidation);
        this.connectionPool = connectionPoolBuilder.build();
        this.failover = ((Builder)builder).failover;
        this.servers = ((Builder)builder).servers;
        if (this.failover && this.healthMonitorIntervalInSecs > 0L) {
            this.healthMonitorTask = new HealthMonitorTask();
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            this.scheduledFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.healthMonitorTask, this.healthMonitorIntervalInSecs, this.healthMonitorIntervalInSecs, TimeUnit.SECONDS);
        } else {
            this.healthMonitorTask = null;
            this.scheduledExecutor = null;
            this.scheduledFuture = null;
        }
        this.preferRemoteConfig = ((Builder)builder).preferRemoteConfig;
        this.zkListener = this.preferRemoteConfig ? new PreferRemoteConfigBarrierListener(this, this.servers) : new CacheServerListBarrierListener(this, this.servers);
        this.zkClient = ((Builder)builder).zkClient;
    }

    @Override
    public void start() {
        Processor processor = this.transport.getProcessor();
        if (!(processor instanceof FilterChain)) {
            throw new IllegalStateException("transport's processor has to be a FilterChain");
        }
        FilterChain filterChain = (FilterChain)processor;
        int idx = filterChain.indexOfType(MemcachedClientFilter.class);
        if (idx == -1) {
            throw new IllegalStateException("transport has to have MemcachedClientFilter in the FilterChain");
        }
        this.clientFilter = (MemcachedClientFilter)((Object)filterChain.get(idx));
        if (this.clientFilter == null) {
            throw new IllegalStateException("MemcachedClientFilter should not be null");
        }
        if (this.zkClient != null) {
            if (!this.preferRemoteConfig) {
                for (SocketAddress address : this.servers) {
                    this.addServer(address);
                }
            } else if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "local config has been ignored because preferRemoteConfig is true. servers={0}", this.servers);
            }
            this.zooKeeperServerListPath = this.zkClient.registerBarrier(this.cacheName, this.zkListener, null);
        } else {
            for (SocketAddress address : this.servers) {
                this.addServer(address);
            }
        }
    }

    @Override
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
        this.servers.clear();
        this.consistentHash.clear();
        if (this.connectionPool != null) {
            this.connectionPool.destroy();
        }
        if (this.zkClient != null) {
            this.zkClient.unregisterBarrier(this.cacheName);
        }
    }

    @Override
    public boolean addServer(SocketAddress serverAddress) {
        return this.addServer(serverAddress, true);
    }

    private boolean addServer(SocketAddress serverAddress, boolean initial) {
        block8: {
            if (serverAddress == null) {
                return true;
            }
            if (this.connectionPool != null) {
                try {
                    this.connectionPool.createAllMinObjects(serverAddress);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to create min connections in the pool. address=" + serverAddress, e);
                    }
                    try {
                        this.connectionPool.destroy(serverAddress);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (initial) break block8;
                    return false;
                }
            }
        }
        this.consistentHash.add(serverAddress);
        this.servers.add(serverAddress);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "added the server to the consistent hash successfully. address={0}", serverAddress);
        }
        return true;
    }

    @Override
    public void removeServer(SocketAddress serverAddress) {
        this.removeServer(serverAddress, true);
    }

    private void removeServer(SocketAddress serverAddress, boolean forcibly) {
        block10: {
            if (serverAddress == null) {
                return;
            }
            if (!forcibly) {
                if (this.healthMonitorTask != null && this.healthMonitorTask.failure(serverAddress)) {
                    this.consistentHash.remove(serverAddress);
                    this.servers.remove(serverAddress);
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "removed the server from the consistent hash successfully. address={0}", serverAddress);
                    }
                }
            } else {
                this.consistentHash.remove(serverAddress);
                this.servers.remove(serverAddress);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "removed the server from the consistent hash successfully. address={0}", serverAddress);
                }
            }
            if (this.connectionPool != null) {
                try {
                    this.connectionPool.destroy(serverAddress);
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "removed the server in the pool successfully. address={0}", serverAddress);
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block10;
                    logger.log(Level.WARNING, "failed to remove connections in the pool", e);
                }
            }
        }
    }

    @Override
    public boolean isInServerList(SocketAddress serverAddress) {
        return this.consistentHash.hasValue(serverAddress);
    }

    @Override
    public List<SocketAddress> getCurrentServerList() {
        if (!this.servers.isEmpty()) {
            return new ArrayList<SocketAddress>(this.servers);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isZooKeeperSupported() {
        return this.zkClient != null;
    }

    @Override
    public String getZooKeeperServerListPath() {
        if (!this.isZooKeeperSupported()) {
            return null;
        }
        return this.zooKeeperServerListPath;
    }

    @Override
    public String getCurrentServerListFromZooKeeper() {
        String serverListString;
        if (!this.isZooKeeperSupported()) {
            return null;
        }
        byte[] serverListBytes = this.zkClient.getData(this.zooKeeperServerListPath, null);
        if (serverListBytes == null) {
            return null;
        }
        try {
            serverListString = new String(serverListBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "failed to decode the server list bytes");
            }
            return null;
        }
        return serverListString;
    }

    @Override
    public boolean setCurrentServerListOfZooKeeper(String cacheServerList) {
        byte[] serverListBytes;
        if (!this.isZooKeeperSupported()) {
            return false;
        }
        if (cacheServerList == null) {
            return false;
        }
        try {
            serverListBytes = cacheServerList.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "failed to eecode the server list");
            }
            return false;
        }
        return this.zkClient.setData(this.zooKeeperServerListPath, serverListBytes, -1) != null;
    }

    @Override
    public void addZooKeeperListener(BarrierListener listener) {
        if (!this.isZooKeeperSupported()) {
            return;
        }
        this.zkListener.addCustomListener(listener);
    }

    @Override
    public void removeZooKeeperListener(BarrierListener listener) {
        if (!this.isZooKeeperSupported()) {
            return;
        }
        this.zkListener.removeCustomListener(listener);
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public boolean set(K key, V value, int expirationInSecs, boolean noReply) {
        return this.set(key, value, expirationInSecs, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(K key, V value, int expirationInSecs, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null || value == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, true);
        builder.op(noReply ? CommandOpcodes.SetQ : CommandOpcodes.Set);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        BufferWrapper<V> valueWrapper = BufferWrapper.wrap(value, this.transport.getMemoryManager());
        builder.value(valueWrapper.getBuffer());
        builder.flags(valueWrapper.getType().flags);
        valueWrapper.recycle();
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to set. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to set. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public Map<K, Boolean> setMulti(Map<K, V> map, int expirationInSecs) {
        return this.setMulti(map, expirationInSecs, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, Boolean> setMulti(Map<K, V> map, int expirationInSecs, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        HashMap result = new HashMap();
        if (map == null || map.isEmpty()) {
            return result;
        }
        HashMap<SocketAddress, ArrayList<BufferWrapper<K>>> categorizedMap = new HashMap<SocketAddress, ArrayList<BufferWrapper<K>>>();
        for (K k : map.keySet()) {
            BufferWrapper<K> keyWrapper = BufferWrapper.wrap(k, this.transport.getMemoryManager());
            Buffer keyBuffer = keyWrapper.getBuffer();
            SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
            if (address == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to get the address from the consistent hash in setMulti(). key buffer={0}", keyBuffer);
                }
                keyWrapper.recycle();
                continue;
            }
            ArrayList<BufferWrapper<K>> keyList = (ArrayList<BufferWrapper<K>>)categorizedMap.get(address);
            if (keyList == null) {
                keyList = new ArrayList<BufferWrapper<K>>();
                categorizedMap.put(address, keyList);
            }
            keyList.add(keyWrapper);
        }
        for (Map.Entry entry : categorizedMap.entrySet()) {
            SocketAddress address = (SocketAddress)entry.getKey();
            List keyList = (List)entry.getValue();
            try {
                this.sendSetMulti((SocketAddress)entry.getKey(), keyList, map, expirationInSecs, writeTimeoutInMillis, responseTimeoutInMillis, result);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute setMulti(). address=" + address + ", keySize=" + keyList.size(), ie);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute setMulti(). address=" + address + ", keyList=" + keyList, ie);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute setMulti(). address=" + address + ", keySize=" + keyList.size(), e);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute setMulti(). address=" + address + ", keyList=" + keyList, e);
            }
            finally {
                GrizzlyMemcachedCache.recycleBufferWrappers(keyList);
            }
        }
        return result;
    }

    @Override
    public boolean add(K key, V value, int expirationInSecs, boolean noReply) {
        return this.add(key, value, expirationInSecs, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(K key, V value, int expirationInSecs, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null || value == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, true);
        builder.op(noReply ? CommandOpcodes.AddQ : CommandOpcodes.Add);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        BufferWrapper<V> valueWrapper = BufferWrapper.wrap(value, this.transport.getMemoryManager());
        builder.value(valueWrapper.getBuffer());
        builder.flags(valueWrapper.getType().flags);
        valueWrapper.recycle();
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to add. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to add. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean replace(K key, V value, int expirationInSecs, boolean noReply) {
        return this.replace(key, value, expirationInSecs, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V value, int expirationInSecs, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null || value == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, true);
        builder.op(noReply ? CommandOpcodes.ReplaceQ : CommandOpcodes.Replace);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        BufferWrapper<V> valueWrapper = BufferWrapper.wrap(value, this.transport.getMemoryManager());
        builder.value(valueWrapper.getBuffer());
        builder.flags(valueWrapper.getType().flags);
        valueWrapper.recycle();
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to replace. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to replace. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean cas(K key, V value, int expirationInSecs, long cas, boolean noReply) {
        return this.cas(key, value, expirationInSecs, cas, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cas(K key, V value, int expirationInSecs, long cas, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null || value == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, true);
        builder.op(noReply ? CommandOpcodes.SetQ : CommandOpcodes.Set);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.cas(cas);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        BufferWrapper<V> valueWrapper = BufferWrapper.wrap(value, this.transport.getMemoryManager());
        builder.value(valueWrapper.getBuffer());
        builder.flags(valueWrapper.getType().flags);
        valueWrapper.recycle();
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to set with cas. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to set with cas. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public Map<K, Boolean> casMulti(Map<K, ValueWithCas<V>> map, int expirationInSecs) {
        return this.casMulti(map, expirationInSecs, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, Boolean> casMulti(Map<K, ValueWithCas<V>> map, int expirationInSecs, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        HashMap result = new HashMap();
        if (map == null || map.isEmpty()) {
            return result;
        }
        HashMap<SocketAddress, ArrayList<BufferWrapper<K>>> categorizedMap = new HashMap<SocketAddress, ArrayList<BufferWrapper<K>>>();
        for (K k : map.keySet()) {
            BufferWrapper<K> keyWrapper = BufferWrapper.wrap(k, this.transport.getMemoryManager());
            Buffer keyBuffer = keyWrapper.getBuffer();
            SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
            if (address == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to get the address from the consistent hash in casMulti(). key buffer={0}", keyBuffer);
                }
                keyWrapper.recycle();
                continue;
            }
            ArrayList<BufferWrapper<K>> keyList = (ArrayList<BufferWrapper<K>>)categorizedMap.get(address);
            if (keyList == null) {
                keyList = new ArrayList<BufferWrapper<K>>();
                categorizedMap.put(address, keyList);
            }
            keyList.add(keyWrapper);
        }
        for (Map.Entry entry : categorizedMap.entrySet()) {
            SocketAddress address = (SocketAddress)entry.getKey();
            List keyList = (List)entry.getValue();
            try {
                this.sendCasMulti((SocketAddress)entry.getKey(), keyList, map, expirationInSecs, writeTimeoutInMillis, responseTimeoutInMillis, result);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute casMulti(). address=" + address + ", keySize=" + keyList.size(), ie);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute casMulti(). address=" + address + ", keyList=" + keyList, ie);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute casMulti(). address=" + address + ", keySize=" + keyList.size(), e);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute casMulti(). address=" + address + ", keyList=" + keyList, e);
            }
            finally {
                GrizzlyMemcachedCache.recycleBufferWrappers(keyList);
            }
        }
        return result;
    }

    @Override
    public boolean append(K key, V value, boolean noReply) {
        return this.append(key, value, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean append(K key, V value, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null || value == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, true);
        builder.op(noReply ? CommandOpcodes.AppendQ : CommandOpcodes.Append);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        BufferWrapper<V> valueWrapper = BufferWrapper.wrap(value, this.transport.getMemoryManager());
        builder.value(valueWrapper.getBuffer());
        valueWrapper.recycle();
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to append. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to append. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean prepend(K key, V value, boolean noReply) {
        return this.prepend(key, value, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepend(K key, V value, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null || value == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, true);
        builder.op(noReply ? CommandOpcodes.PrependQ : CommandOpcodes.Prepend);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        BufferWrapper<V> valueWrapper = BufferWrapper.wrap(value, this.transport.getMemoryManager());
        builder.value(valueWrapper.getBuffer());
        valueWrapper.recycle();
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to prepend. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to prepend. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public Map<K, V> getMulti(Set<K> keys) {
        return this.getMulti(keys, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getMulti(Set<K> keys, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        HashMap result = new HashMap();
        if (keys == null || keys.isEmpty()) {
            return result;
        }
        HashMap<SocketAddress, ArrayList<BufferWrapper<K>>> categorizedMap = new HashMap<SocketAddress, ArrayList<BufferWrapper<K>>>();
        for (K k : keys) {
            BufferWrapper<K> keyWrapper = BufferWrapper.wrap(k, this.transport.getMemoryManager());
            Buffer keyBuffer = keyWrapper.getBuffer();
            SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
            if (address == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to get the address from the consistent hash in getMulti(). key buffer={0}", keyBuffer);
                }
                keyWrapper.recycle();
                continue;
            }
            ArrayList<BufferWrapper<K>> keyList = (ArrayList<BufferWrapper<K>>)categorizedMap.get(address);
            if (keyList == null) {
                keyList = new ArrayList<BufferWrapper<K>>();
                categorizedMap.put(address, keyList);
            }
            keyList.add(keyWrapper);
        }
        for (Map.Entry entry : categorizedMap.entrySet()) {
            SocketAddress address = (SocketAddress)entry.getKey();
            List keyList = (List)entry.getValue();
            try {
                this.sendGetMulti((SocketAddress)entry.getKey(), keyList, writeTimeoutInMillis, responseTimeoutInMillis, result);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute getMulti(). address=" + address + ", keySize=" + keyList.size(), ie);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute getMulti(). address=" + address + ", keyList=" + keyList, ie);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute getMulti(). address=" + address + ", keySize=" + keyList.size(), e);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute getMulti(). address=" + address + ", keyList=" + keyList, e);
            }
            finally {
                GrizzlyMemcachedCache.recycleBufferWrappers(keyList);
            }
        }
        return result;
    }

    @Override
    public V get(K key, boolean noReply) {
        return this.get(key, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return null;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, false);
        builder.op(noReply ? CommandOpcodes.GetQ : CommandOpcodes.Get);
        builder.noReply(false);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return null;
        }
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result != null) {
                Object object = result;
                return (V)object;
            }
            V v = null;
            return v;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get. address=" + address + ", request=" + request, ie);
            }
            V v = null;
            return v;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get. address=" + address + ", request=" + request, e);
            }
            V v = null;
            return v;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public ValueWithKey<K, V> getKey(K key, boolean noReply) {
        return this.getKey(key, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueWithKey<K, V> getKey(K key, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return null;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, false);
        builder.op(noReply ? CommandOpcodes.GetKQ : CommandOpcodes.GetK);
        builder.noReply(false);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return null;
        }
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result != null) {
                ValueWithKey valueWithKey = (ValueWithKey)result;
                return valueWithKey;
            }
            ValueWithKey<K, V> valueWithKey = null;
            return valueWithKey;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get with key. address=" + address + ", request=" + request, ie);
            }
            ValueWithKey<K, V> valueWithKey = null;
            return valueWithKey;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get with key. address=" + address + ", request=" + request, e);
            }
            ValueWithKey<K, V> valueWithKey = null;
            return valueWithKey;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public ValueWithCas<V> gets(K key, boolean noReply) {
        return this.gets(key, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueWithCas<V> gets(K key, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return null;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, false);
        builder.op(noReply ? CommandOpcodes.GetsQ : CommandOpcodes.Gets);
        builder.noReply(false);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return null;
        }
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result != null) {
                ValueWithCas valueWithCas = (ValueWithCas)result;
                return valueWithCas;
            }
            ValueWithCas<V> valueWithCas = null;
            return valueWithCas;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get with cas. address=" + address + ", request=" + request, ie);
            }
            ValueWithCas<V> valueWithCas = null;
            return valueWithCas;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get with cas. address=" + address + ", request=" + request, e);
            }
            ValueWithCas<V> valueWithCas = null;
            return valueWithCas;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public Map<K, ValueWithCas<V>> getsMulti(Set<K> keys) {
        return this.getsMulti(keys, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ValueWithCas<V>> getsMulti(Set<K> keys, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        HashMap result = new HashMap();
        if (keys == null || keys.isEmpty()) {
            return result;
        }
        HashMap<SocketAddress, ArrayList<BufferWrapper<K>>> categorizedMap = new HashMap<SocketAddress, ArrayList<BufferWrapper<K>>>();
        for (K k : keys) {
            BufferWrapper<K> keyWrapper = BufferWrapper.wrap(k, this.transport.getMemoryManager());
            Buffer keyBuffer = keyWrapper.getBuffer();
            SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
            if (address == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to get the address from the consistent hash in getsMulti(). key buffer={0}", keyBuffer);
                }
                keyWrapper.recycle();
                continue;
            }
            ArrayList<BufferWrapper<K>> keyList = (ArrayList<BufferWrapper<K>>)categorizedMap.get(address);
            if (keyList == null) {
                keyList = new ArrayList<BufferWrapper<K>>();
                categorizedMap.put(address, keyList);
            }
            keyList.add(keyWrapper);
        }
        for (Map.Entry entry : categorizedMap.entrySet()) {
            SocketAddress address = (SocketAddress)entry.getKey();
            List keyList = (List)entry.getValue();
            try {
                this.sendGetsMulti((SocketAddress)entry.getKey(), keyList, writeTimeoutInMillis, responseTimeoutInMillis, result);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute getsMulti(). address=" + address + ", keySize=" + keyList.size(), ie);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute getsMulti(). address=" + address + ", keyList=" + keyList, ie);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute getsMulti(). address=" + address + ", keySize=" + keyList.size(), e);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute getsMulti(). address=" + address + ", keyList=" + keyList, e);
            }
            finally {
                GrizzlyMemcachedCache.recycleBufferWrappers(keyList);
            }
        }
        return result;
    }

    @Override
    public V gat(K key, int expirationInSecs, boolean noReply) {
        return this.gat(key, expirationInSecs, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V gat(K key, int expirationInSecs, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return null;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, false);
        builder.op(noReply ? CommandOpcodes.GATQ : CommandOpcodes.GAT);
        builder.noReply(false);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return null;
        }
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result != null) {
                Object object = result;
                return (V)object;
            }
            V v = null;
            return v;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get and touch. address=" + address + ", request=" + request, ie);
            }
            V v = null;
            return v;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to get and touch. address=" + address + ", request=" + request, e);
            }
            V v = null;
            return v;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean delete(K key, boolean noReply) {
        return this.delete(key, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(K key, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, false);
        builder.op(noReply ? CommandOpcodes.DeleteQ : CommandOpcodes.Delete);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to delete. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to delete. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public Map<K, Boolean> deleteMulti(Set<K> keys) {
        return this.deleteMulti(keys, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, Boolean> deleteMulti(Set<K> keys, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        HashMap result = new HashMap();
        if (keys == null || keys.isEmpty()) {
            return result;
        }
        HashMap<SocketAddress, ArrayList<BufferWrapper<K>>> categorizedMap = new HashMap<SocketAddress, ArrayList<BufferWrapper<K>>>();
        for (K k : keys) {
            BufferWrapper<K> keyWrapper = BufferWrapper.wrap(k, this.transport.getMemoryManager());
            Buffer keyBuffer = keyWrapper.getBuffer();
            SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
            if (address == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to get the address from the consistent hash in deleteMulti(). key buffer={0}", keyBuffer);
                }
                keyWrapper.recycle();
                continue;
            }
            ArrayList<BufferWrapper<K>> keyList = (ArrayList<BufferWrapper<K>>)categorizedMap.get(address);
            if (keyList == null) {
                keyList = new ArrayList<BufferWrapper<K>>();
                categorizedMap.put(address, keyList);
            }
            keyList.add(keyWrapper);
        }
        for (Map.Entry entry : categorizedMap.entrySet()) {
            SocketAddress address = (SocketAddress)entry.getKey();
            List keyList = (List)entry.getValue();
            try {
                this.sendDeleteMulti((SocketAddress)entry.getKey(), keyList, writeTimeoutInMillis, responseTimeoutInMillis, result);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute deleteMulti(). address=" + address + ", keySize=" + keyList.size(), ie);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute deleteMulti(). address=" + address + ", keyList=" + keyList, ie);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to execute deleteMulti(). address=" + address + ", keySize=" + keyList.size(), e);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "failed to execute deleteMulti(). address=" + address + ", keyList=" + keyList, e);
            }
            finally {
                GrizzlyMemcachedCache.recycleBufferWrappers(keyList);
            }
        }
        return result;
    }

    @Override
    public long incr(K key, long delta, long initial, int expirationInSecs, boolean noReply) {
        return this.incr(key, delta, initial, expirationInSecs, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incr(K key, long delta, long initial, int expirationInSecs, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return -1L;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, false);
        builder.op(noReply ? CommandOpcodes.IncrementQ : CommandOpcodes.Increment);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        builder.delta(delta);
        builder.initial(initial);
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return -1L;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                long l = -1L;
                return l;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result != null) {
                long l = (Long)result;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to increase. address=" + address + ", request=" + request, ie);
            }
            long l = -1L;
            return l;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to increase. address=" + address + ", request=" + request, e);
            }
            long l = -1L;
            return l;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public long decr(K key, long delta, long initial, int expirationInSecs, boolean noReply) {
        return this.decr(key, delta, initial, expirationInSecs, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long decr(K key, long delta, long initial, int expirationInSecs, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return -1L;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, false);
        builder.op(noReply ? CommandOpcodes.DecrementQ : CommandOpcodes.Decrement);
        builder.noReply(noReply);
        builder.opaque(noReply ? GrizzlyMemcachedCache.generateOpaque() : 0);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        builder.delta(delta);
        builder.initial(initial);
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return -1L;
        }
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                long l = -1L;
                return l;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result != null) {
                long l = (Long)result;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to decrease. address=" + address + ", request=" + request, ie);
            }
            long l = -1L;
            return l;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to decrease. address=" + address + ", request=" + request, e);
            }
            long l = -1L;
            return l;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public String saslAuth(SocketAddress address, String mechanism, byte[] data) {
        return this.saslAuth(address, mechanism, data, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    @Override
    public String saslAuth(SocketAddress address, String mechanism, byte[] data, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String saslStep(SocketAddress address, String mechanism, byte[] data) {
        return this.saslStep(address, mechanism, data, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    @Override
    public String saslStep(SocketAddress address, String mechanism, byte[] data, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String saslList(SocketAddress address) {
        return this.saslList(address, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    @Override
    public String saslList(SocketAddress address, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> stats(SocketAddress address) {
        return this.stats(address, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    @Override
    public Map<String, String> stats(SocketAddress address, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        return this.statsItems(address, null, writeTimeoutInMillis, responseTimeoutInMillis);
    }

    @Override
    public Map<String, String> statsItems(SocketAddress address, String item) {
        return this.statsItems(address, item, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> statsItems(SocketAddress address, String item, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean quit(SocketAddress address, boolean noReply) {
        return this.quit(address, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean quit(SocketAddress address, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (address == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, false, false);
        builder.op(noReply ? CommandOpcodes.QuitQ : CommandOpcodes.Quit);
        builder.noReply(noReply);
        MemcachedRequest request = builder.build();
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to quit. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to quit. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean flushAll(SocketAddress address, int expirationInSecs, boolean noReply) {
        return this.flushAll(address, expirationInSecs, noReply, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAll(SocketAddress address, int expirationInSecs, boolean noReply, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (address == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(expirationInSecs > 0, false, false);
        builder.op(noReply ? CommandOpcodes.FlushQ : CommandOpcodes.Flush);
        builder.noReply(noReply);
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        try {
            if (noReply) {
                this.sendNoReply(address, request);
                boolean bl = true;
                return bl;
            }
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to flush. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to flush. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean touch(K key, int expirationInSecs) {
        return this.touch(key, expirationInSecs, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean touch(K key, int expirationInSecs, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (key == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, false);
        builder.op(CommandOpcodes.Touch);
        builder.noReply(false);
        builder.originKey(key);
        BufferWrapper<K> keyWrapper = BufferWrapper.wrap(key, this.transport.getMemoryManager());
        Buffer keyBuffer = keyWrapper.getBuffer();
        builder.key(keyBuffer);
        keyWrapper.recycle();
        builder.expirationInSecs(expirationInSecs);
        MemcachedRequest request = builder.build();
        SocketAddress address = this.consistentHash.get(keyBuffer.toByteBuffer());
        if (address == null) {
            builder.recycle();
            return false;
        }
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to touch. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to touch. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean noop(SocketAddress address) {
        return this.noop(address, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noop(SocketAddress address, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (address == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, false, false);
        builder.op(CommandOpcodes.Noop);
        builder.opaque(GrizzlyMemcachedCache.generateOpaque());
        builder.noReply(false);
        MemcachedRequest request = builder.build();
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the noop operation. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the noop operation. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public boolean verbosity(SocketAddress address, int verbosity) {
        return this.verbosity(address, verbosity, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verbosity(SocketAddress address, int verbosity, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (address == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, false, false);
        builder.op(CommandOpcodes.Verbosity);
        builder.noReply(false);
        builder.verbosity(verbosity);
        MemcachedRequest request = builder.build();
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the vebosity operation. address=" + address + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the vebosity operation. address=" + address + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    @Override
    public String version(SocketAddress address) {
        return this.version(address, this.writeTimeoutInMillis, this.responseTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String version(SocketAddress address, long writeTimeoutInMillis, long responseTimeoutInMillis) {
        if (address == null) {
            return null;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, false, false);
        builder.op(CommandOpcodes.Version);
        builder.noReply(false);
        MemcachedRequest request = builder.build();
        try {
            Object result = this.send(address, request, writeTimeoutInMillis, responseTimeoutInMillis);
            if (result instanceof String) {
                String string = (String)result;
                return string;
            }
            String string = null;
            return string;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the version operation. address=" + address + ", request=" + request, ie);
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the version operation. address=" + address + ", request=" + request, e);
            }
            String string = null;
            return string;
        }
        finally {
            builder.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConnectionWithNoopCommand(Connection<SocketAddress> connection) {
        if (connection == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, false, false);
        builder.op(CommandOpcodes.Noop);
        builder.opaque(GrizzlyMemcachedCache.generateOpaque());
        builder.noReply(false);
        MemcachedRequest request = builder.build();
        try {
            GrizzlyFuture future = connection.write((Object)new MemcachedRequest[]{request});
            if (this.writeTimeoutInMillis > 0L) {
                future.get(this.writeTimeoutInMillis, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
            Object result = this.clientFilter.getCorrelatedResponse(connection, request, this.responseTimeoutInMillis);
            if (result instanceof Boolean) {
                boolean bl = (Boolean)result;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the noop operation. connection=" + connection + ", request=" + request, ie);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to execute the noop operation. connection=" + connection + ", request=" + request, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConnectionWithVersionCommand(Connection<SocketAddress> connection) {
        if (connection == null) {
            return false;
        }
        MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, false, false);
        builder.op(CommandOpcodes.Version);
        builder.noReply(false);
        MemcachedRequest request = builder.build();
        try {
            GrizzlyFuture future = connection.write((Object)new MemcachedRequest[]{request});
            if (this.writeTimeoutInMillis > 0L) {
                future.get(this.writeTimeoutInMillis, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
            if (this.clientFilter == null) {
                throw new IllegalStateException("client filter must not be null");
            }
            Object result = this.clientFilter.getCorrelatedResponse(connection, request, this.responseTimeoutInMillis);
            boolean bl = result instanceof String;
            return bl;
        }
        catch (TimeoutException te) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to check the connection. connection=" + connection, te);
            }
            boolean bl = false;
            return bl;
        }
        catch (ExecutionException ee) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to check the connection. connection=" + connection, ee);
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to check the connection. connection=" + connection, ie);
            }
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            builder.recycle();
        }
    }

    private void sendNoReply(final SocketAddress address, final MemcachedRequest request) throws PoolExhaustedException, NoValidObjectException, TimeoutException, InterruptedException {
        Connection<SocketAddress> connection;
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (this.connectionPool == null) {
            throw new IllegalStateException("connection pool must not be null");
        }
        try {
            connection = this.connectionPool.borrowObject(address, this.connectTimeoutInMillis);
        }
        catch (PoolExhaustedException pee) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", pee);
            }
            throw pee;
        }
        catch (NoValidObjectException nvoe) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", nvoe);
            }
            this.removeServer(address, false);
            throw nvoe;
        }
        catch (TimeoutException te) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", te);
            }
            throw te;
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", ie);
            }
            throw ie;
        }
        if (request.isNoReply()) {
            connection.write((Object)new MemcachedRequest[]{request}, (CompletionHandler)new CompletionHandler<WriteResult<MemcachedRequest[], SocketAddress>>(){

                public void cancelled() {
                    GrizzlyMemcachedCache.this.returnConnectionSafely(address, (Connection<SocketAddress>)connection);
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to send the request. request={0}, connection={1}", new Object[]{request, connection});
                    }
                }

                public void failed(Throwable t) {
                    block3: {
                        try {
                            GrizzlyMemcachedCache.this.connectionPool.removeObject(address, connection);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.SEVERE)) break block3;
                            logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
                        }
                    }
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to send the request. request=" + request + ", connection=" + connection, t);
                    }
                }

                public void completed(WriteResult<MemcachedRequest[], SocketAddress> result) {
                    GrizzlyMemcachedCache.this.returnConnectionSafely(address, (Connection<SocketAddress>)connection);
                }

                public void updated(WriteResult<MemcachedRequest[], SocketAddress> result) {
                }
            });
        }
    }

    private boolean sendNoReplySafely(Connection<SocketAddress> connection, MemcachedRequest request) {
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isNoReply()) {
            GrizzlyFuture future = connection.write((Object)new MemcachedRequest[]{request});
            try {
                future.get(this.writeTimeoutInMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to check the connection. connection=" + connection, ie);
                }
                Thread.currentThread().interrupt();
                return false;
            }
            catch (ExecutionException ee) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to check the connection. connection=" + connection, ee);
                }
                return false;
            }
            catch (TimeoutException te) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to check the connection. connection=" + connection, te);
                }
                return false;
            }
        }
        return true;
    }

    private Object send(SocketAddress address, MemcachedRequest request, long writeTimeoutInMillis, long responseTimeoutInMillis) throws TimeoutException, InterruptedException, PoolExhaustedException, NoValidObjectException, ExecutionException {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isNoReply()) {
            throw new IllegalStateException("request type is no reply");
        }
        return this.sendInternal(address, new MemcachedRequest[]{request}, writeTimeoutInMillis, responseTimeoutInMillis, null);
    }

    private void sendGetMulti(SocketAddress address, List<BufferWrapper<K>> keyList, long writeTimeoutInMillis, long responseTimeoutInMillis, Map<K, V> result) throws ExecutionException, TimeoutException, InterruptedException, PoolExhaustedException, NoValidObjectException {
        if (address == null || keyList == null || keyList.isEmpty() || result == null) {
            return;
        }
        MemcachedRequest[] requests = new MemcachedRequest[keyList.size()];
        BufferWrapper.BufferType keyType = !keyList.isEmpty() ? keyList.get(0).getType() : null;
        for (int i = 0; i < keyList.size(); ++i) {
            MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, false);
            builder.originKeyType(keyType);
            builder.originKey(keyList.get(i).getOrigin());
            builder.key(keyList.get(i).getBuffer());
            if (i == keyList.size() - 1) {
                builder.noReply(false);
                builder.op(CommandOpcodes.Get);
            } else {
                builder.noReply(true);
                builder.op(CommandOpcodes.GetQ);
                builder.opaque(GrizzlyMemcachedCache.generateOpaque());
            }
            requests[i] = builder.build();
            builder.recycle();
        }
        this.sendInternal(address, requests, writeTimeoutInMillis, responseTimeoutInMillis, result);
    }

    private void sendGetsMulti(SocketAddress address, List<BufferWrapper<K>> keyList, long writeTimeoutInMillis, long responseTimeoutInMillis, Map<K, ValueWithCas<V>> result) throws ExecutionException, TimeoutException, InterruptedException, PoolExhaustedException, NoValidObjectException {
        if (address == null || keyList == null || keyList.isEmpty() || result == null) {
            return;
        }
        MemcachedRequest[] requests = new MemcachedRequest[keyList.size()];
        BufferWrapper.BufferType keyType = !keyList.isEmpty() ? keyList.get(0).getType() : null;
        for (int i = 0; i < keyList.size(); ++i) {
            MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, false);
            builder.originKeyType(keyType);
            builder.originKey(keyList.get(i).getOrigin());
            builder.key(keyList.get(i).getBuffer());
            if (i == keyList.size() - 1) {
                builder.noReply(false);
                builder.op(CommandOpcodes.Gets);
            } else {
                builder.noReply(true);
                builder.op(CommandOpcodes.GetsQ);
                builder.opaque(GrizzlyMemcachedCache.generateOpaque());
            }
            requests[i] = builder.build();
            builder.recycle();
        }
        this.sendInternal(address, requests, writeTimeoutInMillis, responseTimeoutInMillis, result);
    }

    private void sendSetMulti(SocketAddress address, List<BufferWrapper<K>> keyList, Map<K, V> map, int expirationInSecs, long writeTimeoutInMillis, long responseTimeoutInMillis, Map<K, Boolean> result) throws ExecutionException, TimeoutException, InterruptedException, PoolExhaustedException, NoValidObjectException {
        if (address == null || keyList == null || keyList.isEmpty() || result == null) {
            return;
        }
        MemcachedRequest[] requests = new MemcachedRequest[keyList.size()];
        BufferWrapper.BufferType keyType = !keyList.isEmpty() ? keyList.get(0).getType() : null;
        for (int i = 0; i < keyList.size(); ++i) {
            MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, true);
            if (i == keyList.size() - 1) {
                builder.op(CommandOpcodes.Set);
                builder.noReply(false);
                builder.opaque(0);
            } else {
                builder.op(CommandOpcodes.SetQ);
                builder.noReply(true);
                builder.opaque(GrizzlyMemcachedCache.generateOpaque());
            }
            K originKey = keyList.get(i).getOrigin();
            builder.originKeyType(keyType);
            builder.originKey(originKey);
            builder.key(keyList.get(i).getBuffer());
            BufferWrapper<V> valueWrapper = BufferWrapper.wrap(map.get(originKey), this.transport.getMemoryManager());
            builder.value(valueWrapper.getBuffer());
            builder.flags(valueWrapper.getType().flags);
            valueWrapper.recycle();
            builder.expirationInSecs(expirationInSecs);
            requests[i] = builder.build();
            builder.recycle();
        }
        this.sendInternal(address, requests, writeTimeoutInMillis, responseTimeoutInMillis, result);
    }

    private void sendCasMulti(SocketAddress address, List<BufferWrapper<K>> keyList, Map<K, ValueWithCas<V>> map, int expirationInSecs, long writeTimeoutInMillis, long responseTimeoutInMillis, Map<K, Boolean> result) throws ExecutionException, TimeoutException, InterruptedException, PoolExhaustedException, NoValidObjectException {
        if (address == null || keyList == null || keyList.isEmpty() || result == null) {
            return;
        }
        MemcachedRequest[] requests = new MemcachedRequest[keyList.size()];
        BufferWrapper.BufferType keyType = !keyList.isEmpty() ? keyList.get(0).getType() : null;
        for (int i = 0; i < keyList.size(); ++i) {
            MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(true, true, true);
            if (i == keyList.size() - 1) {
                builder.op(CommandOpcodes.Set);
                builder.noReply(false);
                builder.opaque(0);
            } else {
                builder.op(CommandOpcodes.SetQ);
                builder.noReply(true);
                builder.opaque(GrizzlyMemcachedCache.generateOpaque());
            }
            K originKey = keyList.get(i).getOrigin();
            builder.originKeyType(keyType);
            builder.originKey(originKey);
            builder.key(keyList.get(i).getBuffer());
            ValueWithCas<V> vwc = map.get(originKey);
            if (vwc != null) {
                BufferWrapper<V> valueWrapper = BufferWrapper.wrap(vwc.getValue(), this.transport.getMemoryManager());
                builder.value(valueWrapper.getBuffer());
                builder.flags(valueWrapper.getType().flags);
                valueWrapper.recycle();
                builder.cas(vwc.getCas());
            }
            builder.expirationInSecs(expirationInSecs);
            requests[i] = builder.build();
            builder.recycle();
        }
        this.sendInternal(address, requests, writeTimeoutInMillis, responseTimeoutInMillis, result);
    }

    private void sendDeleteMulti(SocketAddress address, List<BufferWrapper<K>> keyList, long writeTimeoutInMillis, long responseTimeoutInMillis, Map<K, Boolean> result) throws ExecutionException, TimeoutException, InterruptedException, PoolExhaustedException, NoValidObjectException {
        if (address == null || keyList == null || keyList.isEmpty() || result == null) {
            return;
        }
        MemcachedRequest[] requests = new MemcachedRequest[keyList.size()];
        BufferWrapper.BufferType keyType = !keyList.isEmpty() ? keyList.get(0).getType() : null;
        for (int i = 0; i < keyList.size(); ++i) {
            MemcachedRequest.Builder builder = MemcachedRequest.Builder.create(false, true, false);
            if (i == keyList.size() - 1) {
                builder.op(CommandOpcodes.Delete);
                builder.noReply(false);
                builder.opaque(0);
            } else {
                builder.op(CommandOpcodes.DeleteQ);
                builder.noReply(true);
                builder.opaque(GrizzlyMemcachedCache.generateOpaque());
            }
            K originKey = keyList.get(i).getOrigin();
            builder.originKeyType(keyType);
            builder.originKey(originKey);
            builder.key(keyList.get(i).getBuffer());
            requests[i] = builder.build();
            builder.recycle();
        }
        this.sendInternal(address, requests, writeTimeoutInMillis, responseTimeoutInMillis, result);
    }

    private Object sendInternal(SocketAddress address, MemcachedRequest[] requests, long writeTimeoutInMillis, long responseTimeoutInMillis, Map<K, ?> result) throws PoolExhaustedException, NoValidObjectException, InterruptedException, TimeoutException, ExecutionException {
        Map<K, Object> response;
        Connection<SocketAddress> connection;
        if (address == null || requests == null || requests.length == 0) {
            return null;
        }
        if (this.connectionPool == null) {
            throw new IllegalStateException("connection pool must not be null");
        }
        if (this.clientFilter == null) {
            throw new IllegalStateException("client filter must not be null");
        }
        boolean isMulti = result != null;
        try {
            connection = this.connectionPool.borrowObject(address, this.connectTimeoutInMillis);
        }
        catch (PoolExhaustedException pee) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", pee);
            }
            throw pee;
        }
        catch (NoValidObjectException nvoe) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", nvoe);
            }
            this.removeServer(address, false);
            throw nvoe;
        }
        catch (TimeoutException te) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", te);
            }
            throw te;
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "failed to get the connection. address=" + address + ", timeout=" + this.connectTimeoutInMillis + "ms", ie);
            }
            throw ie;
        }
        try {
            GrizzlyFuture future = connection.write((Object)requests);
            if (writeTimeoutInMillis > 0L) {
                future.get(writeTimeoutInMillis, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (ExecutionException ee) {
            block35: {
                try {
                    this.connectionPool.removeObject(address, connection);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block35;
                    logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
                }
            }
            throw ee;
        }
        catch (TimeoutException te) {
            block36: {
                try {
                    this.connectionPool.removeObject(address, connection);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block36;
                    logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
                }
            }
            throw te;
        }
        catch (InterruptedException ie) {
            block37: {
                try {
                    this.connectionPool.removeObject(address, connection);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block37;
                    logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
                }
            }
            throw ie;
        }
        catch (Exception unexpected) {
            block38: {
                try {
                    this.connectionPool.removeObject(address, connection);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block38;
                    logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
                }
            }
            throw new ExecutionException(unexpected);
        }
        try {
            response = !isMulti ? this.clientFilter.getCorrelatedResponse(connection, requests[0], responseTimeoutInMillis) : this.clientFilter.getMultiResponse(connection, requests, responseTimeoutInMillis, result);
        }
        catch (TimeoutException te) {
            this.returnConnectionSafely(address, connection);
            throw te;
        }
        catch (InterruptedException ie) {
            block39: {
                try {
                    this.connectionPool.removeObject(address, connection);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block39;
                    logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
                }
            }
            throw ie;
        }
        catch (Exception unexpected) {
            block40: {
                try {
                    this.connectionPool.removeObject(address, connection);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block40;
                    logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
                }
            }
            throw new ExecutionException(unexpected);
        }
        this.returnConnectionSafely(address, connection);
        return response;
    }

    private void returnConnectionSafely(SocketAddress address, Connection<SocketAddress> connection) {
        block7: {
            if (address == null || connection == null) {
                return;
            }
            if (connection.isOpen()) {
                try {
                    this.connectionPool.returnObject(address, connection);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "failed to return the connection. address=" + address + ", connection=" + connection, e);
                    }
                    break block7;
                }
            }
            try {
                this.connectionPool.removeObject(address, connection);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block7;
                logger.log(Level.SEVERE, "failed to remove the connection. address=" + address + ", connection=" + connection, e);
            }
        }
    }

    private static <K> void recycleBufferWrappers(List<BufferWrapper<K>> bufferWrapperList) {
        if (bufferWrapperList == null) {
            return;
        }
        for (BufferWrapper<K> wrapper : bufferWrapperList) {
            wrapper.recycle();
        }
    }

    private static int generateOpaque() {
        return opaqueIndex.getAndIncrement() & Integer.MAX_VALUE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GrizzlyMemcachedCache{");
        sb.append("cacheName='").append(this.cacheName).append('\'');
        sb.append(", transport=").append(this.transport);
        sb.append(", connectTimeoutInMillis=").append(this.connectTimeoutInMillis);
        sb.append(", writeTimeoutInMillis=").append(this.writeTimeoutInMillis);
        sb.append(", responseTimeoutInMillis=").append(this.responseTimeoutInMillis);
        sb.append(", connectionPool=").append(this.connectionPool);
        sb.append(", servers=").append(this.servers);
        sb.append(", healthMonitorIntervalInSecs=").append(this.healthMonitorIntervalInSecs);
        sb.append(", failover=").append(this.failover);
        sb.append(", preferRemoteConfig=").append(this.preferRemoteConfig);
        sb.append(", zkListener=").append(this.zkListener);
        sb.append(", zooKeeperServerListPath='").append(this.zooKeeperServerListPath).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class Builder<K, V>
    implements CacheBuilder<K, V> {
        private final String cacheName;
        private final GrizzlyMemcachedCacheManager manager;
        private final TCPNIOTransport transport;
        private Set<SocketAddress> servers = Collections.synchronizedSet(new HashSet());
        private long connectTimeoutInMillis = 5000L;
        private long writeTimeoutInMillis = 5000L;
        private long responseTimeoutInMillis = 10000L;
        private long healthMonitorIntervalInSecs = 60L;
        private boolean failover = true;
        private boolean preferRemoteConfig = false;
        private int minConnectionPerServer = 5;
        private int maxConnectionPerServer = Integer.MAX_VALUE;
        private long keepAliveTimeoutInSecs = 1800L;
        private boolean allowDisposableConnection = false;
        private boolean borrowValidation = false;
        private boolean returnValidation = false;
        private final ZKClient zkClient;

        public Builder(String cacheName, GrizzlyMemcachedCacheManager manager, TCPNIOTransport transport) {
            this.cacheName = cacheName;
            this.manager = manager;
            this.transport = transport;
            this.zkClient = manager.getZkClient();
        }

        @Override
        public GrizzlyMemcachedCache<K, V> build() {
            GrizzlyMemcachedCache cache = new GrizzlyMemcachedCache(this);
            cache.start();
            if (!this.manager.addCache(cache)) {
                cache.stop();
                throw new IllegalStateException("failed to add the cache because the CacheManager already stopped or the same cache name existed");
            }
            return cache;
        }

        public Builder<K, V> connectTimeoutInMillis(long connectTimeoutInMillis) {
            this.connectTimeoutInMillis = connectTimeoutInMillis;
            return this;
        }

        public Builder<K, V> writeTimeoutInMillis(long writeTimeoutInMillis) {
            this.writeTimeoutInMillis = writeTimeoutInMillis;
            return this;
        }

        public Builder<K, V> responseTimeoutInMillis(long responseTimeoutInMillis) {
            this.responseTimeoutInMillis = responseTimeoutInMillis;
            return this;
        }

        public Builder<K, V> minConnectionPerServer(int minConnectionPerServer) {
            this.minConnectionPerServer = minConnectionPerServer;
            return this;
        }

        public Builder<K, V> maxConnectionPerServer(int maxConnectionPerServer) {
            this.maxConnectionPerServer = maxConnectionPerServer;
            return this;
        }

        public Builder<K, V> keepAliveTimeoutInSecs(long keepAliveTimeoutInSecs) {
            this.keepAliveTimeoutInSecs = keepAliveTimeoutInSecs;
            return this;
        }

        public Builder<K, V> healthMonitorIntervalInSecs(long healthMonitorIntervalInSecs) {
            this.healthMonitorIntervalInSecs = healthMonitorIntervalInSecs;
            return this;
        }

        public Builder<K, V> allowDisposableConnection(boolean allowDisposableConnection) {
            this.allowDisposableConnection = allowDisposableConnection;
            return this;
        }

        public Builder<K, V> borrowValidation(boolean borrowValidation) {
            this.borrowValidation = borrowValidation;
            return this;
        }

        public Builder<K, V> returnValidation(boolean returnValidation) {
            this.returnValidation = returnValidation;
            return this;
        }

        public Builder<K, V> servers(Set<SocketAddress> servers) {
            if (servers != null && !servers.isEmpty()) {
                this.servers.addAll(servers);
            }
            return this;
        }

        public Builder<K, V> failover(boolean failover) {
            this.failover = failover;
            return this;
        }

        public Builder<K, V> retryCount(int retryCount) {
            return this;
        }

        public Builder<K, V> preferRemoteConfig(boolean preferRemoteConfig) {
            this.preferRemoteConfig = preferRemoteConfig;
            return this;
        }
    }

    private class HealthMonitorTask
    implements Runnable {
        private final Map<SocketAddress, Boolean> failures = DataStructures.getConcurrentMap();
        private final Map<SocketAddress, Boolean> revivals = DataStructures.getConcurrentMap();
        private final AtomicBoolean running = new AtomicBoolean();

        private HealthMonitorTask() {
        }

        public boolean failure(SocketAddress address) {
            if (address == null) {
                return true;
            }
            if (this.failures.get(address) == null && this.revivals.get(address) == null) {
                this.failures.put(address, Boolean.TRUE);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (GrizzlyMemcachedCache.this.transport == null) {
                throw new IllegalStateException("transport must not be null");
            }
            if (!this.running.compareAndSet(false, true)) {
                return;
            }
            try {
                this.revivals.clear();
                Set<SocketAddress> failuresSet = this.failures.keySet();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "try to check the failures in health monitor. failed list hint={0}, interval={1}secs", new Object[]{failuresSet, GrizzlyMemcachedCache.this.healthMonitorIntervalInSecs});
                } else if (logger.isLoggable(Level.INFO) && !failuresSet.isEmpty()) {
                    logger.log(Level.INFO, "try to check the failures in health monitor. failed list hint={0}, interval={1}secs", new Object[]{failuresSet, GrizzlyMemcachedCache.this.healthMonitorIntervalInSecs});
                }
                for (SocketAddress failure : failuresSet) {
                    try {
                        Connection c;
                        Connection connection;
                        TCPNIOConnectorHandler connectorHandler = TCPNIOConnectorHandler.builder((TCPNIOTransport)GrizzlyMemcachedCache.this.transport).setReuseAddress(true).build();
                        Future future = connectorHandler.connect((Object)failure);
                        try {
                            connection = GrizzlyMemcachedCache.this.connectTimeoutInMillis < 0L ? (Connection)future.get() : (Connection)future.get(GrizzlyMemcachedCache.this.connectTimeoutInMillis, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException ie) {
                            if (!future.cancel(false) && future.isDone() && (c = (Connection)future.get()) != null && c.isOpen()) {
                                c.closeSilently();
                            }
                            if (!logger.isLoggable(Level.SEVERE)) continue;
                            logger.log(Level.SEVERE, "failed to get the connection in health monitor. address=" + failure, ie);
                            continue;
                        }
                        catch (ExecutionException ee) {
                            if (!future.cancel(false) && future.isDone() && (c = (Connection)future.get()) != null && c.isOpen()) {
                                c.closeSilently();
                            }
                            if (!logger.isLoggable(Level.SEVERE)) continue;
                            logger.log(Level.SEVERE, "failed to get the connection in health monitor. address=" + failure, ee);
                            continue;
                        }
                        catch (TimeoutException te) {
                            if (!future.cancel(false) && future.isDone() && (c = (Connection)future.get()) != null && c.isOpen()) {
                                c.closeSilently();
                            }
                            if (!logger.isLoggable(Level.SEVERE)) continue;
                            logger.log(Level.SEVERE, "failed to get the connection in health monitor. address=" + failure, te);
                            continue;
                        }
                        if (GrizzlyMemcachedCache.this.validateConnectionWithVersionCommand((Connection<SocketAddress>)connection)) {
                            this.failures.remove(failure);
                            this.revivals.put(failure, Boolean.TRUE);
                        }
                        if (!connection.isOpen()) continue;
                        connection.closeSilently();
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logger.log(Level.SEVERE, "unexpected exception thrown", t);
                    }
                }
                Set<SocketAddress> revivalsSet = this.revivals.keySet();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "try to restore revivals in health monitor. revival list hint={0}, interval={1}secs", new Object[]{revivalsSet, GrizzlyMemcachedCache.this.healthMonitorIntervalInSecs});
                } else if (logger.isLoggable(Level.INFO) && !revivalsSet.isEmpty()) {
                    logger.log(Level.INFO, "try to restore revivals in health monitor. revival list hint={0}, interval={1}secs", new Object[]{revivalsSet, GrizzlyMemcachedCache.this.healthMonitorIntervalInSecs});
                }
                for (SocketAddress revival : revivalsSet) {
                    if (GrizzlyMemcachedCache.this.addServer(revival, false)) continue;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "the revival was failed again in health monitor. revival={0}", revival);
                    }
                    this.failures.put(revival, Boolean.TRUE);
                }
            }
            finally {
                this.running.set(false);
            }
        }
    }
}

