/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

public enum ResponseStatus {
    No_Error(0, "No error"),
    Key_Not_Found(1, "Key not found"),
    Key_Exists(2, "Key exists"),
    Value_Too_Large(3, "Value too large"),
    Invalid_Arguments(4, "Invalid arguments"),
    Item_Not_Stored(5, "Item not stored"),
    Incr_Decr_On_NonNumeric_Value(6, "Incr/Decr on non-numeric value"),
    VBucket_Belongs_To_Another_Server(7, "The vbucket belongs to another server"),
    Authentication_Error(8, "Authentication error"),
    Authentication_Continue(9, "Authentication continue"),
    Authentication_Required(32, "Authentication required or not successful"),
    Further_Authentication_Required(33, "Further authentication steps required"),
    Unknown_Command(129, "Unknown command"),
    Out_Of_Memory(130, "Out of memory"),
    Not_Supported(131, "Not supported"),
    Internal_Error(132, "Internal error"),
    Busy(133, "Busy"),
    Temporary_Failure(134, "Temporary failure");

    private final short status;
    private final String message;

    private ResponseStatus(int status, String message) {
        this.status = (short)(status & 0xFFFF);
        this.message = message;
    }

    public short status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public static ResponseStatus getResponseStatus(short status) {
        switch (status) {
            case 0: {
                return No_Error;
            }
            case 1: {
                return Key_Not_Found;
            }
            case 2: {
                return Key_Exists;
            }
            case 3: {
                return Value_Too_Large;
            }
            case 4: {
                return Invalid_Arguments;
            }
            case 5: {
                return Item_Not_Stored;
            }
            case 6: {
                return Incr_Decr_On_NonNumeric_Value;
            }
            case 7: {
                return VBucket_Belongs_To_Another_Server;
            }
            case 8: {
                return Authentication_Error;
            }
            case 9: {
                return Authentication_Continue;
            }
            case 32: {
                return Authentication_Required;
            }
            case 33: {
                return Further_Authentication_Required;
            }
            case 129: {
                return Unknown_Command;
            }
            case 130: {
                return Out_Of_Memory;
            }
            case 131: {
                return Not_Supported;
            }
            case 132: {
                return Internal_Error;
            }
            case 133: {
                return Busy;
            }
            case 134: {
                return Temporary_Failure;
            }
        }
        throw new IllegalArgumentException("invalid status");
    }
}

