/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached.zookeeper;

import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.memcached.MemcachedCache;
import org.glassfish.grizzly.memcached.zookeeper.CacheServerListBarrierListener;

public class PreferRemoteConfigBarrierListener
extends CacheServerListBarrierListener {
    private static final Logger LOGGER = Grizzly.logger(PreferRemoteConfigBarrierListener.class);

    public PreferRemoteConfigBarrierListener(MemcachedCache cache, Set<SocketAddress> cacheServerSet) {
        super(cache, cacheServerSet);
    }

    @Override
    public void onInit(String regionName, String path, byte[] remoteBytes) {
        String remoteCacheServerList;
        if (remoteBytes == null || remoteBytes.length == 0) {
            throw new IllegalStateException("remote config was not ready. path=" + path + ", cacheName=" + this.cacheName);
        }
        try {
            remoteCacheServerList = new String(remoteBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "failed to encode the cache server list from the remote. path=" + path + ", cacheName=" + this.cacheName, uee);
            }
            throw new IllegalStateException("remote config was not ready. path=" + path + ", cacheName=" + this.cacheName);
        }
        Set<SocketAddress> remoteCacheServers = PreferRemoteConfigBarrierListener.getAddressesFromStringList(remoteCacheServerList);
        if (remoteCacheServerList.isEmpty()) {
            throw new IllegalStateException("remote config was not ready. path=" + path + ", cacheName=" + this.cacheName);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "remote config is ready. remoteCacheServers={0}", remoteCacheServers);
        }
        this.localCacheServerSet.clear();
        for (SocketAddress address : remoteCacheServers) {
            this.localCacheServerSet.add(address);
            this.cache.addServer(address);
        }
        super.onInit(regionName, path, remoteBytes);
    }
}

