/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=NativeTypeLibrary.class)
final class NativeTypeLibraryGen
extends LibraryFactory<NativeTypeLibrary> {
    private static final Class<NativeTypeLibrary> LIBRARY_CLASS = NativeTypeLibraryGen.lazyLibraryClass();
    private static final Message HAS_NATIVE_TYPE = new MessageImpl("hasNativeType", 0, false, Boolean.TYPE, Object.class);
    private static final Message GET_NATIVE_TYPE = new MessageImpl("getNativeType", 1, false, Object.class, Object.class);
    private static final NativeTypeLibraryGen INSTANCE = new NativeTypeLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativeTypeLibraryGen() {
        super(LIBRARY_CLASS, List.of(HAS_NATIVE_TYPE, GET_NATIVE_TYPE));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NativeTypeLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected NativeTypeLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected NativeTypeLibrary createDelegate(NativeTypeLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NativeTypeLibrary lib = (NativeTypeLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.hasNativeType(receiver);
            }
            case 1: {
                return lib.getNativeType(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected NativeTypeLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NativeTypeLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NativeTypeLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.spi.NativeTypeLibrary", false, NativeTypeLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class Proxy
    extends NativeTypeLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean hasNativeType(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, HAS_NATIVE_TYPE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getNativeType(Object receiver_) {
            try {
                return this.lib.send(receiver_, GET_NATIVE_TYPE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class Delegate
    extends NativeTypeLibrary {
        @Node.Child
        private NativeTypeLibrary delegateLibrary;

        Delegate(NativeTypeLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean hasNativeType(Object receiver_) {
            if (NativeTypeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = NativeTypeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NativeTypeLibrary)NativeTypeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).hasNativeType(delegate);
            }
            return this.delegateLibrary.hasNativeType(receiver_);
        }

        @Override
        public Object getNativeType(Object receiver_) {
            if (NativeTypeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = NativeTypeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NativeTypeLibrary)NativeTypeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getNativeType(delegate);
            }
            return this.delegateLibrary.getNativeType(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(NativeTypeLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                NativeTypeLibrary exportLibrary = (NativeTypeLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (NativeTypeLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static abstract class CachedDispatch
    extends NativeTypeLibrary {
        @Node.Child
        NativeTypeLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NativeTypeLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public boolean hasNativeType(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeTypeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.hasNativeType(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getNativeType(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeTypeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getNativeType(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                NativeTypeLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (NativeTypeLibrary)this.insert((Node)((NativeTypeLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        NativeTypeLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NativeTypeLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NativeTypeLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends NativeTypeLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNativeType(Object receiver_) {
            return ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).hasNativeType(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getNativeType(Object receiver_) {
            return ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).getNativeType(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class Default
    extends LibraryExport<NativeTypeLibrary> {
        private Default() {
            super(NativeTypeLibrary.class, Object.class, false, false, 0);
        }

        protected NativeTypeLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NativeTypeLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativeTypeLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends NativeTypeLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasNativeType(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativeType(receiver);
            }
        }

        @GeneratedBy(value=NativeTypeLibrary.class)
        private static final class Cached
        extends NativeTypeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean hasNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasNativeType(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object getNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativeType(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NativeTypeLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=NativeTypeLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NativeTypeLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNativeType(Object receiver_) {
            assert (NativeTypeLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).hasNativeType(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getNativeType(Object receiver_) {
            assert (NativeTypeLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NativeTypeLibrary)INSTANCE.getUncached(receiver_)).getNativeType(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

