/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ContextvarsModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ContextvarsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.lib.PyContextCopyCurrent;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_contextvars")
public final class ContextvarsModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ContextvarsModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="Token", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.ContextVarsToken)
    @GenerateNodeFactory
    public static abstract class TokenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object construct(Object cls, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.TOKEN_ONLY_BY_CONTEXTVAR);
        }
    }

    @Builtin(name="Context", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.ContextVarsContext)
    @GenerateNodeFactory
    public static abstract class ContextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object construct(Object cls, @Cached PythonObjectFactory factory) {
            return factory.createContextVarsContext();
        }
    }

    @Builtin(name="ContextVar", minNumOfPositionalArgs=2, parameterNames={"cls", "name", "default"}, constructsClass=PythonBuiltinClassType.ContextVar)
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class ContextVarNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ContextvarsModuleBuiltinsClinicProviders.ContextVarNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        protected static Object constructDef(Object cls, TruffleString name, Object def, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile noValueProfile, @Cached PythonObjectFactory factory) {
            if (noValueProfile.profile(inliningTarget, PGuards.isNoValue(def))) {
                def = PContextVar.NO_DEFAULT;
            }
            return factory.createContextVar(name, def);
        }
    }

    @Builtin(name="copy_context", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetDefaultEncodingNode
    extends PythonBuiltinNode {
        @Specialization
        protected static PContextVarsContext copyCtx(@Bind(value="this") Node inliningTarget, @Cached PyContextCopyCurrent copyCurrent) {
            return copyCurrent.execute(inliningTarget);
        }
    }
}

