/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.SSLModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.SSLModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.ssl.CertUtils;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipher;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipherSelector;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorCode;
import com.oracle.graal.python.builtins.objects.ssl.SSLMethod;
import com.oracle.graal.python.builtins.objects.ssl.SSLProtocol;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyUnicodeFSDecoderNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.util.encoders.DecoderException;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="_ssl")
public final class SSLModuleBuiltins
extends PythonBuiltins {
    public static final TruffleLogger LOGGER;
    static final String J_DEFAULT_CIPHER_STRING = "DEFAULT:!aNULL:!eNULL:!MD5:!3DES:!DES:!RC4:!IDEA:!SEED:!aDSS:!SRP:!PSK";
    static final TruffleString T_DEFAULT_CIPHER_STRING;
    private static List<SSLProtocol> supportedProtocols;
    private static SSLProtocol minimumVersion;
    private static SSLProtocol maximumVersion;
    public static final SSLCipher[] defaultCiphers;
    public static final int SSL_CERT_NONE = 0;
    public static final int SSL_CERT_OPTIONAL = 1;
    public static final int SSL_CERT_REQUIRED = 2;
    public static final int X509_V_FLAG_CRL_CHECK = 4;
    public static final int X509_V_FLAG_CRL_CHECK_ALL = 8;
    private static final int X509_V_FLAG_X509_STRICT = 32;
    public static final int X509_V_FLAG_TRUSTED_FIRST = 32768;

    public static List<SSLProtocol> getSupportedProtocols() {
        assert (supportedProtocols != null) : "Uninitialized protocols";
        return supportedProtocols;
    }

    public static SSLProtocol getMinimumVersion() {
        return minimumVersion;
    }

    public static SSLProtocol getMaximumVersion() {
        return maximumVersion;
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SSLModuleBuiltinsFactory.getFactories();
    }

    private static synchronized void loadDefaults() {
        if (ImageInfo.inImageBuildtimeCode()) {
            throw new AssertionError((Object)"SSL module initialized at build time");
        }
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            ArrayList<SSLProtocol> protocols = new ArrayList<SSLProtocol>(SSLProtocol.values().length);
            for (SSLProtocol protocol : SSLProtocol.values()) {
                if (!SSLModuleBuiltins.tryProtocolAvailability(context, protocol)) continue;
                protocols.add(protocol);
            }
            supportedProtocols = Collections.unmodifiableList(protocols);
            if (!supportedProtocols.isEmpty()) {
                minimumVersion = supportedProtocols.get(0);
                maximumVersion = supportedProtocols.get(supportedProtocols.size() - 1);
            }
        }
        catch (PException | KeyManagementException | NoSuchAlgorithmException e) {
            supportedProtocols = new ArrayList<SSLProtocol>();
        }
    }

    private static boolean tryProtocolAvailability(SSLContext context, SSLProtocol protocol) {
        String[] protocols = new String[]{protocol.getName()};
        try {
            SSLEngine engine = context.createSSLEngine();
            engine.setUseClientMode(true);
            engine.setEnabledProtocols(protocols);
            engine.beginHandshake();
            return true;
        }
        catch (Exception e1) {
            try {
                SSLEngine engine = context.createSSLEngine();
                engine.setUseClientMode(false);
                engine.setEnabledProtocols(protocols);
                engine.beginHandshake();
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        SSLModuleBuiltins.loadDefaults();
        PythonModule module = core.lookupBuiltinModule(BuiltinNames.T__SSL);
        PythonObjectSlowPathFactory factory = core.factory();
        module.setAttribute(PythonUtils.tsLiteral("OPENSSL_VERSION_NUMBER"), 0);
        PTuple versionInfo = factory.createTuple(new int[]{0, 0, 0, 0, 0});
        module.setAttribute(PythonUtils.tsLiteral("OPENSSL_VERSION_INFO"), versionInfo);
        module.setAttribute(PythonUtils.tsLiteral("OPENSSL_VERSION"), PythonUtils.toTruffleStringUncached("GraalVM JSSE"));
        module.setAttribute(PythonUtils.tsLiteral("_DEFAULT_CIPHERS"), T_DEFAULT_CIPHER_STRING);
        module.setAttribute(PythonUtils.tsLiteral("_OPENSSL_API_VERSION"), versionInfo);
        module.setAttribute(PythonUtils.tsLiteral("CERT_NONE"), 0);
        module.setAttribute(PythonUtils.tsLiteral("CERT_OPTIONAL"), 1);
        module.setAttribute(PythonUtils.tsLiteral("CERT_REQUIRED"), 2);
        module.setAttribute(PythonUtils.tsLiteral("HAS_SNI"), true);
        module.setAttribute(PythonUtils.tsLiteral("HAS_ECDH"), false);
        module.setAttribute(PythonUtils.tsLiteral("HAS_NPN"), false);
        module.setAttribute(PythonUtils.tsLiteral("HAS_ALPN"), true);
        module.setAttribute(PythonUtils.tsLiteral("HAS_NEVER_CHECK_COMMON_NAME"), false);
        module.setAttribute(PythonUtils.tsLiteral("HAS_SSLv2"), false);
        boolean hasSSLv3 = supportedProtocols.contains((Object)SSLProtocol.SSLv3);
        module.setAttribute(PythonUtils.tsLiteral("HAS_SSLv3"), hasSSLv3);
        module.setAttribute(PythonUtils.tsLiteral("HAS_TLSv1"), supportedProtocols.contains((Object)SSLProtocol.TLSv1));
        module.setAttribute(PythonUtils.tsLiteral("HAS_TLSv1_1"), supportedProtocols.contains((Object)SSLProtocol.TLSv1_1));
        module.setAttribute(PythonUtils.tsLiteral("HAS_TLSv1_2"), supportedProtocols.contains((Object)SSLProtocol.TLSv1_2));
        module.setAttribute(PythonUtils.tsLiteral("HAS_TLSv1_3"), supportedProtocols.contains((Object)SSLProtocol.TLSv1_3));
        module.setAttribute(PythonUtils.tsLiteral("PROTO_MINIMUM_SUPPORTED"), -2);
        module.setAttribute(PythonUtils.tsLiteral("PROTO_MAXIMUM_SUPPORTED"), -1);
        module.setAttribute(PythonUtils.tsLiteral("PROTO_SSLv3"), SSLProtocol.SSLv3.getId());
        module.setAttribute(PythonUtils.tsLiteral("PROTO_TLSv1"), SSLProtocol.TLSv1.getId());
        module.setAttribute(PythonUtils.tsLiteral("PROTO_TLSv1_1"), SSLProtocol.TLSv1_1.getId());
        module.setAttribute(PythonUtils.tsLiteral("PROTO_TLSv1_2"), SSLProtocol.TLSv1_2.getId());
        module.setAttribute(PythonUtils.tsLiteral("PROTO_TLSv1_3"), SSLProtocol.TLSv1_3.getId());
        if (hasSSLv3) {
            module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_SSLv3"), SSLMethod.SSL3.getPythonId());
        }
        module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_SSLv23"), SSLMethod.TLS.getPythonId());
        module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_TLS"), SSLMethod.TLS.getPythonId());
        module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_TLS_CLIENT"), SSLMethod.TLS_CLIENT.getPythonId());
        module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_TLS_SERVER"), SSLMethod.TLS_SERVER.getPythonId());
        module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_TLSv1"), SSLMethod.TLS1.getPythonId());
        module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_TLSv1_1"), SSLMethod.TLS1_1.getPythonId());
        module.setAttribute(PythonUtils.tsLiteral("PROTOCOL_TLSv1_2"), SSLMethod.TLS1_2.getPythonId());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_SSL"), SSLErrorCode.ERROR_SSL.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_WANT_READ"), SSLErrorCode.ERROR_WANT_READ.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_WANT_WRITE"), SSLErrorCode.ERROR_WANT_WRITE.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_WANT_X509_LOOKUP"), SSLErrorCode.ERROR_WANT_X509_LOOKUP.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_SYSCALL"), SSLErrorCode.ERROR_SYSCALL.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_ZERO_RETURN"), SSLErrorCode.ERROR_ZERO_RETURN.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_WANT_CONNECT"), SSLErrorCode.ERROR_WANT_CONNECT.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_EOF"), SSLErrorCode.ERROR_EOF.getErrno());
        module.setAttribute(PythonUtils.tsLiteral("SSL_ERROR_INVALID_ERROR_CODE"), 10);
        module.setAttribute(PythonUtils.tsLiteral("OP_ALL"), 131072);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_SSLv2"), 0);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_SSLv3"), 0x2000000);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_TLSv1"), 0x4000000);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_TLSv1_1"), 0x10000000);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_TLSv1_2"), 0x8000000);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_TLSv1_3"), 0x20000000);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_COMPRESSION"), 131072);
        module.setAttribute(PythonUtils.tsLiteral("OP_NO_TICKET"), 16384);
        module.setAttribute(PythonUtils.tsLiteral("VERIFY_DEFAULT"), 0);
        module.setAttribute(PythonUtils.tsLiteral("VERIFY_CRL_CHECK_LEAF"), 4);
        module.setAttribute(PythonUtils.tsLiteral("VERIFY_CRL_CHECK_CHAIN"), 12);
        module.setAttribute(PythonUtils.tsLiteral("VERIFY_X509_STRICT"), 32);
        module.setAttribute(PythonUtils.tsLiteral("VERIFY_X509_TRUSTED_FIRST"), 32768);
    }

    static {
        SSLCipher[] computed;
        LOGGER = PythonLanguage.getLogger(SSLModuleBuiltins.class);
        T_DEFAULT_CIPHER_STRING = PythonUtils.tsLiteral(J_DEFAULT_CIPHER_STRING);
        try {
            computed = SSLCipherSelector.selectCiphers(null, J_DEFAULT_CIPHER_STRING);
        }
        catch (PException e) {
            computed = new SSLCipher[]{};
        }
        defaultCiphers = computed;
    }

    @Builtin(name="_test_decode_cert", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"path"})
    @GenerateNodeFactory
    static abstract class DecodeCertNode
    extends PythonUnaryBuiltinNode {
        DecodeCertNode() {
        }

        @Specialization
        Object decode(VirtualFrame frame, Object path, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeFSDecoderNode asPath, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.EqualNode eqNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            return this.decode(this.toTruffleFile(frame, inliningTarget, asPath, path, toJavaStringNode, eqNode, constructAndRaiseNode));
        }

        @CompilerDirectives.TruffleBoundary
        private Object decode(TruffleFile file) throws PException {
            PDict pDict;
            block11: {
                BufferedReader r = file.newBufferedReader();
                try {
                    List<Object> certs = CertUtils.getCertificates(r);
                    if (certs.isEmpty()) {
                        throw PConstructAndRaiseNode.raiseUncachedSSLError(ErrorMessages.SSL_ERR_DECODING_PEM_FILE);
                    }
                    Object cert = certs.get(0);
                    if (!(cert instanceof X509Certificate)) {
                        throw PConstructAndRaiseNode.raiseUncachedSSLError(ErrorMessages.SSL_ERR_DECODING_PEM_FILE_UNEXPECTED_S, cert.getClass().getName());
                    }
                    pDict = CertUtils.decodeCertificate(this.getContext().factory(), (X509Certificate)certs.get(0));
                    if (r == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | DecoderException ex) {
                        throw PConstructAndRaiseNode.raiseUncachedSSLError(ErrorMessages.SSL_CANT_OPEN_FILE_S, ex.toString());
                    }
                    catch (CRLException | CertificateException ex) {
                        throw PConstructAndRaiseNode.raiseUncachedSSLError(ErrorMessages.SSL_ERR_DECODING_PEM_FILE_S, ex.toString());
                    }
                }
                r.close();
            }
            return pDict;
        }

        private TruffleFile toTruffleFile(VirtualFrame frame, Node inliningTarget, PyUnicodeFSDecoderNode asPath, Object fileObject, TruffleString.ToJavaStringNode toJavaStringNode, TruffleString.EqualNode eqNode, PConstructAndRaiseNode.Lazy constructAndRaiseNode) throws PException {
            try {
                TruffleFile file = this.getContext().getEnv().getPublicTruffleFile(toJavaStringNode.execute((AbstractTruffleString)asPath.execute((Frame)frame, fileObject)));
                if (!file.exists(new LinkOption[0])) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.ENOENT);
                }
                return file;
            }
            catch (Exception e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e, eqNode);
            }
        }
    }

    @Builtins(value={@Builtin(name="enum_certificates", minNumOfPositionalArgs=1, parameterNames={"store_name"}, os=PythonOS.PLATFORM_WIN32), @Builtin(name="enum_crls", minNumOfPositionalArgs=1, parameterNames={"store_name"}, os=PythonOS.PLATFORM_WIN32)})
    @ArgumentClinic(name="store_name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class EnumCertificatesNode
    extends PythonUnaryClinicBuiltinNode {
        EnumCertificatesNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLModuleBuiltinsClinicProviders.EnumCertificatesNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object fail(TruffleString argument, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.PermissionError);
        }
    }

    @Builtin(name="get_default_verify_paths")
    @GenerateNodeFactory
    static abstract class GetDefaultVerifyPathsNode
    extends PythonBuiltinNode {
        private static final TruffleString T_SSL_CERT_FILE = PythonUtils.tsLiteral("SSL_CERT_FILE");
        private static final TruffleString T_SSL_CERT_DIR = PythonUtils.tsLiteral("SSL_CERT_DIR");

        GetDefaultVerifyPathsNode() {
        }

        @Specialization
        Object getDefaultPaths(@Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{T_SSL_CERT_FILE, StringLiterals.T_EMPTY_STRING, T_SSL_CERT_DIR, StringLiterals.T_EMPTY_STRING});
        }
    }

    @Builtin(name="RAND_pseudo_bytes", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"n"})
    @GenerateNodeFactory
    static abstract class RandPseudoBytesNode
    extends PythonUnaryBuiltinNode {
        RandPseudoBytesNode() {
        }

        @Specialization
        static Object randPseudoBytes(Object n, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="RAND_bytes", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"n"})
    @GenerateNodeFactory
    static abstract class RandBytesNode
    extends PythonUnaryBuiltinNode {
        RandBytesNode() {
        }

        @Specialization
        static Object randBytes(Object n, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="RAND_add", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"string", "entropy"})
    @GenerateNodeFactory
    static abstract class RandAddNode
    extends PythonBinaryBuiltinNode {
        RandAddNode() {
        }

        @Specialization
        static Object randAdd(Object string, Object entropy, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="RAND_status")
    @GenerateNodeFactory
    static abstract class RandStatusNode
    extends PythonBuiltinNode {
        RandStatusNode() {
        }

        @Specialization
        static Object randStatus(@Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="nid2obj", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"nid"})
    @GenerateNodeFactory
    static abstract class Nid2ObjNode
    extends PythonUnaryBuiltinNode {
        Nid2ObjNode() {
        }

        @Specialization
        static Object nid2obj(Object nid, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="txt2obj", minNumOfPositionalArgs=1, parameterNames={"txt", "name"})
    @ArgumentsClinic(value={@ArgumentClinic(name="txt", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @GenerateNodeFactory
    static abstract class Txt2ObjNode
    extends PythonBinaryClinicBuiltinNode {
        private static final TruffleString T_OID_TLS_SERVER = PythonUtils.tsLiteral("1.3.6.1.5.5.7.3.1");
        private static final TruffleString T_OID_TLS_CLIENT = PythonUtils.tsLiteral("1.3.6.1.5.5.7.3.2");
        private static final TruffleString T_SERVER_AUTH = PythonUtils.tsLiteral("serverAuth");
        private static final TruffleString T_CLIENT_AUTH = PythonUtils.tsLiteral("clientAuth");
        private static final TruffleString T_TLS_WEB_SERVER_AUTHENTICATION = PythonUtils.tsLiteral("TLS Web Server Authentication");
        private static final TruffleString T_TLS_WEB_CLIENT_AUTHENTICATION = PythonUtils.tsLiteral("TLS Web Client Authentication");

        Txt2ObjNode() {
        }

        @Specialization
        static Object txt2obj(TruffleString txt, boolean name, @Bind(value="this") Node inliningTarget, @Cached TruffleString.EqualNode equalNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (equalNode.execute((AbstractTruffleString)T_OID_TLS_SERVER, (AbstractTruffleString)txt, PythonUtils.TS_ENCODING)) {
                return factory.createTuple(new Object[]{129, T_SERVER_AUTH, T_TLS_WEB_SERVER_AUTHENTICATION, txt});
            }
            if (equalNode.execute((AbstractTruffleString)T_OID_TLS_CLIENT, (AbstractTruffleString)txt, PythonUtils.TS_ENCODING)) {
                return factory.createTuple(new Object[]{130, T_CLIENT_AUTH, T_TLS_WEB_CLIENT_AUTHENTICATION, txt});
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.NotImplementedError);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLModuleBuiltinsClinicProviders.Txt2ObjNodeClinicProviderGen.INSTANCE;
        }
    }
}

