/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TimeModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.TimeModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.namespace.PSimpleNamespace;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyImportImport;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonImageBuildOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.management.ManagementFactory;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="time")
public final class TimeModuleBuiltins
extends PythonBuiltins {
    private static final int DELAY_NANOS = 10;
    private static final String CTIME_FORMAT = "%s %s %2d %02d:%02d:%02d %d";
    private static final ZoneId GMT = ZoneId.of("GMT");
    private static final StructSequence.BuiltinTypeDescriptor STRUCT_TIME_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStructTime, "The time value as returned by gmtime(), localtime(), and strptime(), and\n accepted by asctime(), mktime() and strftime().  May be considered as a\n sequence of 9 integers.\n\n Note that several fields' values are not the same as those defined by\n the C language standard for struct tm.  For example, the value of the\n field tm_year is the actual year, not year - 1900.  See individual\n fields' descriptions for details.", 9, new String[]{"tm_year", "tm_mon", "tm_mday", "tm_hour", "tm_min", "tm_sec", "tm_wday", "tm_yday", "tm_isdst", "tm_zone", "tm_gmtoff"}, new String[]{"year, for example, 1993", "month of year, range [1, 12]", "day of month, range [1, 31]", "hours, range [0, 23]", "minutes, range [0, 59]", "seconds, range [0, 61]", "day of week, range [0, 6], Monday is 0", "day of year, range [1, 366]", "1 if summer time is in effect, 0 if not, and -1 if unknown", "abbreviation of timezone name", "offset from UTC in seconds"});
    public static final TruffleString T_TZNAME = PythonUtils.tsLiteral("tzname");
    public static final TruffleString T_DAYLIGHT = PythonUtils.tsLiteral("daylight");
    public static final TruffleString T_TIMEZONE = PythonUtils.tsLiteral("timezone");
    public static final TruffleString T_ALTZONE = PythonUtils.tsLiteral("altzone");
    private static final int TM_YEAR = 0;
    private static final int TM_MON = 1;
    private static final int TM_MDAY = 2;
    private static final int TM_HOUR = 3;
    private static final int TM_MIN = 4;
    private static final int TM_SEC = 5;
    private static final int TM_WDAY = 6;
    private static final int TM_YDAY = 7;
    private static final int TM_ISDST = 8;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TimeModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        StructSequence.initType(core, STRUCT_TIME_DESC);
        this.addBuiltinConstant("_STRUCT_TM_ITEMS", (Object)11);
    }

    @Override
    public void postInitialize(Python3Core core) {
        boolean hasDaylightSaving;
        super.postInitialize(core);
        ZoneId defaultZoneId = core.getContext().getEnv().getTimeZone();
        ModuleState moduleState = new ModuleState();
        moduleState.currentZoneId = defaultZoneId;
        moduleState.timeSlept = 0L;
        PythonModule timeModule = core.lookupBuiltinModule(StringLiterals.T_TIME);
        timeModule.setModuleState(moduleState);
        TimeZone defaultTimeZone = TimeZone.getTimeZone(defaultZoneId);
        TruffleString noDaylightSavingZone = PythonUtils.toTruffleStringUncached(defaultTimeZone.getDisplayName(false, 0));
        TruffleString daylightSavingZone = PythonUtils.toTruffleStringUncached(defaultTimeZone.getDisplayName(true, 0));
        boolean bl = hasDaylightSaving = !noDaylightSavingZone.equalsUncached((AbstractTruffleString)daylightSavingZone, PythonUtils.TS_ENCODING);
        if (hasDaylightSaving) {
            timeModule.setAttribute(T_TZNAME, core.factory().createTuple(new Object[]{noDaylightSavingZone, daylightSavingZone}));
        } else {
            timeModule.setAttribute(T_TZNAME, core.factory().createTuple(new Object[]{noDaylightSavingZone}));
        }
        timeModule.setAttribute(T_DAYLIGHT, PInt.intValue(hasDaylightSaving));
        int rawOffsetSeconds = defaultTimeZone.getRawOffset() / -1000;
        timeModule.setAttribute(T_TIMEZONE, rawOffsetSeconds);
        timeModule.setAttribute(T_ALTZONE, rawOffsetSeconds - 3600);
    }

    @CompilerDirectives.TruffleBoundary
    public static double timeSeconds() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] getTimeStruct(ZoneId zone, long seconds) {
        Object[] timeStruct = new Object[11];
        Instant instant = Instant.ofEpochSecond(seconds);
        ZonedDateTime zonedDateTime = LocalDateTime.ofInstant(instant, zone).atZone(zone);
        timeStruct[0] = zonedDateTime.getYear();
        timeStruct[1] = zonedDateTime.getMonth().ordinal() + 1;
        timeStruct[2] = zonedDateTime.getDayOfMonth();
        timeStruct[3] = zonedDateTime.getHour();
        timeStruct[4] = zonedDateTime.getMinute();
        timeStruct[5] = zonedDateTime.getSecond();
        timeStruct[6] = zonedDateTime.getDayOfWeek().getValue() - 1;
        timeStruct[7] = zonedDateTime.getDayOfYear();
        boolean isDaylightSavings = zonedDateTime.getZone().getRules().isDaylightSavings(instant);
        timeStruct[8] = isDaylightSavings ? 1 : 0;
        timeStruct[9] = PythonUtils.toTruffleStringUncached(TimeZone.getTimeZone(zone.getId()).getDisplayName(isDaylightSavings, 0));
        timeStruct[10] = zonedDateTime.getOffset().getTotalSeconds();
        return timeStruct;
    }

    @CompilerDirectives.TruffleBoundary
    private static int[] getIntLocalTimeStruct(ZoneId zone, long seconds) {
        int[] timeStruct = new int[9];
        Instant instant = Instant.ofEpochSecond(seconds);
        ZonedDateTime zonedDateTime = LocalDateTime.ofInstant(instant, zone).atZone(zone);
        timeStruct[0] = zonedDateTime.getYear();
        timeStruct[1] = zonedDateTime.getMonth().ordinal() + 1;
        timeStruct[2] = zonedDateTime.getDayOfMonth();
        timeStruct[3] = zonedDateTime.getHour();
        timeStruct[4] = zonedDateTime.getMinute();
        timeStruct[5] = zonedDateTime.getSecond();
        timeStruct[6] = zonedDateTime.getDayOfWeek().getValue() - 1;
        timeStruct[7] = zonedDateTime.getDayOfYear();
        timeStruct[8] = zonedDateTime.getZone().getRules().isDaylightSavings(instant) ? 1 : 0;
        return timeStruct;
    }

    private static final class ModuleState {
        ZoneId currentZoneId;
        long timeSlept;

        private ModuleState() {
        }
    }

    @Builtin(name="strptime", parameterNames={"data_string", "format"}, doc="strftime(format[, tuple]) -> string\n\nConvert a time tuple to a string according to a format specification.\nSee the library reference manual for formatting codes. When the time tuple\nis not present, current time as returned by localtime() is used.\n\n")
    @ArgumentsClinic(value={@ArgumentClinic(name="data_string", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="format", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_DEFAULT_FORMAT", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class StrptimeNode
    extends PythonBinaryClinicBuiltinNode {
        static final TruffleString T_MOD_STRPTIME = PythonUtils.tsLiteral("_strptime");
        static final TruffleString T_FUNC_STRPTIME_TIME = PythonUtils.tsLiteral("_strptime_time");
        static final TruffleString T_DEFAULT_FORMAT = PythonUtils.tsLiteral("%a %b %d %H:%M:%S %Y");

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TimeModuleBuiltinsClinicProviders.StrptimeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        public Object strptime(VirtualFrame frame, TruffleString dataString, TruffleString format, @Bind(value="this") Node inliningTarget, @Cached PyImportImport importNode, @Cached PyObjectCallMethodObjArgs callNode) {
            Object module = importNode.execute(frame, inliningTarget, T_MOD_STRPTIME);
            return callNode.execute((Frame)frame, inliningTarget, module, T_FUNC_STRPTIME_TIME, dataString, format);
        }
    }

    @Builtin(name="get_clock_info", parameterNames={"name"}, doc="get_clock_info(name: str) -> dict\n\nGet information of the specified clock.")
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class GetClockInfoNode
    extends PythonUnaryClinicBuiltinNode {
        public static final TruffleString T_TIME_IMPL_MONOTONIC = PythonUtils.tsLiteral("monotonic");
        public static final TruffleString T_TIME_IMPL_PERF_COUNTER = PythonUtils.tsLiteral("perf_counter");
        public static final TruffleString T_TIME_IMPL_PROCESS_TIME = PythonUtils.tsLiteral("process_time");
        public static final TruffleString T_TIME_IMPL_THREAD_TIME = PythonUtils.tsLiteral("thread_time");
        public static final TruffleString T_TIME_IMPL_TIME = PythonUtils.tsLiteral("time");
        public static final double TIME_RESOLUTION = 1.0E-6;
        public static final TruffleString T_ADJUSTABLE = PythonUtils.tsLiteral("adjustable");
        public static final TruffleString T_IMPLEMENTATION = PythonUtils.tsLiteral("implementation");
        public static final TruffleString T_MONOTONIC = PythonUtils.tsLiteral("monotonic");
        public static final TruffleString T_RESOLUTION = PythonUtils.tsLiteral("resolution");

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TimeModuleBuiltinsClinicProviders.GetClockInfoNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object getClockInfo(TruffleString name, @Bind(value="this") Node inliningTarget, @Cached WriteAttributeToPythonObjectNode writeAttrNode, @Cached TruffleString.EqualNode equalNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            boolean monotonic;
            boolean adjustable;
            if (equalNode.execute((AbstractTruffleString)T_TIME_IMPL_MONOTONIC, (AbstractTruffleString)name, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)T_TIME_IMPL_PERF_COUNTER, (AbstractTruffleString)name, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)T_TIME_IMPL_THREAD_TIME, (AbstractTruffleString)name, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)T_TIME_IMPL_PROCESS_TIME, (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) {
                adjustable = false;
                monotonic = true;
            } else if (equalNode.execute((AbstractTruffleString)T_TIME_IMPL_TIME, (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) {
                adjustable = true;
                monotonic = false;
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNKNOWN_CLOCK);
            }
            PSimpleNamespace ns = factory.createSimpleNamespace();
            writeAttrNode.execute(ns, T_ADJUSTABLE, adjustable);
            writeAttrNode.execute(ns, T_IMPLEMENTATION, name);
            writeAttrNode.execute(ns, T_MONOTONIC, monotonic);
            writeAttrNode.execute(ns, T_RESOLUTION, 1.0E-6);
            return ns;
        }
    }

    @Builtin(name="asctime", maxNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class ASCTimeNode
    extends PythonBinaryBuiltinNode {
        static final String[] WDAY_NAME = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        static final String[] MON_NAME = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        @Specialization
        static TruffleString localtime(PythonModule module, PNone time, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            return ASCTimeNode.format(TimeModuleBuiltins.getIntLocalTimeStruct(moduleState.currentZoneId, (long)TimeModuleBuiltins.timeSeconds()), fromJavaStringNode);
        }

        @Specialization
        static TruffleString localtime(VirtualFrame frame, PythonModule module, PTuple time, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            return ASCTimeNode.format(StrfTimeNode.checkStructtime(frame, inliningTarget, time, getArray, asSizeNode, raiseNode), fromJavaStringNode);
        }

        @Fallback
        static Object localtime(Object module, Object time, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.TUPLE_OR_STRUCT_TIME_ARG_REQUIRED);
        }

        protected static TruffleString format(int[] tm, TruffleString.FromJavaStringNode fromJavaStringNode) {
            return ASCTimeNode.format(TimeModuleBuiltins.CTIME_FORMAT, tm, fromJavaStringNode);
        }

        protected static TruffleString format(String format, int[] tm, TruffleString.FromJavaStringNode fromJavaStringNode) {
            assert (tm[6] >= 0);
            assert (tm[1] > 0);
            String day = WDAY_NAME[tm[6]];
            String month = MON_NAME[tm[1]];
            String str = PythonUtils.formatJString(format, day, month, tm[2], tm[3], tm[4], tm[5], tm[0]);
            return fromJavaStringNode.execute(str, PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="ctime", maxNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class CTimeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static TruffleString localtime(VirtualFrame frame, PythonModule module, Object seconds, @Bind(value="this") Node inliningTarget, @Cached ToLongTime toLongTime, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            int[] tm = TimeModuleBuiltins.getIntLocalTimeStruct(moduleState.currentZoneId, toLongTime.execute(frame, inliningTarget, seconds));
            return CTimeNode.format(tm, fromJavaStringNode);
        }

        protected static TruffleString format(int[] tm, TruffleString.FromJavaStringNode fromJavaStringNode) {
            return ASCTimeNode.format(TimeModuleBuiltins.CTIME_FORMAT, tm, fromJavaStringNode);
        }
    }

    @Builtin(name="mktime", minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="mktime(tuple) -> floating point number\n\nConvert a time tuple in local time to seconds since the Epoch.\nNote that mktime(gmtime(0)) will not generally return zero for most\ntime zones; instead the returned value will either be equal to that\nof the timezone or altzone attributes on the time module.")
    @GenerateNodeFactory
    static abstract class MkTimeNode
    extends PythonBinaryBuiltinNode {
        private static final int ELEMENT_COUNT = 9;

        MkTimeNode() {
        }

        @Specialization
        @ExplodeLoop
        static double mktime(VirtualFrame frame, PythonModule module, PTuple tuple, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object[] items = getObjectArrayNode.execute(inliningTarget, tuple);
            if (items.length != 9) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.FUNC_TAKES_EXACTLY_D_ARGS, 9, items.length);
            }
            int[] integers = new int[9];
            for (int i = 0; i < 9; ++i) {
                integers[i] = asSizeNode.executeExact((Frame)frame, inliningTarget, items[i]);
            }
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            return MkTimeNode.op(moduleState.currentZoneId, integers);
        }

        @CompilerDirectives.TruffleBoundary
        private static long op(ZoneId timeZone, int[] integers) {
            LocalDateTime localtime = LocalDateTime.of(integers[0], integers[1], integers[2], integers[3], integers[4], integers[5]);
            return localtime.toEpochSecond(timeZone.getRules().getOffset(localtime));
        }
    }

    @Builtin(name="strftime", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "format", "time"})
    @ArgumentClinic(name="format", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class StrfTimeNode
    extends PythonTernaryClinicBuiltinNode {
        protected static final DateFormatSymbols datesyms = new DateFormatSymbols();

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TimeModuleBuiltinsClinicProviders.StrfTimeNodeClinicProviderGen.INSTANCE;
        }

        private static String format(String format, int arg1) {
            return PythonUtils.formatJString(format, arg1);
        }

        private static String dateFormat(int[] date) {
            return PythonUtils.formatJString("%02d/%02d/", date[1], date[2]) + StrfTimeNode.truncYear(date[0]);
        }

        private static String timeFormat(int[] date) {
            return PythonUtils.formatJString("%02d:%02d:%02d", date[3], date[4], date[5]);
        }

        protected static int[] checkStructtime(VirtualFrame frame, Node inliningTarget, PTuple time, SequenceStorageNodes.GetInternalObjectArrayNode getInternalObjectArrayNode, PyNumberAsSizeNode asSizeNode, PRaiseNode.Lazy raiseNode) {
            Object[] otime = getInternalObjectArrayNode.execute(inliningTarget, time.getSequenceStorage());
            if (time.getSequenceStorage().length() != 9) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_ILLEGAL_TIME_TUPLE_ARG, "asctime()");
            }
            int[] date = new int[9];
            for (int i = 0; i < 9; ++i) {
                date[i] = asSizeNode.executeExact((Frame)frame, inliningTarget, otime[i]);
            }
            if (date[0] < -999999999 || date[0] > 999999999) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.YEAR_OUT_OF_RANGE);
            }
            if (date[1] == 0) {
                date[1] = 1;
            } else if (date[1] < 0 || date[1] > 12) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MONTH_OUT_OF_RANGE);
            }
            if (date[2] == 0) {
                date[2] = 1;
            } else if (date[2] < 0 || date[2] > 31) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.DAY_OF_MONTH_OUT_OF_RANGE);
            }
            if (date[3] < 0 || date[3] > 23) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.HOUR_OUT_OF_RANGE);
            }
            if (date[4] < 0 || date[4] > 59) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MINUTE_OUT_OF_RANGE);
            }
            if (date[5] < 0 || date[5] > 61) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SECONDS_OUT_OF_RANGE);
            }
            if (date[6] == -1) {
                date[6] = 6;
            } else {
                if (date[6] < 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.DAY_OF_WEEK_OUT_OF_RANGE);
                }
                if (date[6] > 6) {
                    date[6] = date[6] % 7;
                }
            }
            if (date[7] == 0) {
                date[7] = 1;
            } else if (date[7] < 0 || date[7] > 366) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.DAY_OF_YEAR_OUT_OF_RANGE);
            }
            if (date[8] < -1) {
                date[8] = -1;
            } else if (date[8] > 1) {
                date[8] = 1;
            }
            return date;
        }

        @CompilerDirectives.TruffleBoundary
        private static String getDayShortName(int day) {
            assert (day < 7);
            String[] names = datesyms.getShortWeekdays();
            return names[day == 6 ? 1 : day + 2];
        }

        @CompilerDirectives.TruffleBoundary
        private static String getDayLongName(int day) {
            assert (day < 7);
            String[] names = datesyms.getWeekdays();
            return names[day == 6 ? 1 : day + 2];
        }

        @CompilerDirectives.TruffleBoundary
        private static String getMonthShortName(int month) {
            assert (month > 0);
            String[] names = datesyms.getShortMonths();
            return names[month - 1];
        }

        @CompilerDirectives.TruffleBoundary
        private static String getMonthLongName(int month) {
            assert (month > 0);
            String[] names = datesyms.getMonths();
            return names[month - 1];
        }

        @CompilerDirectives.TruffleBoundary
        private static String truncYear(int year) {
            String yearstr = StrfTimeNode.format("%04d", year);
            return yearstr.substring(yearstr.length() - 2);
        }

        private static GregorianCalendar getCalendar(int[] time) {
            Month month = Month.of(time[1]);
            return new GregorianCalendar(time[0], month.ordinal(), time[2], time[3], time[4], time[5]);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString format(String format, int[] date, TruffleString.FromJavaStringNode fromJavaStringNode) {
            Object s = "";
            int lastc = 0;
            GregorianCalendar cal = null;
            while (lastc < format.length()) {
                int i = format.indexOf("%", lastc);
                if (i < 0) {
                    s = (String)s + format.substring(lastc);
                    break;
                }
                if (i == format.length() - 1) {
                    s = (String)s + "%";
                    break;
                }
                s = (String)s + format.substring(lastc, i);
                boolean pad = true;
                if (i < format.length() - 1 && format.charAt(i + 1) == '-') {
                    pad = false;
                    ++i;
                }
                switch (format.charAt(++i)) {
                    case 'a': {
                        int j = date[6];
                        s = (String)s + StrfTimeNode.getDayShortName(j);
                        break;
                    }
                    case 'A': {
                        int j = date[6];
                        s = (String)s + StrfTimeNode.getDayLongName(j);
                        break;
                    }
                    case 'b': {
                        int j = date[1];
                        s = (String)s + StrfTimeNode.getMonthShortName(j);
                        break;
                    }
                    case 'B': {
                        int j = date[1];
                        s = (String)s + StrfTimeNode.getMonthLongName(j);
                        break;
                    }
                    case 'c': {
                        s = (String)s + String.valueOf(CTimeNode.format(date, fromJavaStringNode));
                        break;
                    }
                    case 'd': {
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", date[2]) : StrfTimeNode.format("%d", date[2]));
                        break;
                    }
                    case 'H': {
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", date[3]) : StrfTimeNode.format("%d", date[3]));
                        break;
                    }
                    case 'I': {
                        int j = date[3] % 12;
                        if (j == 0) {
                            j = 12;
                        }
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", j) : StrfTimeNode.format("%d", j));
                        break;
                    }
                    case 'j': {
                        s = (String)s + (pad ? StrfTimeNode.format("%03d", date[7]) : StrfTimeNode.format("%d", date[7]));
                        break;
                    }
                    case 'm': {
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", date[1]) : StrfTimeNode.format("%d", date[1]));
                        break;
                    }
                    case 'M': {
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", date[4]) : StrfTimeNode.format("%d", date[4]));
                        break;
                    }
                    case 'p': {
                        int j = date[3];
                        String[] syms = datesyms.getAmPmStrings();
                        if (0 <= j && j < 12) {
                            s = (String)s + syms[0];
                            break;
                        }
                        if (12 > j || j >= 24) break;
                        s = (String)s + syms[1];
                        break;
                    }
                    case 'S': {
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", date[5]) : StrfTimeNode.format("%d", date[5]));
                        break;
                    }
                    case 'U': {
                        if (cal == null) {
                            cal = StrfTimeNode.getCalendar(date);
                        }
                        cal.setFirstDayOfWeek(1);
                        cal.setMinimalDaysInFirstWeek(7);
                        int j = cal.get(3);
                        if (cal.get(2) == 0 && j >= 52) {
                            j = 0;
                        }
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", j) : StrfTimeNode.format("%d", j));
                        break;
                    }
                    case 'w': {
                        int j = (date[6] + 1) % 7;
                        s = (String)s + j;
                        break;
                    }
                    case 'W': {
                        if (cal == null) {
                            cal = StrfTimeNode.getCalendar(date);
                        }
                        cal.setFirstDayOfWeek(2);
                        cal.setMinimalDaysInFirstWeek(7);
                        int j = cal.get(3);
                        if (cal.get(2) == 0 && j >= 52) {
                            j = 0;
                        }
                        s = (String)s + (pad ? StrfTimeNode.format("%02d", j) : StrfTimeNode.format("%d", j));
                        break;
                    }
                    case 'x': {
                        s = (String)s + StrfTimeNode.dateFormat(date);
                        break;
                    }
                    case 'X': {
                        s = (String)s + StrfTimeNode.timeFormat(date);
                        break;
                    }
                    case 'Y': {
                        s = (String)s + date[0];
                        break;
                    }
                    case 'y': {
                        s = (String)s + StrfTimeNode.truncYear(date[0]);
                        break;
                    }
                    case 'Z': {
                        if (cal == null) {
                            cal = StrfTimeNode.getCalendar(date);
                        }
                        s = (String)s + cal.getTimeZone().getDisplayName(date[8] > 0, 0);
                        break;
                    }
                    case '%': {
                        s = (String)s + "%";
                        break;
                    }
                    default: {
                        s = (String)s + "%" + format.charAt(i);
                        ++i;
                    }
                }
                lastc = i + 1;
            }
            return fromJavaStringNode.execute((String)s, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString formatTime(PythonModule module, TruffleString format, PNone time, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="byteIndexOfCp") @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (byteIndexOfCodePointNode.execute((AbstractTruffleString)format, 0, 0, format.byteLength(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.EMBEDDED_NULL_CHARACTER);
            }
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            return StrfTimeNode.format(toJavaStringNode.execute((AbstractTruffleString)format), TimeModuleBuiltins.getIntLocalTimeStruct(moduleState.currentZoneId, (long)TimeModuleBuiltins.timeSeconds()), fromJavaStringNode);
        }

        @Specialization
        static TruffleString formatTime(VirtualFrame frame, PythonModule module, TruffleString format, PTuple time, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="byteIndexOfCp") @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (byteIndexOfCodePointNode.execute((AbstractTruffleString)format, 0, 0, format.byteLength(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.EMBEDDED_NULL_CHARACTER);
            }
            int[] date = StrfTimeNode.checkStructtime(frame, inliningTarget, time, getArray, asSizeNode, raiseNode);
            return StrfTimeNode.format(toJavaStringNode.execute((AbstractTruffleString)format), date, fromJavaStringNode);
        }

        @Specialization
        static TruffleString formatTime(PythonModule module, TruffleString format, Object time, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.TUPLE_OR_STRUCT_TIME_ARG_REQUIRED);
        }
    }

    @Builtin(name="sleep", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class SleepNode
    extends PythonBuiltinNode {
        SleepNode() {
        }

        protected abstract Object execute(VirtualFrame var1, PythonModule var2, double var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isPositive(seconds)"})
        Object sleep(PythonModule self, long seconds, @Cached.Shared @Cached GilNode gil) {
            long t = SleepNode.nanoTime();
            long deadline = (long)TimeModuleBuiltins.timeSeconds() + seconds;
            gil.release(true);
            try {
                SleepNode.doSleep((Node)this, seconds, deadline);
                gil.acquire();
            }
            catch (Throwable throwable) {
                gil.acquire();
                ModuleState moduleState = self.getModuleState(ModuleState.class);
                moduleState.timeSlept = SleepNode.nanoTime() - t + moduleState.timeSlept;
                throw throwable;
            }
            ModuleState moduleState = self.getModuleState(ModuleState.class);
            moduleState.timeSlept = SleepNode.nanoTime() - t + moduleState.timeSlept;
            return PNone.NONE;
        }

        @Specialization(guards={"!isPositive(seconds)"})
        static Object err(PythonModule self, long seconds, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE, "sleep length");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isPositive(seconds)"})
        Object sleep(PythonModule self, double seconds, @Cached.Shared @Cached GilNode gil) {
            long t = SleepNode.nanoTime();
            double deadline = TimeModuleBuiltins.timeSeconds() + seconds;
            gil.release(true);
            try {
                SleepNode.doSleep((Node)this, seconds, deadline);
                gil.acquire();
            }
            catch (Throwable throwable) {
                gil.acquire();
                ModuleState moduleState = self.getModuleState(ModuleState.class);
                moduleState.timeSlept = SleepNode.nanoTime() - t + moduleState.timeSlept;
                throw throwable;
            }
            ModuleState moduleState = self.getModuleState(ModuleState.class);
            moduleState.timeSlept = SleepNode.nanoTime() - t + moduleState.timeSlept;
            PythonContext.triggerAsyncActions(this);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPositive(seconds)"})
        static Object err(PythonModule self, double seconds, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE, "sleep length");
        }

        @Specialization(guards={"!isInteger(secondsObj)"})
        static Object sleepObj(VirtualFrame frame, PythonModule self, Object secondsObj, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached SleepNode recursive) {
            return recursive.execute(frame, self, asDoubleNode.execute(frame, inliningTarget, secondsObj));
        }

        protected static boolean isPositive(double t) {
            return t >= 0.0;
        }

        @CompilerDirectives.TruffleBoundary
        private static void doSleep(Node node, long seconds, long deadline) {
            long secs = seconds;
            do {
                TruffleSafepoint.setBlockedThreadInterruptible((Node)node, s -> Thread.sleep(s * 1000L), (Object)secs);
            } while ((secs = deadline - (long)TimeModuleBuiltins.timeSeconds()) >= 0L);
        }

        @CompilerDirectives.TruffleBoundary
        private static void doSleep(Node node, double seconds, double deadline) {
            double secs = seconds;
            do {
                TruffleSafepoint.setBlockedThreadInterruptible((Node)node, s -> {
                    double milliseconds = s * 1000.0;
                    long millis = Math.round(Math.floor(milliseconds));
                    int nanos = Long.valueOf(Math.round((milliseconds - (double)millis) * 1000.0)).intValue();
                    nanos = millis == 0L && nanos == 0 ? 10 : nanos;
                    try {
                        Thread.sleep(millis, nanos);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                }, (Object)secs);
            } while ((secs = deadline - TimeModuleBuiltins.timeSeconds()) >= 0.0);
        }

        @CompilerDirectives.TruffleBoundary
        private static long nanoTime() {
            return System.nanoTime();
        }

        @NeverDefault
        public static SleepNode create() {
            return TimeModuleBuiltinsFactory.SleepNodeFactory.create(null);
        }
    }

    @Builtin(name="thread_time_ns")
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ThreadTimeNsNode
    extends PythonBuiltinNode {
        ThreadTimeNsNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object getProcesNsTime() {
            return !ImageInfo.inImageCode() ? ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() : 0L;
        }
    }

    @Builtin(name="thread_time")
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ThreadTimeNode
    extends PythonBuiltinNode {
        ThreadTimeNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object getProcesTime() {
            return !ImageInfo.inImageCode() ? (double)ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1.0E9 : 0.0;
        }
    }

    @Builtin(name="process_time_ns", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ProcessTimeNsNode
    extends PythonBuiltinNode {
        ProcessTimeNsNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object getProcesNsTime(PythonModule self) {
            ModuleState moduleState = self.getModuleState(ModuleState.class);
            return System.nanoTime() - PythonContext.get(this).getPerfCounterStart() - moduleState.timeSlept;
        }
    }

    @Builtin(name="process_time", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ProcessTimeNode
    extends PythonBuiltinNode {
        ProcessTimeNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object getProcesTime(PythonModule self) {
            ModuleState moduleState = self.getModuleState(ModuleState.class);
            return (double)(System.nanoTime() - PythonContext.get(this).getPerfCounterStart() - moduleState.timeSlept) / 1.0E9;
        }
    }

    @Builtin(name="perf_counter_ns")
    @GenerateNodeFactory
    public static abstract class PythonPerfCounterNsNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public long counter() {
            return System.nanoTime() - PythonContext.get(this).getPerfCounterStart();
        }
    }

    @Builtin(name="perf_counter")
    @GenerateNodeFactory
    public static abstract class PythonPerfCounterNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double counter() {
            return (double)(System.nanoTime() - PythonContext.get(this).getPerfCounterStart()) / 1.0E9;
        }
    }

    @Builtin(name="monotonic_ns", maxNumOfPositionalArgs=1, doc="Similar to monotonic(), but return time as nanoseconds.")
    @GenerateNodeFactory
    public static abstract class PythonMonotonicNsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static long time(Object dummy) {
            return System.nanoTime();
        }
    }

    @Builtin(name="monotonic")
    @GenerateNodeFactory
    public static abstract class PythonMonotonicNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double time() {
            return (double)System.nanoTime() / 1.0E9;
        }
    }

    @Builtin(name="time_ns", doc="Similar to time() but returns time as an integer number of nanoseconds since the epoch.")
    @GenerateNodeFactory
    public static abstract class PythonTimeNsNode
    extends PythonBuiltinNode {
        @Specialization
        public long time() {
            return PythonTimeNsNode.timeNanoSeconds();
        }

        @CompilerDirectives.TruffleBoundary
        private static long timeNanoSeconds() {
            Instant now = Instant.now();
            return now.getEpochSecond() * 1000000000L + (long)now.getNano();
        }
    }

    @Builtin(name="time")
    @GenerateNodeFactory
    public static abstract class PythonTimeNode
    extends PythonBuiltinNode {
        @Specialization
        public double time() {
            return TimeModuleBuiltins.timeSeconds();
        }
    }

    @Builtin(name="localtime", maxNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class PythonLocalTimeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PTuple localtime(VirtualFrame frame, PythonModule module, Object seconds, @Bind(value="this") Node inliningTarget, @Cached ToLongTime toLongTime, @Cached PythonObjectFactory factory) {
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            return factory.createStructSeq(STRUCT_TIME_DESC, TimeModuleBuiltins.getTimeStruct(moduleState.currentZoneId, toLongTime.execute(frame, inliningTarget, seconds)));
        }
    }

    @Builtin(name="tzset")
    @GenerateNodeFactory
    public static abstract class TzSetNode
    extends PythonBuiltinNode {
        private static final TruffleString SET_TIMEZONE_ERROR = PythonUtils.tsLiteral("Setting timezone was disallowed.");

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object tzset() {
            if (!PythonImageBuildOptions.WITHOUT_PLATFORM_ACCESS) {
                String tzEnv = (String)this.getContext().getEnv().getEnvironment().get("TZ");
                if (tzEnv == null) {
                    tzEnv = "";
                }
                TimeZone.setDefault(TimeZone.getTimeZone(tzEnv));
            } else {
                PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.AttributeError, SET_TIMEZONE_ERROR);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="gmtime", maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class PythonGMTimeNode
    extends PythonBuiltinNode {
        @Specialization
        static PTuple gmtime(VirtualFrame frame, Object seconds, @Bind(value="this") Node inliningTarget, @Cached ToLongTime toLongTime, @Cached PythonObjectFactory factory) {
            return factory.createStructSeq(STRUCT_TIME_DESC, TimeModuleBuiltins.getTimeStruct(GMT, toLongTime.execute(frame, inliningTarget, seconds)));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class ToLongTime
    extends PNodeWithContext {
        private static final long MIN_TIME = Instant.MIN.getEpochSecond();
        private static final long MAX_TIME = Instant.MAX.getEpochSecond();

        protected ToLongTime() {
        }

        public abstract long execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static long doNone(VirtualFrame frame, Node inliningTarget, PNone none) {
            return (long)TimeModuleBuiltins.timeSeconds();
        }

        @Specialization
        static long doLong(Node inliningTarget, long t, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            ToLongTime.check(inliningTarget, t, raiseNode);
            return t;
        }

        @Specialization
        static long doDouble(Node inliningTarget, double t, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            ToLongTime.check(inliningTarget, t, raiseNode);
            return (long)t;
        }

        @Specialization(guards={"!isPNone(obj)"})
        static long doObject(VirtualFrame frame, Node inliningTarget, Object obj, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached CastToJavaDoubleNode castToDouble, @Cached PyLongAsLongNode asLongNode) {
            long t;
            try {
                t = (long)castToDouble.execute(inliningTarget, obj);
            }
            catch (CannotCastException e) {
                t = asLongNode.execute((Frame)frame, inliningTarget, obj);
            }
            ToLongTime.check(inliningTarget, t, raiseNode);
            return t;
        }

        private static boolean isValidTime(double t) {
            return t >= (double)MIN_TIME && t <= (double)MAX_TIME;
        }

        private static void check(Node inliningTarget, double time, PRaiseNode.Lazy raiseNode) {
            if (!ToLongTime.isValidTime(time)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.TIMESTAMP_OUT_OF_RANGE);
            }
        }
    }
}

