/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatFromString;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextFloatBuiltins {

    static abstract class PyFloat_FromString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyFloat_FromString() {
        }

        @Specialization
        static Object fromString(TruffleString string, @Bind(value="this") Node inliningTarget, @Cached PyFloatFromString pyFloatFromString) {
            return pyFloatFromString.execute((Frame)null, inliningTarget, string);
        }
    }

    static abstract class PyTruffleFloat_AsDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleFloat_AsDouble() {
        }

        @Specialization
        static double doLongNativeWrapper(long object) {
            return object;
        }

        @Specialization
        static double doDoubleNativeWrapper(double object) {
            return object;
        }

        @Specialization(guards={"!isLong(object)", "!isDouble(object)"})
        static double doGenericErr(Object object, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return asDoubleNode.execute(null, inliningTarget, object);
        }
    }

    static abstract class PyFloat_FromDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyFloat_FromDouble() {
        }

        @Specialization
        static double fromDouble(double d) {
            return d;
        }

        @Specialization(guards={"!isDouble(obj)"})
        static Object fromDouble(Object obj, @Cached BuiltinConstructors.StrNode strNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_WAS_S_P, strNode.executeWith(null, obj), obj);
        }
    }
}

