/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.asyncio.GetAwaitableNodeGen;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class GetAwaitableNode
extends Node {
    public abstract Object execute(Frame var1, Object var2);

    @Specialization
    public static Object doGenerator(PGenerator generator, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raise, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseReusedCoro) {
        if (generator.isCoroutine()) {
            if (generator.getYieldFrom() != null) {
                throw raiseReusedCoro.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CORO_ALREADY_AWAITED);
            }
            return generator;
        }
        throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_BE_USED_AWAIT, "generator");
    }

    @Specialization
    public static Object doGeneric(Frame frame, Object awaitable, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNoAwait, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNotIter, @Cached(parameters={"Await"}) LookupSpecialMethodSlotNode findAwait, @Cached TypeNodes.GetNameNode getName, @Cached GetClassNode getAwaitableType, @Cached GetClassNode getIteratorType, @Cached CallUnaryMethodNode callAwait, @Cached PyIterCheckNode iterCheck) {
        Object type = getAwaitableType.execute(inliningTarget, awaitable);
        Object getter = findAwait.execute(frame, type, awaitable);
        if (getter == PNone.NO_VALUE) {
            throw raiseNoAwait.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_BE_USED_AWAIT, getName.execute(inliningTarget, type));
        }
        Object iterator = callAwait.executeObject(getter, awaitable);
        if (iterCheck.execute(inliningTarget, iterator)) {
            return iterator;
        }
        Object itType = getIteratorType.execute(inliningTarget, iterator);
        if (itType == PythonBuiltinClassType.PCoroutine) {
            throw raiseNotIter.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.AWAIT_RETURN_COROUTINE);
        }
        throw raiseNotIter.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.AWAIT_RETURN_NON_ITER, getName.execute(inliningTarget, itType));
    }

    public static GetAwaitableNode create() {
        return GetAwaitableNodeGen.create();
    }

    public static GetAwaitableNode getUncached() {
        return GetAwaitableNodeGen.getUncached();
    }
}

