/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBuffer;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCField;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyData;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyExternalFunctionNodesFactory;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.memoryview.CExtPyBuffer;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.argument.ReadIndexedArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadVarArgsNode;
import com.oracle.graal.python.nodes.argument.ReadVarKeywordsNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class HPyExternalFunctionNodes {
    public static final TruffleString KW_CALLABLE = PythonUtils.tsLiteral("$callable");
    private static final TruffleString KW_CLOSURE = PythonUtils.tsLiteral("$closure");
    private static final TruffleString KW_CONTEXT = PythonUtils.tsLiteral("$context");
    private static final TruffleString[] KEYWORDS_HIDDEN_CONTEXT = new TruffleString[]{KW_CONTEXT};
    private static final TruffleString[] KEYWORDS_HIDDEN_CALLABLE = new TruffleString[]{KW_CONTEXT, KW_CALLABLE};
    private static final TruffleString[] KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE = new TruffleString[]{KW_CONTEXT, KW_CALLABLE, KW_CLOSURE};
    private static final Object[] KW_DEFAULTS = new Object[]{PNone.NO_VALUE};

    private static PKeyword[] createKwDefaults(GraalHPyContext context) {
        return new PKeyword[]{new PKeyword(KW_CONTEXT, context)};
    }

    private static PKeyword[] createKwDefaults(Object callable, GraalHPyContext context) {
        return new PKeyword[]{new PKeyword(KW_CONTEXT, context), new PKeyword(KW_CALLABLE, callable)};
    }

    public static PKeyword[] createKwDefaults(Object callable, Object closure, GraalHPyContext context) {
        return new PKeyword[]{new PKeyword(KW_CONTEXT, context), new PKeyword(KW_CALLABLE, callable), new PKeyword(KW_CLOSURE, closure)};
    }

    @CompilerDirectives.TruffleBoundary
    static PBuiltinFunction createWrapperFunction(PythonLanguage language, GraalHPyContext context, GraalHPyDef.HPyFuncSignature signature, TruffleString name, Object callable, Object enclosingType, PythonObjectFactory factory) {
        assert (InteropLibrary.getUncached((Object)callable).isExecutable(callable)) : "object is not callable";
        RootCallTarget callTarget = language.createCachedCallTarget(l -> HPyExternalFunctionNodes.createRootNode(l, signature, name), signature, name, true);
        Object[] defaults = signature == GraalHPyDef.HPyFuncSignature.TERNARYFUNC ? KW_DEFAULTS : PythonUtils.EMPTY_OBJECT_ARRAY;
        int flags = GraalHPyDef.HPyFuncSignature.getFlags(signature);
        return factory.createBuiltinFunction(name, enclosingType, defaults, HPyExternalFunctionNodes.createKwDefaults(callable, context), flags, callTarget);
    }

    private static PRootNode createRootNode(PythonLanguage language, GraalHPyDef.HPyFuncSignature signature, TruffleString name) {
        switch (signature) {
            case NOARGS: 
            case UNARYFUNC: 
            case REPRFUNC: 
            case GETITERFUNC: 
            case ITERNEXTFUNC: 
            case DESTROYFUNC: {
                return new HPyMethNoargsRoot(language, name, false);
            }
            case O: 
            case BINARYFUNC: {
                return new HPyMethORoot(language, name, false);
            }
            case KEYWORDS: {
                return new HPyMethKeywordsRoot(language, name);
            }
            case INITPROC: {
                return new HPyMethInitProcRoot(language, name);
            }
            case VARARGS: {
                return new HPyMethVarargsRoot(language, name);
            }
            case TERNARYFUNC: {
                return new HPyMethTernaryRoot(language, name);
            }
            case LENFUNC: {
                return new HPyMethNoargsRoot(language, name, true);
            }
            case SSIZEOBJARGPROC: {
                return new HPyMethSSizeObjArgProcRoot(language, name);
            }
            case INQUIRY: {
                return new HPyMethInquiryRoot(language, name);
            }
            case SSIZEARGFUNC: {
                return new HPyMethSSizeArgFuncRoot(language, name);
            }
            case OBJOBJARGPROC: {
                return new HPyMethObjObjArgProcRoot(language, name);
            }
            case OBJOBJPROC: {
                return new HPyMethObjObjProcRoot(language, name);
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)("unsupported HPy method signature: " + signature.name()));
    }

    @CompilerDirectives.TruffleBoundary
    public static PBuiltinFunction createWrapperFunction(PythonLanguage language, GraalHPyContext context, GraalHPyDef.HPySlotWrapper wrapper, TpSlot.TpSlotHPyNative slot, ExternalFunctionNodes.PExternalFunctionWrapper legacySlotWrapper, TruffleString name, Object callable, Object enclosingType, PythonObjectFactory factory) {
        assert (InteropLibrary.getUncached((Object)callable).isExecutable(callable)) : "object is not callable";
        RootCallTarget callTarget = language.createCachedCallTarget(l -> HPyExternalFunctionNodes.createSlotRootNode(l, wrapper, name), wrapper, name);
        Object[] defaults = wrapper == GraalHPyDef.HPySlotWrapper.TERNARYFUNC || wrapper == GraalHPyDef.HPySlotWrapper.SQ_DELITEM ? new Object[]{PNone.NO_VALUE} : PythonUtils.EMPTY_OBJECT_ARRAY;
        PKeyword[] kwDefaults = wrapper == GraalHPyDef.HPySlotWrapper.CALL ? HPyExternalFunctionNodes.createKwDefaults(context) : HPyExternalFunctionNodes.createKwDefaults(callable, context);
        return factory.createWrapperDescriptor(name, enclosingType, defaults, kwDefaults, 0, callTarget, slot, legacySlotWrapper);
    }

    private static PRootNode createSlotRootNode(PythonLanguage language, GraalHPyDef.HPySlotWrapper wrapper, TruffleString name) {
        switch (wrapper) {
            case NULL: {
                return new HPyMethKeywordsRoot(language, name);
            }
            case UNARYFUNC: {
                return new HPyMethNoargsRoot(language, name, false);
            }
            case BINARYFUNC: 
            case BINARYFUNC_L: {
                return new HPyMethORoot(language, name, false);
            }
            case BINARYFUNC_R: {
                return new HPyMethReverseBinaryRoot(language, name, false);
            }
            case INIT: {
                return new HPyMethInitProcRoot(language, name);
            }
            case TERNARYFUNC: {
                return new HPyMethTernaryRoot(language, name);
            }
            case LENFUNC: {
                return new HPyMethNoargsRoot(language, name, true);
            }
            case INQUIRYPRED: {
                return new HPyMethInquiryRoot(language, name);
            }
            case INDEXARGFUNC: {
                return new HPyMethSSizeArgFuncRoot(language, name);
            }
            case OBJOBJARGPROC: {
                return new HPyMethObjObjArgProcRoot(language, name);
            }
            case OBJOBJPROC: {
                return new HPyMethObjObjProcRoot(language, name);
            }
            case SQ_ITEM: {
                return new HPyMethSqItemWrapperRoot(language, name);
            }
            case SQ_SETITEM: 
            case SQ_DELITEM: {
                return new HPyMethSqSetitemWrapperRoot(language, name);
            }
            case RICHCMP_LT: 
            case RICHCMP_LE: 
            case RICHCMP_EQ: 
            case RICHCMP_NE: 
            case RICHCMP_GT: 
            case RICHCMP_GE: {
                return new HPyMethRichcmpOpRootNode(language, name, HPyExternalFunctionNodes.getCompareOpCode(wrapper));
            }
            case GETBUFFER: {
                return new HPyGetBufferRootNode(language, name);
            }
            case RELEASEBUFFER: {
                return new HPyReleaseBufferRootNode(language, name);
            }
            case HASHFUNC: {
                return new HPyMethHashRoot(language, name);
            }
            case CALL: {
                return new HPyMethCallRoot(language, name);
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)("unsupported HPy slot wrapper: wrap_" + wrapper.name().toLowerCase()));
    }

    private static int getCompareOpCode(GraalHPyDef.HPySlotWrapper sig) {
        switch (sig) {
            case RICHCMP_LT: {
                return 0;
            }
            case RICHCMP_LE: {
                return 1;
            }
            case RICHCMP_EQ: {
                return 2;
            }
            case RICHCMP_NE: {
                return 3;
            }
            case RICHCMP_GT: {
                return 4;
            }
            case RICHCMP_GE: {
                return 5;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    static final class HPyMethNoargsRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(1, false, -1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);

        public HPyMethNoargsRoot(PythonLanguage language, TruffleString name, boolean nativePrimitiveResult) {
            super(language, name, nativePrimitiveResult ? HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create() : HPyExternalFunctionNodesFactory.HPyCheckHandleResultNodeGen.create(), GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame)};
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethORoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "arg"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;

        public HPyMethORoot(PythonLanguage language, TruffleString name, boolean nativePrimitiveResult) {
            super(language, name, nativePrimitiveResult ? HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create() : HPyExternalFunctionNodesFactory.HPyCheckHandleResultNodeGen.create(), GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame), this.getArg(frame)};
        }

        private Object getArg(VirtualFrame frame) {
            if (this.readArgNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArgNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArgNode.execute(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethKeywordsRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, true, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;
        @Node.Child
        private PythonObjectFactory factory;

        @CompilerDirectives.TruffleBoundary
        public HPyMethKeywordsRoot(PythonLanguage language, TruffleString name) {
            super(language, name, GraalHPyNodesFactory.HPyKeywordsToSulongNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            Object kwnamesTuple;
            Object[] args;
            Object[] positionalArgs = this.getVarargs(frame);
            PKeyword[] keywords = this.getKwargs(frame);
            long nPositionalArgs = positionalArgs.length;
            if (keywords.length > 0) {
                args = PythonUtils.arrayCopyOf(positionalArgs, positionalArgs.length + keywords.length);
                TruffleString[] kwnames = new TruffleString[keywords.length];
                for (int i = 0; i < keywords.length; ++i) {
                    args[positionalArgs.length + i] = keywords[i].getValue();
                    kwnames[i] = keywords[i].getName();
                }
                kwnamesTuple = this.getKwnamesTuple(kwnames);
            } else {
                args = positionalArgs;
                kwnamesTuple = GraalHPyHandle.NULL_HANDLE_DELEGATE;
            }
            return new Object[]{this.getSelf(frame), this.createArgumentsArray(hpyContext, args), nPositionalArgs, kwnamesTuple};
        }

        @Override
        protected void closeCArguments(VirtualFrame frame, GraalHPyContext hpyContext, Object[] cArguments) {
            hpyContext.freeArgumentsArray(cArguments[1]);
        }

        private Object createArgumentsArray(GraalHPyContext hpyContext, Object[] args) {
            return hpyContext.createArgumentsArray(args);
        }

        private Object[] getVarargs(VirtualFrame frame) {
            if (this.readVarargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readVarargsNode = (ReadVarArgsNode)this.insert(ReadVarArgsNode.create(true));
            }
            return this.readVarargsNode.executeObjectArray(frame);
        }

        private PKeyword[] getKwargs(VirtualFrame frame) {
            if (PArguments.getKeywordArguments((Frame)frame).length == 0) {
                return PKeyword.EMPTY_KEYWORDS;
            }
            if (this.readKwargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readKwargsNode = (ReadVarKeywordsNode)this.insert(ReadVarKeywordsNode.create());
            }
            return (PKeyword[])this.readKwargsNode.execute(frame);
        }

        private PTuple getKwnamesTuple(TruffleString[] kwnames) {
            if (this.factory == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.factory = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
            }
            return this.factory.createTuple(kwnames);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethInitProcRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, true, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;

        @CompilerDirectives.TruffleBoundary
        public HPyMethInitProcRoot(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create(), GraalHPyNodesFactory.HPyKeywordsToSulongNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            Object[] args = this.getVarargs(frame);
            return new Object[]{this.getSelf(frame), hpyContext.createArgumentsArray(args), (long)args.length, this.getKwargs(frame)};
        }

        @Override
        protected void closeCArguments(VirtualFrame frame, GraalHPyContext hpyContext, Object[] cArguments) {
            hpyContext.freeArgumentsArray(cArguments[1]);
        }

        @Override
        protected Object processResult(VirtualFrame frame, Object result) {
            return PNone.NONE;
        }

        private Object[] getVarargs(VirtualFrame frame) {
            if (this.readVarargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readVarargsNode = (ReadVarArgsNode)this.insert(ReadVarArgsNode.create(true));
            }
            return this.readVarargsNode.executeObjectArray(frame);
        }

        private Object getKwargs(VirtualFrame frame) {
            if (this.readKwargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readKwargsNode = (ReadVarKeywordsNode)this.insert(ReadVarKeywordsNode.createForUserFunction(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY));
            }
            return this.readKwargsNode.execute(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethVarargsRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;

        @CompilerDirectives.TruffleBoundary
        public HPyMethVarargsRoot(PythonLanguage language, TruffleString name) {
            super(language, name, GraalHPyNodesFactory.HPyVarargsToSulongNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            Object[] args = this.getVarargs(frame);
            return new Object[]{this.getSelf(frame), hpyContext.createArgumentsArray(args), (long)args.length};
        }

        @Override
        protected void closeCArguments(VirtualFrame frame, GraalHPyContext hpyContext, Object[] cArguments) {
            hpyContext.freeArgumentsArray(cArguments[1]);
        }

        private Object[] getVarargs(VirtualFrame frame) {
            if (this.readVarargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readVarargsNode = (ReadVarArgsNode)this.insert(ReadVarArgsNode.create(true));
            }
            return this.readVarargsNode.executeObjectArray(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethTernaryRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(3, false, -1, false, PythonUtils.tsArray("x", "y", "z"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;

        public HPyMethTernaryRoot(PythonLanguage language, TruffleString name) {
            super(language, name, GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame), this.getArg1(frame), this.getArg2(frame)};
        }

        private Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        private Object getArg2(VirtualFrame frame) {
            Object arg2;
            if (this.readArg2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg2Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(2));
            }
            return (arg2 = this.readArg2Node.execute(frame)) != PNone.NO_VALUE ? arg2 : PNone.NONE;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static class HPyMethSSizeObjArgProcRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(3, false, -1, false, PythonUtils.tsArray("$self", "arg0", "arg1"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;

        public HPyMethSSizeObjArgProcRoot(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create(), GraalHPyNodesFactory.HPySSizeObjArgProcToSulongNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame), this.getArg1(frame), this.getArg2(frame)};
        }

        protected Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        protected Object getArg2(VirtualFrame frame) {
            if (this.readArg2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg2Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(2));
            }
            return this.readArg2Node.execute(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethInquiryRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE);

        public HPyMethInquiryRoot(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create(), GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame)};
        }

        @Override
        protected Object processResult(VirtualFrame frame, Object result) {
            return HPyMethInquiryRoot.intToBoolean(result);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static class HPyMethSSizeArgFuncRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(2, false, -1, false, PythonUtils.tsArray("$self", "n"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;

        public HPyMethSSizeArgFuncRoot(PythonLanguage language, TruffleString name) {
            super(language, name, GraalHPyNodesFactory.HPySSizeArgFuncToSulongNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame), this.getArg1(frame)};
        }

        protected Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethObjObjArgProcRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, 1, false, PythonUtils.tsArray("$self", "x"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private PRaiseNode raiseNode;

        public HPyMethObjObjArgProcRoot(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create(), GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            Object[] varargs = this.getVarargs(frame);
            if (varargs.length == 0) {
                return new Object[]{this.getSelf(frame), this.getArg1(frame), PNone.NO_VALUE};
            }
            if (varargs.length == 1) {
                return new Object[]{this.getSelf(frame), this.getArg1(frame), varargs[0]};
            }
            throw this.getRaiseNode().raise(PythonBuiltinClassType.TypeError, ErrorMessages.TAKES_FROM_D_TO_D_POS_ARG_S_BUT_D_S_GIVEN_S, this.getName(), 2, 3, "s", 1 + varargs.length, "were", "");
        }

        private PRaiseNode getRaiseNode() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode;
        }

        private Object[] getVarargs(VirtualFrame frame) {
            if (this.readVarargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readVarargsNode = (ReadVarArgsNode)this.insert(ReadVarArgsNode.create(true));
            }
            return this.readVarargsNode.executeObjectArray(frame);
        }

        private Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        @Override
        protected Object processResult(VirtualFrame frame, Object result) {
            return HPyMethObjObjArgProcRoot.intToBoolean(result);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethObjObjProcRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(2, false, -1, false, PythonUtils.tsArray("$self", "other"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;

        public HPyMethObjObjProcRoot(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create(), GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame), this.getArg1(frame)};
        }

        private Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        @Override
        protected Object processResult(VirtualFrame frame, Object result) {
            return HPyMethObjObjProcRoot.intToBoolean(result);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethReverseBinaryRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "other"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readOtherNode;

        public HPyMethReverseBinaryRoot(PythonLanguage language, TruffleString name, boolean nativePrimitiveResult) {
            super(language, name, nativePrimitiveResult ? HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create() : HPyExternalFunctionNodesFactory.HPyCheckHandleResultNodeGen.create(), GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getOther(frame), this.getSelf(frame)};
        }

        private Object getOther(VirtualFrame frame) {
            if (this.readOtherNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readOtherNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readOtherNode.execute(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethSqItemWrapperRoot
    extends HPyMethSSizeArgFuncRoot {
        @Node.Child
        private CExtCommonNodes.GetIndexNode getIndexNode;

        public HPyMethSqItemWrapperRoot(PythonLanguage language, TruffleString name) {
            super(language, name);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            Object self = this.getSelf(frame);
            return new Object[]{self, this.getIndex(self, this.getArg1(frame))};
        }

        private int getIndex(Object self, Object index) {
            if (this.getIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIndexNode = (CExtCommonNodes.GetIndexNode)this.insert(CExtCommonNodes.GetIndexNode.create());
            }
            return this.getIndexNode.execute(self, index);
        }
    }

    static final class HPyMethSqSetitemWrapperRoot
    extends HPyMethSSizeObjArgProcRoot {
        @Node.Child
        private CExtCommonNodes.GetIndexNode getIndexNode;

        public HPyMethSqSetitemWrapperRoot(PythonLanguage language, TruffleString name) {
            super(language, name);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            Object self = this.getSelf(frame);
            return new Object[]{self, this.getIndex(self, this.getArg1(frame)), this.getArg2(frame)};
        }

        private int getIndex(Object self, Object index) {
            if (this.getIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIndexNode = (CExtCommonNodes.GetIndexNode)this.insert(CExtCommonNodes.GetIndexNode.create());
            }
            return this.getIndexNode.execute(self, index);
        }
    }

    static final class HPyMethRichcmpOpRootNode
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "other"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode = ReadIndexedArgumentNode.create(1);
        private final int op;

        HPyMethRichcmpOpRootNode(PythonLanguage language, TruffleString name, int op) {
            super(language, name, GraalHPyNodesFactory.HPyRichcmpFuncArgsToSulongNodeGen.create());
            this.op = op;
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame), this.readArgNode.execute(frame), this.op};
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyGetBufferRootNode
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, 1, false, PythonUtils.tsArray("self", "flags"), KEYWORDS_HIDDEN_CALLABLE);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private CExtNodes.FromCharPointerNode fromCharPointerNode;
        @Node.Child
        private GraalHPyCAccess.AllocateNode allocateNode;
        @Node.Child
        private GraalHPyCAccess.FreeNode freeNode;
        @Node.Child
        private GraalHPyCAccess.ReadPointerNode readPointerNode;
        @Node.Child
        private GraalHPyCAccess.ReadGenericNode readGenericNode;
        @Node.Child
        private GraalHPyCAccess.ReadHPyNode readHPyNode;
        @Node.Child
        private GraalHPyCAccess.IsNullNode isNullNode;

        @CompilerDirectives.TruffleBoundary
        public HPyGetBufferRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create(), GraalHPyNodesFactory.HPyGetBufferProcToSulongNodeGen.create());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CExtPyBuffer execute(VirtualFrame frame) {
            this.getCalleeContext().enter(frame);
            Object bufferPtr = null;
            GraalHPyContext hpyContext = null;
            try {
                Object callable = this.ensureReadCallableNode().execute(frame);
                hpyContext = this.readContext(frame);
                bufferPtr = this.ensureAllocateNode(hpyContext).malloc(hpyContext, HPyContextSignatureType.HPy_buffer);
                Object[] cArguments = new Object[]{this.getSelf(frame), bufferPtr, this.getArg1(frame)};
                this.getInvokeNode().execute(frame, this.getTSName(), callable, hpyContext, cArguments);
                CExtPyBuffer cExtPyBuffer = this.createPyBuffer(hpyContext, bufferPtr);
                if (hpyContext != null && bufferPtr != null) {
                    this.ensureFreeNode(hpyContext).free(hpyContext, bufferPtr);
                }
                this.getCalleeContext().exit(frame, this);
                return cExtPyBuffer;
            }
            catch (Throwable throwable) {
                if (hpyContext != null && bufferPtr != null) {
                    this.ensureFreeNode(hpyContext).free(hpyContext, bufferPtr);
                }
                this.getCalleeContext().exit(frame, this);
                throw throwable;
            }
        }

        private CExtPyBuffer createPyBuffer(GraalHPyContext ctx, Object bufferPtr) {
            if (this.readGenericNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readGenericNode = (GraalHPyCAccess.ReadGenericNode)this.insert(GraalHPyCAccess.ReadGenericNode.create(ctx));
            }
            if (this.readPointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readPointerNode = (GraalHPyCAccess.ReadPointerNode)this.insert(GraalHPyCAccess.ReadPointerNode.create(ctx));
            }
            if (this.readHPyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readHPyNode = (GraalHPyCAccess.ReadHPyNode)this.insert(GraalHPyCAccess.ReadHPyNode.create(ctx));
            }
            if (this.isNullNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isNullNode = (GraalHPyCAccess.IsNullNode)this.insert(GraalHPyCAccess.IsNullNode.create(ctx));
            }
            if (this.fromCharPointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fromCharPointerNode = (CExtNodes.FromCharPointerNode)this.insert(CExtNodesFactory.FromCharPointerNodeGen.create());
            }
            int len = this.readGenericNode.readInt(ctx, bufferPtr, GraalHPyCField.HPy_buffer__len);
            Object buf = this.readPointerNode.read(ctx, bufferPtr, GraalHPyCField.HPy_buffer__buf);
            Object owner = this.readHPyNode.readAndClose(ctx, bufferPtr, GraalHPyCField.HPy_buffer__obj);
            int ndim = this.readGenericNode.readInt(ctx, bufferPtr, GraalHPyCField.HPy_buffer__ndim);
            int itemSize = this.readGenericNode.readInt(ctx, bufferPtr, GraalHPyCField.HPy_buffer__itemsize);
            boolean readonly = this.readGenericNode.readInt(ctx, bufferPtr, GraalHPyCField.HPy_buffer__readonly) != 0;
            TruffleString format = this.fromCharPointerNode.execute(this.readPointerNode.read(ctx, bufferPtr, GraalHPyCField.HPy_buffer__format));
            Object shapePtr = this.readPointerNode.read(ctx, bufferPtr, GraalHPyCField.HPy_buffer__shape);
            Object stridesPtr = this.readPointerNode.read(ctx, bufferPtr, GraalHPyCField.HPy_buffer__strides);
            Object suboffsetsPtr = this.readPointerNode.read(ctx, bufferPtr, GraalHPyCField.HPy_buffer__suboffsets);
            Object internal = this.readPointerNode.read(ctx, bufferPtr, GraalHPyCField.HPy_buffer__internal);
            int[] shape = null;
            int[] strides = null;
            int[] subOffsets = null;
            if (ndim > 0) {
                if (!this.isNullNode.execute(ctx, shapePtr)) {
                    shape = this.readLongAsIntArray(ctx, shapePtr, ndim);
                }
                if (!this.isNullNode.execute(ctx, stridesPtr)) {
                    strides = this.readLongAsIntArray(ctx, stridesPtr, ndim);
                }
                if (!this.isNullNode.execute(ctx, suboffsetsPtr)) {
                    subOffsets = this.readLongAsIntArray(ctx, suboffsetsPtr, ndim);
                }
            }
            return new CExtPyBuffer(buf, owner, len, itemSize, readonly, ndim, format, shape, strides, subOffsets, internal);
        }

        private int[] readLongAsIntArray(GraalHPyContext ctx, Object pointer, int elements) {
            GraalHPyCAccess.ReadGenericNode readI64Node = this.ensureReadGenericNode(ctx);
            int elemSize = ctx.getCTypeSize(HPyContextSignatureType.HPy_ssize_t);
            int[] result = new int[elements];
            for (int i = 0; i < result.length; ++i) {
                result[i] = readI64Node.executeInt(ctx, pointer, (long)i * (long)elemSize, HPyContextSignatureType.HPy_ssize_t);
            }
            return result;
        }

        private GraalHPyCAccess.AllocateNode ensureAllocateNode(GraalHPyContext ctx) {
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.allocateNode = (GraalHPyCAccess.AllocateNode)this.insert(GraalHPyCAccess.AllocateNode.create(ctx));
            }
            return this.allocateNode;
        }

        private GraalHPyCAccess.FreeNode ensureFreeNode(GraalHPyContext ctx) {
            if (this.freeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.freeNode = (GraalHPyCAccess.FreeNode)this.insert(GraalHPyCAccess.FreeNode.create(ctx));
            }
            return this.freeNode;
        }

        private GraalHPyCAccess.ReadGenericNode ensureReadGenericNode(GraalHPyContext ctx) {
            if (this.readGenericNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readGenericNode = (GraalHPyCAccess.ReadGenericNode)this.insert(GraalHPyCAccess.ReadGenericNode.create(ctx));
            }
            return this.readGenericNode;
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        private Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyReleaseBufferRootNode
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, 1, false, PythonUtils.tsArray("self", "buffer"), KEYWORDS_HIDDEN_CALLABLE);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private GraalHPyCAccess.FreeNode freeNode;
        @Node.Child
        private GraalHPyCAccess.ReadPointerNode readPointerNode;
        @Node.Child
        private GraalHPyCAccess.ReadHPyNode readHPyNode;

        @CompilerDirectives.TruffleBoundary
        public HPyReleaseBufferRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckVoidResultNodeGen.create(), GraalHPyNodesFactory.HPyReleaseBufferProcToSulongNodeGen.create());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(VirtualFrame frame) {
            this.getCalleeContext().enter(frame);
            try {
                Object callable = this.ensureReadCallableNode().execute(frame);
                GraalHPyContext hpyContext = this.readContext(frame);
                Object arg1 = this.getArg1(frame);
                if (!(arg1 instanceof CExtPyBuffer)) {
                    throw CompilerDirectives.shouldNotReachHere((String)"invalid argument");
                }
                CExtPyBuffer buffer = (CExtPyBuffer)arg1;
                GraalHPyBuffer hpyBuffer = new GraalHPyBuffer(hpyContext, buffer);
                try {
                    this.getInvokeNode().execute(frame, this.getTSName(), callable, hpyContext, new Object[]{this.getSelf(frame), hpyBuffer});
                }
                finally {
                    if (hpyBuffer.isPointer()) {
                        hpyBuffer.free(hpyContext, this.ensureFreeNode(hpyContext), this.ensureReadPointerNode(hpyContext), this.ensureReadHPyNode(hpyContext));
                    }
                }
                PNone pNone = PNone.NONE;
                return pNone;
            }
            finally {
                this.getCalleeContext().exit(frame, this);
            }
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        protected Object processResult(VirtualFrame frame, Object result) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        private Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        private GraalHPyCAccess.FreeNode ensureFreeNode(GraalHPyContext ctx) {
            if (this.freeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.freeNode = (GraalHPyCAccess.FreeNode)this.insert(GraalHPyCAccess.FreeNode.create(ctx));
            }
            return this.freeNode;
        }

        private GraalHPyCAccess.ReadPointerNode ensureReadPointerNode(GraalHPyContext ctx) {
            if (this.readPointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readPointerNode = (GraalHPyCAccess.ReadPointerNode)this.insert(GraalHPyCAccess.ReadPointerNode.create(ctx));
            }
            return this.readPointerNode;
        }

        private GraalHPyCAccess.ReadHPyNode ensureReadHPyNode(GraalHPyContext ctx) {
            if (this.readHPyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readHPyNode = (GraalHPyCAccess.ReadHPyNode)this.insert(GraalHPyCAccess.ReadHPyNode.create(ctx));
            }
            return this.readHPyNode;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethHashRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE);

        public HPyMethHashRoot(PythonLanguage language, TruffleString name) {
            super(language, name, HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create(), GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame)};
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyMethCallRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, true, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CONTEXT, true);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;
        @Node.Child
        private PythonObjectFactory factory;

        @CompilerDirectives.TruffleBoundary
        public HPyMethCallRoot(PythonLanguage language, TruffleString name) {
            super(language, name, GraalHPyNodesFactory.HPyKeywordsToSulongNodeGen.create());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(VirtualFrame frame) {
            Object callable;
            GraalHPyContext hpyContext = this.readContext(frame);
            Object[] cArguments = this.prepareCArguments(frame, hpyContext);
            Object self = cArguments[0];
            if (self instanceof PythonObject) {
                PythonObject pythonObject = (PythonObject)self;
                callable = GraalHPyData.getHPyCallFunction(pythonObject);
            } else {
                callable = null;
            }
            if (callable == null) {
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.HPY_OBJECT_DOES_NOT_SUPPORT_CALL, self);
            }
            this.getCalleeContext().enter(frame);
            try {
                Object object = this.getInvokeNode().execute(frame, this.getTSName(), callable, hpyContext, cArguments);
                return object;
            }
            finally {
                this.getCalleeContext().exit(frame, this);
                this.closeCArguments(frame, hpyContext, cArguments);
            }
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            Object kwnamesTuple;
            Object[] args;
            Object[] positionalArgs = this.getVarargs(frame);
            PKeyword[] keywords = this.getKwargs(frame);
            long nPositionalArgs = positionalArgs.length;
            if (keywords.length > 0) {
                args = PythonUtils.arrayCopyOf(positionalArgs, positionalArgs.length + keywords.length);
                TruffleString[] kwnames = new TruffleString[keywords.length];
                for (int i = 0; i < keywords.length; ++i) {
                    args[positionalArgs.length + i] = keywords[i].getValue();
                    kwnames[i] = keywords[i].getName();
                }
                kwnamesTuple = this.getKwnamesTuple(kwnames);
            } else {
                args = positionalArgs;
                kwnamesTuple = GraalHPyHandle.NULL_HANDLE_DELEGATE;
            }
            return new Object[]{this.getSelf(frame), this.createArgumentsArray(hpyContext, args), nPositionalArgs, kwnamesTuple};
        }

        @Override
        protected void closeCArguments(VirtualFrame frame, GraalHPyContext hpyContext, Object[] cArguments) {
            hpyContext.freeArgumentsArray(cArguments[1]);
        }

        private Object createArgumentsArray(GraalHPyContext hpyContext, Object[] args) {
            return hpyContext.createArgumentsArray(args);
        }

        private Object[] getVarargs(VirtualFrame frame) {
            if (this.readVarargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readVarargsNode = (ReadVarArgsNode)this.insert(ReadVarArgsNode.create(true));
            }
            return this.readVarargsNode.executeObjectArray(frame);
        }

        private PKeyword[] getKwargs(VirtualFrame frame) {
            if (PArguments.getKeywordArguments((Frame)frame).length == 0) {
                return PKeyword.EMPTY_KEYWORDS;
            }
            if (this.readKwargsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readKwargsNode = (ReadVarKeywordsNode)this.insert(ReadVarKeywordsNode.create());
            }
            return (PKeyword[])this.readKwargsNode.execute(frame);
        }

        private PTuple getKwnamesTuple(TruffleString[] kwnames) {
            if (this.factory == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.factory = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
            }
            return this.factory.createTuple(kwnames);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class HPyLegacyGetSetDescriptorSetterRoot
    extends ExternalFunctionNodes.SetterRoot {
        @Node.Child
        private GraalHPyNodes.HPyGetNativeSpacePointerNode getNativeSpacePointerNode;

        private HPyLegacyGetSetDescriptorSetterRoot(PythonLanguage language, TruffleString name, ExternalFunctionNodes.PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object nativeSpacePtr;
            Object[] objects = super.prepareCArguments(frame);
            if (this.getNativeSpacePointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNativeSpacePointerNode = (GraalHPyNodes.HPyGetNativeSpacePointerNode)this.insert(GraalHPyNodesFactory.HPyGetNativeSpacePointerNodeGen.create());
            }
            if ((nativeSpacePtr = this.getNativeSpacePointerNode.executeCached(objects[0])) == PNone.NO_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.SystemError, ErrorMessages.ATTEMPTING_SETTER_NO_NATIVE_SPACE);
            }
            objects[0] = new PythonAbstractNativeObject(nativeSpacePtr);
            return objects;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createLegacyFunction(GraalHPyContext context, PythonLanguage lang, Object owner, TruffleString propertyName, Object target, Object closure) {
            PythonContext pythonContext = context.getContext();
            PythonObjectSlowPathFactory factory = pythonContext.factory();
            RootCallTarget rootCallTarget = lang.createCachedCallTarget(l -> new HPyLegacyGetSetDescriptorSetterRoot((PythonLanguage)((Object)l), propertyName, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER), HPyLegacyGetSetDescriptorSetterRoot.class, propertyName);
            if (rootCallTarget == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"Calling non-native get descriptor functions is not support in HPy");
            }
            target = CExtCommonNodes.EnsureExecutableNode.executeUncached(target, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
            return factory.createBuiltinFunction(propertyName, owner, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(target, closure), 0, rootCallTarget);
        }
    }

    static final class HPyGetSetDescriptorSetterRootNode
    extends HPyGetSetDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("$self", "value"), KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE, true);

        private HPyGetSetDescriptorSetterRootNode(PythonLanguage language, TruffleString name) {
            super(language, name);
        }

        @Override
        protected Object[] createArguments(VirtualFrame frame, Object closure) {
            return new Object[]{PArguments.getArgument((Frame)frame, 0), PArguments.getArgument((Frame)frame, 1), closure};
        }

        @Override
        protected GraalHPyNodes.HPyConvertArgsToSulongNode createArgumentConversionNode() {
            return GraalHPyNodesFactory.HPyGetSetSetterToSulongNodeGen.create();
        }

        @Override
        protected HPyCheckFunctionResultNode createResultConversionNode() {
            return HPyExternalFunctionNodesFactory.HPyCheckPrimitiveResultNodeGen.create();
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createFunction(GraalHPyContext hpyContext, Object enclosingType, TruffleString propertyName, Object target, Object closure) {
            PythonContext pythonContext = hpyContext.getContext();
            PythonLanguage lang = pythonContext.getLanguage();
            RootCallTarget callTarget = lang.createCachedCallTarget(l -> new HPyGetSetDescriptorSetterRootNode((PythonLanguage)((Object)l), propertyName), HPyGetSetDescriptorSetterRootNode.class, propertyName);
            PythonObjectSlowPathFactory factory = pythonContext.factory();
            return factory.createBuiltinFunction(propertyName, enclosingType, PythonUtils.EMPTY_OBJECT_ARRAY, HPyExternalFunctionNodes.createKwDefaults(target, closure, hpyContext), 0, callTarget);
        }
    }

    static final class HPyLegacyGetSetDescriptorGetterRoot
    extends ExternalFunctionNodes.GetterRoot {
        @Node.Child
        private GraalHPyNodes.HPyGetNativeSpacePointerNode getNativeSpacePointerNode;

        protected HPyLegacyGetSetDescriptorGetterRoot(PythonLanguage language, TruffleString name, ExternalFunctionNodes.PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object nativeSpacePtr;
            Object[] objects = super.prepareCArguments(frame);
            if (this.getNativeSpacePointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNativeSpacePointerNode = (GraalHPyNodes.HPyGetNativeSpacePointerNode)this.insert(GraalHPyNodesFactory.HPyGetNativeSpacePointerNodeGen.create());
            }
            if ((nativeSpacePtr = this.getNativeSpacePointerNode.executeCached(objects[0])) == PNone.NO_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.SystemError, ErrorMessages.ATTEMPTING_GETTER_NO_NATIVE_SPACE);
            }
            objects[0] = new PythonAbstractNativeObject(nativeSpacePtr);
            return objects;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createLegacyFunction(GraalHPyContext context, PythonLanguage lang, Object owner, TruffleString propertyName, Object target, Object closure) {
            PythonContext pythonContext = context.getContext();
            PythonObjectSlowPathFactory factory = pythonContext.factory();
            RootCallTarget rootCallTarget = lang.createCachedCallTarget(l -> new HPyLegacyGetSetDescriptorGetterRoot((PythonLanguage)((Object)l), propertyName, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER), HPyLegacyGetSetDescriptorGetterRoot.class, propertyName);
            if (rootCallTarget == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"Calling non-native get descriptor functions is not support in HPy");
            }
            target = CExtCommonNodes.EnsureExecutableNode.executeUncached(target, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
            return factory.createBuiltinFunction(propertyName, owner, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(target, closure), 0, rootCallTarget);
        }
    }

    static final class HPyGetSetDescriptorGetterRootNode
    extends HPyGetSetDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("$self"), KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE, true);

        HPyGetSetDescriptorGetterRootNode(PythonLanguage language, TruffleString name) {
            super(language, name);
        }

        @Override
        protected Object[] createArguments(VirtualFrame frame, Object closure) {
            return new Object[]{PArguments.getArgument((Frame)frame, 0), closure};
        }

        @Override
        protected GraalHPyNodes.HPyConvertArgsToSulongNode createArgumentConversionNode() {
            return GraalHPyNodesFactory.HPyGetSetGetterToSulongNodeGen.create();
        }

        @Override
        protected HPyCheckFunctionResultNode createResultConversionNode() {
            return HPyExternalFunctionNodesFactory.HPyCheckHandleResultNodeGen.create();
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createFunction(GraalHPyContext hpyContext, Object enclosingType, TruffleString propertyName, Object target, Object closure) {
            PythonContext pythonContext = hpyContext.getContext();
            PythonLanguage lang = pythonContext.getLanguage();
            RootCallTarget callTarget = lang.createCachedCallTarget(l -> new HPyGetSetDescriptorGetterRootNode((PythonLanguage)((Object)l), propertyName), HPyGetSetDescriptorGetterRootNode.class, propertyName);
            PythonObjectSlowPathFactory factory = pythonContext.getCore().factory();
            return factory.createBuiltinFunction(propertyName, enclosingType, PythonUtils.EMPTY_OBJECT_ARRAY, HPyExternalFunctionNodes.createKwDefaults(target, closure, hpyContext), 0, callTarget);
        }
    }

    static abstract class HPyGetSetDescriptorRootNode
    extends PRootNode {
        @Node.Child
        private ExecutionContext.CalleeContext calleeContext;
        @Node.Child
        private HPyExternalFunctionInvokeNode invokeNode;
        @Node.Child
        private ReadIndexedArgumentNode readCallableNode;
        @Node.Child
        private ReadIndexedArgumentNode readContextNode;
        @Node.Child
        private ReadIndexedArgumentNode readClosureNode;
        private final TruffleString name;

        HPyGetSetDescriptorRootNode(PythonLanguage language, TruffleString name) {
            super(language);
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            this.getCalleeContext().enter(frame);
            try {
                Object target = this.readCallable(frame);
                GraalHPyContext hpyContext = this.readContext(frame);
                Object closure = this.readClosure(frame);
                Object object = this.ensureInvokeNode().execute(frame, this.name, target, hpyContext, this.createArguments(frame, closure));
                return object;
            }
            finally {
                this.getCalleeContext().exit(frame, this);
            }
        }

        protected abstract GraalHPyNodes.HPyConvertArgsToSulongNode createArgumentConversionNode();

        protected abstract HPyCheckFunctionResultNode createResultConversionNode();

        protected abstract Object[] createArguments(VirtualFrame var1, Object var2);

        public String getName() {
            return this.name.toJavaStringUncached();
        }

        private ExecutionContext.CalleeContext getCalleeContext() {
            if (this.calleeContext == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.calleeContext = (ExecutionContext.CalleeContext)this.insert(ExecutionContext.CalleeContext.create());
            }
            return this.calleeContext;
        }

        private HPyExternalFunctionInvokeNode ensureInvokeNode() {
            if (this.invokeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.invokeNode = (HPyExternalFunctionInvokeNode)this.insert(HPyExternalFunctionNodesFactory.HPyExternalFunctionInvokeNodeGen.create(this.createResultConversionNode(), this.createArgumentConversionNode()));
            }
            return this.invokeNode;
        }

        protected final Object readCallable(VirtualFrame frame) {
            if (this.readCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length + 1;
                this.readCallableNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readCallableNode.execute(frame);
        }

        private GraalHPyContext readContext(VirtualFrame frame) {
            Object hpyContext;
            if (this.readContextNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length;
                this.readContextNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            if ((hpyContext = this.readContextNode.execute(frame)) instanceof GraalHPyContext) {
                return (GraalHPyContext)hpyContext;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid HPy context");
        }

        protected final Object readClosure(VirtualFrame frame) {
            if (this.readClosureNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length + 2;
                this.readClosureNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readClosureNode.execute(frame);
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean setsUpCalleeContext() {
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class HPyCheckVoidResultNode
    extends HPyCheckFunctionResultNode {
        HPyCheckVoidResultNode() {
        }

        @Specialization
        static Object doGeneric(PythonContext.PythonThreadState threadState, TruffleString name, Object value, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, threadState, name, false, true);
            return value;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class HPyCheckPrimitiveResultNode
    extends HPyCheckFunctionResultNode {
        HPyCheckPrimitiveResultNode() {
        }

        public abstract int executeInt(PythonContext.PythonThreadState var1, TruffleString var2, int var3);

        public abstract long executeLong(PythonContext.PythonThreadState var1, TruffleString var2, long var3);

        @Specialization
        static int doInteger(PythonContext.PythonThreadState pythonThreadState, TruffleString name, int value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, pythonThreadState, name, value == -1, false);
            return value;
        }

        @Specialization(replaces={"doInteger"})
        static long doLong(PythonContext.PythonThreadState pythonThreadState, TruffleString name, long value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, pythonThreadState, name, value == -1L, false);
            return value;
        }

        @Specialization(limit="1")
        static Object doObject(PythonContext.PythonThreadState pythonThreadState, TruffleString name, Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="value") InteropLibrary lib, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            if (lib.fitsInLong(value)) {
                try {
                    long lvalue = lib.asLong(value);
                    transformExceptionFromNativeNode.execute(inliningTarget, pythonThreadState, name, lvalue == -1L, false);
                    return lvalue;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.FUNC_S_DIDNT_RETURN_INT, name);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HPyCheckHandleResultNode
    extends HPyCheckFunctionResultNode {
        @Specialization
        static Object doLongNull(PythonContext.PythonThreadState pythonThreadState, TruffleString name, Object value, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyCloseAndGetHandleNode closeAndGetHandleNode, @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            Object delegate = closeAndGetHandleNode.execute(inliningTarget, value);
            transformExceptionFromNativeNode.execute(inliningTarget, pythonThreadState, name, delegate == GraalHPyHandle.NULL_HANDLE_DELEGATE, true);
            return delegate;
        }
    }

    public static abstract class HPyCheckFunctionResultNode
    extends Node {
        public abstract Object execute(PythonContext.PythonThreadState var1, TruffleString var2, Object var3);
    }

    static final class HPyMethSSizeSSizeArgFuncRoot
    extends HPyMethodDescriptorRootNode {
        private static final Signature SIGNATURE = new Signature(3, false, -1, false, PythonUtils.tsArray("$self", "n", "m"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;

        public HPyMethSSizeSSizeArgFuncRoot(PythonLanguage language, TruffleString name) {
            super(language, name, GraalHPyNodesFactory.HPySSizeArgFuncToSulongNodeGen.create());
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame, GraalHPyContext hpyContext) {
            return new Object[]{this.getSelf(frame), this.getArg1(frame), this.getArg2(frame)};
        }

        private Object getArg1(VirtualFrame frame) {
            if (this.readArg1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg1Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArg1Node.execute(frame);
        }

        private Object getArg2(VirtualFrame frame) {
            if (this.readArg2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArg2Node = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(2));
            }
            return this.readArg2Node.execute(frame);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static abstract class HPyMethodDescriptorRootNode
    extends PRootNode {
        @Node.Child
        private ExecutionContext.CalleeContext calleeContext;
        @Node.Child
        private HPyExternalFunctionInvokeNode invokeNode;
        @Node.Child
        private ReadIndexedArgumentNode readSelfNode;
        @Node.Child
        private ReadIndexedArgumentNode readCallableNode;
        @Node.Child
        private ReadIndexedArgumentNode readContextNode;
        private final TruffleString name;

        @CompilerDirectives.TruffleBoundary
        public HPyMethodDescriptorRootNode(PythonLanguage language, TruffleString name, GraalHPyNodes.HPyConvertArgsToSulongNode convertArgsToSulongNode) {
            super(language);
            this.name = name;
            this.invokeNode = HPyExternalFunctionNodesFactory.HPyExternalFunctionInvokeNodeGen.create(convertArgsToSulongNode);
        }

        @CompilerDirectives.TruffleBoundary
        public HPyMethodDescriptorRootNode(PythonLanguage language, TruffleString name, HPyCheckFunctionResultNode checkFunctionResultNode, GraalHPyNodes.HPyConvertArgsToSulongNode convertArgsToSulongNode) {
            super(language);
            this.name = name;
            this.invokeNode = HPyExternalFunctionNodesFactory.HPyExternalFunctionInvokeNodeGen.create(checkFunctionResultNode, convertArgsToSulongNode);
        }

        protected static Object intToBoolean(Object result) {
            if (result instanceof Integer) {
                return (Integer)result != 0;
            }
            if (result instanceof Long) {
                return (Long)result != 0L;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            Object callable = this.ensureReadCallableNode().execute(frame);
            GraalHPyContext hpyContext = this.readContext(frame);
            Object[] cArguments = this.prepareCArguments(frame, hpyContext);
            this.getCalleeContext().enter(frame);
            try {
                Object object = this.processResult(frame, this.invokeNode.execute(frame, this.name, callable, hpyContext, cArguments));
                return object;
            }
            finally {
                this.getCalleeContext().exit(frame, this);
                this.closeCArguments(frame, hpyContext, cArguments);
            }
        }

        protected abstract Object[] prepareCArguments(VirtualFrame var1, GraalHPyContext var2);

        protected Object processResult(VirtualFrame frame, Object result) {
            return result;
        }

        protected void closeCArguments(VirtualFrame frame, GraalHPyContext hpyContext, Object[] cArguments) {
        }

        protected final HPyExternalFunctionInvokeNode getInvokeNode() {
            return this.invokeNode;
        }

        protected final Object getSelf(VirtualFrame frame) {
            if (this.readSelfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readSelfNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(0));
            }
            return this.readSelfNode.execute(frame);
        }

        protected final ExecutionContext.CalleeContext getCalleeContext() {
            if (this.calleeContext == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.calleeContext = (ExecutionContext.CalleeContext)this.insert(ExecutionContext.CalleeContext.create());
            }
            return this.calleeContext;
        }

        protected final ReadIndexedArgumentNode ensureReadCallableNode() {
            if (this.readCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length + 1;
                this.readCallableNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readCallableNode;
        }

        protected final GraalHPyContext readContext(VirtualFrame frame) {
            Object hpyContext;
            if (this.readContextNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length;
                this.readContextNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            if ((hpyContext = this.readContextNode.execute(frame)) instanceof GraalHPyContext) {
                return (GraalHPyContext)hpyContext;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid HPy context");
        }

        public String getName() {
            return this.name.toJavaStringUncached();
        }

        public TruffleString getTSName() {
            return this.name;
        }

        public String toString() {
            return "<METH root " + this.name.toJavaStringUncached() + ">";
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }

        @Override
        public boolean setsUpCalleeContext() {
            return true;
        }
    }

    public static abstract class HPyExternalFunctionInvokeNode
    extends Node {
        @Node.Child
        private GraalHPyNodes.HPyConvertArgsToSulongNode toSulongNode;
        @Node.Child
        private HPyCheckFunctionResultNode checkFunctionResultNode;
        @Node.Child
        private GraalHPyNodes.HPyCloseArgHandlesNode handleCloseNode;

        HPyExternalFunctionInvokeNode() {
            CompilerAsserts.neverPartOfCompilation();
            this.toSulongNode = GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create();
            this.checkFunctionResultNode = HPyExternalFunctionNodesFactory.HPyCheckHandleResultNodeGen.create();
            this.handleCloseNode = this.toSulongNode.createCloseHandleNode();
        }

        HPyExternalFunctionInvokeNode(GraalHPyNodes.HPyConvertArgsToSulongNode convertArgsNode) {
            CompilerAsserts.neverPartOfCompilation();
            this.toSulongNode = convertArgsNode != null ? convertArgsNode : GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create();
            this.checkFunctionResultNode = HPyExternalFunctionNodesFactory.HPyCheckHandleResultNodeGen.create();
            this.handleCloseNode = this.toSulongNode.createCloseHandleNode();
        }

        HPyExternalFunctionInvokeNode(HPyCheckFunctionResultNode checkFunctionResultNode, GraalHPyNodes.HPyConvertArgsToSulongNode convertArgsNode) {
            CompilerAsserts.neverPartOfCompilation();
            this.toSulongNode = convertArgsNode != null ? convertArgsNode : GraalHPyNodesFactory.HPyAllAsHandleNodeGen.create();
            this.checkFunctionResultNode = checkFunctionResultNode != null ? checkFunctionResultNode : HPyExternalFunctionNodesFactory.HPyCheckHandleResultNodeGen.create();
            this.handleCloseNode = this.toSulongNode.createCloseHandleNode();
        }

        public abstract Object execute(VirtualFrame var1, TruffleString var2, Object var3, GraalHPyContext var4, Object[] var5);

        @Specialization(limit="1")
        Object doIt(VirtualFrame frame, TruffleString name, Object callable, GraalHPyContext hPyContext, Object[] arguments, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="callable") InteropLibrary lib, @Cached PRaiseNode raiseNode) {
            Object[] convertedArguments = new Object[arguments.length + 1];
            this.toSulongNode.executeInto(frame, arguments, 0, convertedArguments, 1);
            convertedArguments[0] = hPyContext.getBackend();
            PythonLanguage language = PythonLanguage.get(this);
            PythonContext ctx = hPyContext.getContext();
            PythonContext.PythonThreadState pythonThreadState = ctx.getThreadState(language);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, pythonThreadState, indirectCallData);
            try {
                Object object = this.checkFunctionResultNode.execute(pythonThreadState, name, lib.execute(callable, convertedArguments));
                return object;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_FAILED, name, e);
            }
            catch (ArityException e) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_EXPECTED_ARGS, name, e.getExpectedMinArity(), e.getActualArity());
            }
            finally {
                PArguments.setException((Frame)frame, pythonThreadState.getCaughtException());
                ExecutionContext.IndirectCallContext.exit(frame, pythonThreadState, state);
                if (this.handleCloseNode != null) {
                    this.handleCloseNode.executeInto(frame, convertedArguments, 1);
                }
            }
        }
    }
}

