/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DefaultDictBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.dict.DefaultDictBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.DictReprBuiltin;
import com.oracle.graal.python.builtins.objects.dict.PDefaultDict;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDefaultDict})
public final class DefaultDictBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DefaultDictBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DefaultDictBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object or(VirtualFrame frame, PDict self, PDict other, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached CallNode callNode, @Cached DictNodes.UpdateNode updateNode, @Cached PRaiseNode.Lazy raiseNode) {
            PDefaultDict dd = (PDefaultDict)(self instanceof PDefaultDict ? self : other);
            Object type = getClassNode.execute(inliningTarget, dd);
            Object result = callNode.execute((Frame)frame, type, dd.getDefaultFactory(), self);
            if (result instanceof PDefaultDict) {
                updateNode.execute((Frame)frame, (PDefaultDict)result, other);
                return result;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError);
        }

        @Fallback
        static Object or(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="default_factory", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="Factory for default value called by __missing__().")
    @GenerateNodeFactory
    static abstract class DefaultFactoryNode
    extends PythonBinaryBuiltinNode {
        DefaultFactoryNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object set(PDefaultDict self, Object value) {
            self.setDefaultFactory(value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(value)"})
        Object get(PDefaultDict self, PNone value) {
            return self.getDefaultFactory();
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doInit(VirtualFrame frame, PDefaultDict self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached DictBuiltins.InitNode dictInitNode, @Cached PyCallableCheckNode callableCheckNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object[] newArgs = args;
            Object newDefault = PNone.NONE;
            if (newArgs.length > 0) {
                newDefault = newArgs[0];
                if (newDefault != PNone.NONE && !callableCheckNode.execute(inliningTarget, newDefault)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.FIRST_ARG_MUST_BE_CALLABLE_S, " or None");
                }
                newArgs = PythonUtils.arrayCopyOfRange(args, 1, args.length);
            }
            self.setDefaultFactory(newDefault);
            return dictInitNode.execute(frame, self, newArgs, kwargs);
        }
    }

    @Builtin(name="__missing__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class MissingNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNone(self.getDefaultFactory())"})
        static Object doNoFactory(PDefaultDict self, Object key, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.KeyError, new Object[]{key});
        }

        @Specialization(guards={"!isNone(self.getDefaultFactory())"})
        static Object doMissing(VirtualFrame frame, PDefaultDict self, Object key, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached PyDictSetItem setItem) {
            Object value = callNode.execute((Frame)frame, self.getDefaultFactory(), new Object[0]);
            setItem.execute((Frame)frame, inliningTarget, self, key, value);
            return value;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDefaultDict copy(VirtualFrame frame, PDefaultDict self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached PythonObjectFactory factory) {
            return factory.createDefaultDict(self.getDefaultFactory(), copyNode.execute(inliningTarget, self.getDictStorage()));
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(VirtualFrame frame, PDefaultDict self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetIter getIter, @Cached PythonObjectFactory factory) {
            Object defaultFactory = self.getDefaultFactory();
            PTuple args = defaultFactory == PNone.NONE ? factory.createEmptyTuple() : factory.createTuple(new Object[]{defaultFactory});
            Object iter = getIter.execute((Frame)frame, inliningTarget, factory.createDictItemsView(self));
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), args, PNone.NONE, PNone.NONE, iter});
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static Object reprFunction(VirtualFrame frame, PDefaultDict self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached DictReprBuiltin.ReprNode dictReprNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object klass = getClassNode.execute(inliningTarget, self);
            TruffleString name = getNameNode.execute(inliningTarget, klass);
            TruffleString factoryRepr = reprNode.execute((Frame)frame, inliningTarget, self.getDefaultFactory());
            TruffleString dictRepr = dictReprNode.execute(frame, self);
            return simpleTruffleStringFormatNode.format("%s(%s, %s)", name, factoryRepr, dictRepr);
        }
    }
}

