/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionGroupBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseExceptionGroup;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyErrExceptionMatchesNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBaseExceptionGroup})
public class BaseExceptionGroupBuiltins
extends PythonBuiltins {
    private static final TruffleString T_DERIVE = PythonUtils.tsLiteral("derive");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BaseExceptionGroupBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        BaseExceptionGroupBuiltins.createExceptionGroupType(core);
    }

    private static void createExceptionGroupType(Python3Core core) {
        PythonModule builtins = core.getBuiltins();
        Object typeBuiltin = builtins.getAttribute(BuiltinNames.T_TYPE);
        PythonObjectSlowPathFactory factory = core.factory();
        PTuple bases = factory.createTuple(new Object[]{PythonBuiltinClassType.PBaseExceptionGroup, PythonBuiltinClassType.Exception});
        EconomicMapStorage dictStorage = EconomicMapStorage.create(1);
        dictStorage.putUncachedWithJavaEq(SpecialAttributeNames.T___MODULE__, (Object)BuiltinNames.T_BUILTINS);
        PDict dict = factory.createDict(dictStorage);
        Object exceptionGroupType = CallNode.executeUncached(typeBuiltin, BuiltinNames.T_EXCEPTION_GROUP, bases, dict);
        builtins.setAttribute(BuiltinNames.T_EXCEPTION_GROUP, exceptionGroupType);
    }

    @CompilerDirectives.TruffleBoundary
    private static PBaseExceptionGroup subset(Node inliningTarget, PBaseExceptionGroup orig, Object[] exceptions) {
        if (exceptions.length == 0) {
            return null;
        }
        PythonObjectSlowPathFactory factory = PythonContext.get(inliningTarget).factory();
        Object egObj = PyObjectCallMethodObjArgs.executeUncached(orig, T_DERIVE, factory.createTuple(exceptions));
        if (!(egObj instanceof PBaseExceptionGroup)) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DERIVE_MUST_RETURN_AN_INSTANCE_OF_BASE_EXCEPTION_GROUP);
        }
        PBaseExceptionGroup eg = (PBaseExceptionGroup)egObj;
        Object tb = ExceptionNodes.GetTracebackNode.executeUncached(orig);
        if (tb instanceof PTraceback) {
            ExceptionNodes.SetTracebackNode.executeUncached(eg, tb);
        }
        Object context = ExceptionNodes.GetContextNode.executeUncached(orig);
        ExceptionNodes.SetContextNode.executeUncached(eg, context);
        Object cause = ExceptionNodes.GetCauseNode.executeUncached(orig);
        ExceptionNodes.SetCauseNode.executeUncached(eg, cause);
        Object notes = PyObjectLookupAttr.executeUncached(orig, BuiltinNames.T___NOTES__);
        if (notes != PNone.NO_VALUE && PySequenceCheckNode.executeUncached(notes)) {
            PList notesCopy = ListNodes.ConstructListNode.getUncached().execute(null, notes);
            PyObjectSetAttr.executeUncached(eg, BuiltinNames.T___NOTES__, notesCopy);
        }
        return eg;
    }

    @CompilerDirectives.TruffleBoundary
    private static MatcherType getMatcherType(Node inliningTarget, Object value) {
        PTuple tuple;
        if (value instanceof PFunction) {
            return MatcherType.BY_PREDICATE;
        }
        if (BaseExceptionGroupBuiltins.isExceptionTypeUncached(value)) {
            return MatcherType.BY_TYPE;
        }
        if (value instanceof PTuple && PyTupleCheckExactNode.executeUncached(tuple = (PTuple)value)) {
            SequenceStorage storage = tuple.getSequenceStorage();
            for (int i = 0; i < storage.length(); ++i) {
                Object elem = SequenceStorageNodes.GetItemScalarNode.executeUncached(storage, i);
                if (BaseExceptionGroupBuiltins.isExceptionTypeUncached(elem)) continue;
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_A_FUNCTION_EXCEPTION_TYPE_OR_TUPLE_OF_EXCEPTION_TYPES);
            }
            return MatcherType.BY_TYPE;
        }
        throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_A_FUNCTION_EXCEPTION_TYPE_OR_TUPLE_OF_EXCEPTION_TYPES);
    }

    private static boolean isExceptionTypeUncached(Object value) {
        return TypeNodes.IsTypeNode.executeUncached(value) && BuiltinClassProfiles.IsBuiltinClassProfile.profileClassSlowPath(value, PythonBuiltinClassType.PBaseException);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean splitCheckMatch(Object exception, MatcherType matcherType, Object matcherValue) {
        return switch (matcherType.ordinal()) {
            case 0 -> PyErrExceptionMatchesNode.executeUncached(exception, matcherValue);
            case 1 -> PyObjectIsTrueNode.executeUncached(CallNode.executeUncached(matcherValue, exception));
            default -> true;
        };
    }

    @CompilerDirectives.TruffleBoundary
    private static SplitResult splitRecursive(Node inliningTarget, Object exception, MatcherType matcherType, Object matcherValue, boolean constructRest) {
        boolean isMatch = BaseExceptionGroupBuiltins.splitCheckMatch(exception, matcherType, matcherValue);
        if (isMatch) {
            return new SplitResult(exception, null);
        }
        if (!(exception instanceof PBaseExceptionGroup)) {
            if (constructRest) {
                return new SplitResult(null, exception);
            }
            return SplitResult.EMPTY;
        }
        PBaseExceptionGroup eg = (PBaseExceptionGroup)exception;
        ArrayList<Object> matches = new ArrayList<Object>();
        ArrayList<Object> rest = null;
        if (constructRest) {
            rest = new ArrayList<Object>();
        }
        for (Object e : eg.getExceptions()) {
            SplitResult result = BaseExceptionGroupBuiltins.splitRecursive(inliningTarget, e, matcherType, matcherValue, constructRest);
            if (result.match != null) {
                matches.add(result.match);
            }
            if (!constructRest || result.rest == null) continue;
            rest.add(result.rest);
        }
        PBaseExceptionGroup matchGroup = BaseExceptionGroupBuiltins.subset(inliningTarget, eg, matches.toArray());
        PBaseExceptionGroup restGroup = null;
        if (constructRest) {
            restGroup = BaseExceptionGroupBuiltins.subset(inliningTarget, eg, rest.toArray());
        }
        return new SplitResult(matchGroup, restGroup);
    }

    @CompilerDirectives.TruffleBoundary
    private static SplitResult doSplit(PBaseExceptionGroup self, Object matcherValue, Node inliningTarget, boolean constructRest) {
        MatcherType matcherType = BaseExceptionGroupBuiltins.getMatcherType(inliningTarget, matcherValue);
        return BaseExceptionGroupBuiltins.splitRecursive(inliningTarget, self, matcherType, matcherValue, constructRest);
    }

    private static enum MatcherType {
        BY_TYPE,
        BY_PREDICATE,
        INSTANCE_IDS;

    }

    private record SplitResult(Object match, Object rest) {
        static final SplitResult EMPTY = new SplitResult(null, null);
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        ClassGetItemNode() {
        }

        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Builtin(name="subgroup", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubgroupNode
    extends PythonBinaryBuiltinNode {
        SubgroupNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object subgroup(VirtualFrame frame, PBaseExceptionGroup self, Object matcherValue, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData) {
            SplitResult result;
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                result = BaseExceptionGroupBuiltins.doSplit(self, matcherValue, inliningTarget, false);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
            return result.match != null ? result.match : PNone.NONE;
        }
    }

    @Builtin(name="split", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SplitNode
    extends PythonBinaryBuiltinNode {
        SplitNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object split(VirtualFrame frame, PBaseExceptionGroup self, Object matcherValue, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PythonObjectFactory factory) {
            SplitResult result;
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                result = BaseExceptionGroupBuiltins.doSplit(self, matcherValue, inliningTarget, true);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
            Object match = result.match != null ? result.match : PNone.NONE;
            Object rest = result.rest != null ? result.rest : PNone.NONE;
            return factory.createTuple(new Object[]{match, rest});
        }
    }

    @Builtin(name="derive", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DeriveNode
    extends PythonBinaryBuiltinNode {
        DeriveNode() {
        }

        @Specialization
        static Object derive(VirtualFrame frame, PBaseExceptionGroup self, Object exceptions, @Cached CallNode callNode) {
            return callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.PBaseExceptionGroup, self.getMessage(), exceptions);
        }
    }

    @Builtin(name="exceptions", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ExceptionsNode
    extends PythonUnaryBuiltinNode {
        ExceptionsNode() {
        }

        @Specialization
        static Object exceptions(PBaseExceptionGroup self, @Cached PythonObjectFactory factory) {
            return factory.createTuple(self.getExceptions());
        }
    }

    @Builtin(name="message", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class MessageNode
    extends PythonUnaryBuiltinNode {
        MessageNode() {
        }

        @Specialization
        static TruffleString message(PBaseExceptionGroup self) {
            return self.getMessage();
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T1 = PythonUtils.tsLiteral(" (");
        private static final TruffleString T2 = PythonUtils.tsLiteral(" sub-exception");

        StrNode() {
        }

        @Specialization
        static TruffleString str(PBaseExceptionGroup self, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendIntNumberNode appendIntNumberNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(builder, (AbstractTruffleString)self.getMessage());
            appendStringNode.execute(builder, (AbstractTruffleString)T1);
            appendIntNumberNode.execute(builder, self.getExceptions().length);
            appendStringNode.execute(builder, (AbstractTruffleString)T2);
            if (self.getExceptions().length > 1) {
                appendCodePointNode.execute(builder, 115);
            }
            appendCodePointNode.execute(builder, 41);
            return toStringNode.execute(builder);
        }
    }
}

