/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.foreign.ForeignObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.foreign.ForeignObjectBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ForeignObject})
public final class ForeignObjectBuiltins
extends PythonBuiltins {
    public static TpSlots SLOTS = ForeignObjectBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignObjectBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static String asJavaPrefixedMethod(String prefix, String member) {
        return prefix + member.substring(0, 1).toUpperCase() + member.substring(1);
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        @Node.Child
        private ObjectNodes.DefaultObjectReprNode defaultReprNode;

        ReprNode() {
        }

        @Override
        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                if (this.getContext().getEnv().isHostObject(object)) {
                    boolean isMetaObject = lib.isMetaObject(object);
                    Object metaObject = null;
                    if (isMetaObject) {
                        metaObject = object;
                    } else if (lib.hasMetaObject(object)) {
                        metaObject = lib.getMetaObject(object);
                    }
                    if (metaObject != null) {
                        TruffleString displayName = this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(metaObject)), PythonUtils.TS_ENCODING);
                        return StringUtils.simpleTruffleStringFormatUncached("<%s[%s] at 0x%s>", isMetaObject ? "JavaClass" : "JavaObject", displayName, PythonAbstractObject.systemHashCodeAsHexString(object));
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            if (this.defaultReprNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.defaultReprNode = (ObjectNodes.DefaultObjectReprNode)this.insert(ObjectNodes.DefaultObjectReprNode.create());
            }
            return this.defaultReprNode.executeCached((Frame)frame, object);
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode;

        StrNode() {
        }

        @Specialization
        Object str(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(parameters={"T___REPR__"}) LookupAttributeInMRONode lookupAttributeInMRONode, @Cached(parameters={"Repr"}) LookupAndCallUnaryNode reprNode, @CachedLibrary(limit="3") InteropLibrary lib, @Cached ObjectNodes.DefaultObjectReprNode defaultReprNode, @Cached InlinedBranchProfile isIterator, @Cached InlinedBranchProfile defaultCase) {
            Object foreignObjectBuiltinsRepr;
            Object klass = getClassNode.execute(inliningTarget, object);
            Object repr = lookupAttributeInMRONode.execute(klass);
            if (repr != (foreignObjectBuiltinsRepr = lookupAttributeInMRONode.execute((Object)PythonBuiltinClassType.ForeignObject))) {
                return reprNode.executeObject(frame, object);
            }
            if (lib.isIterator(object)) {
                isIterator.enter(inliningTarget);
                return defaultReprNode.execute((Frame)frame, inliningTarget, object);
            }
            defaultCase.enter(inliningTarget);
            return this.defaultConversion(frame, lib, object);
        }

        protected TruffleString.SwitchEncodingNode getSwitchEncodingNode() {
            if (this.switchEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.switchEncodingNode = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
            }
            return this.switchEncodingNode;
        }

        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                return this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(object)), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"toDisplayString result not convertible to String");
            }
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        DirNode() {
        }

        @Specialization
        protected Object doIt(Object object, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached GilNode gil, @Cached PythonObjectFactory.Lazy factory) {
            if (lib.hasMembers(object)) {
                gil.release(true);
                try {
                    Object object2 = lib.getMembers(object);
                    return object2;
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("foreign object claims to have members, but does not return them");
                }
                finally {
                    gil.acquire();
                }
            }
            return factory.get(inliningTarget).createList();
        }
    }

    @Slot(value=Slot.SlotKind.tp_setattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    static abstract class SetattrNode
    extends TpSlotSetAttr.SetAttrBuiltinNode {
        SetattrNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void doSet(Object object, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached CastToJavaStringNode castToString, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            block13: {
                String member;
                gil.release(true);
                try {
                    member = castToString.execute(key);
                }
                catch (CannotCastException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, key);
                }
                try {
                    lib.writeMember(object, member, value);
                    return;
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    if (!PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.EmulateJython).booleanValue()) break block13;
                    try {
                        String setter;
                        if (PythonContext.get(inliningTarget).getEnv().isHostObject(object) && lib.isMemberInvocable(object, setter = ForeignObjectBuiltins.asJavaPrefixedMethod("set", member))) {
                            lib.invokeMember(object, setter, new Object[]{value});
                            return;
                        }
                    }
                    catch (ArityException | UnknownIdentifierException | UnsupportedMessageException throwable) {
                        // empty catch block
                    }
                }
                catch (UnsupportedTypeException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INVALID_TYPE_FOR_S, key);
                }
                finally {
                    gil.acquire();
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, key);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void doDelete(Object object, Object key, PNone value, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached CastToJavaStringNode castToString, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                lib.removeMember(object, castToString.execute(key));
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, key);
            }
            finally {
                gil.acquire();
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class})
    public static abstract class ForeignGetattrNode
    extends Node {
        public abstract Object execute(Node var1, Object var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doIt(Node inliningTarget, Object object, Object memberObj, @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") InteropLibrary read, @Cached(inline=false) CastToJavaStringNode castToString, @Cached(inline=false) GilNode gil, @Cached(inline=false) PForeignToPTypeNode toPythonNode, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                String getter;
                String member;
                try {
                    member = castToString.execute(memberObj);
                }
                catch (CannotCastException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, memberObj);
                }
                if (read.isMemberReadable(object, member)) {
                    Object e = toPythonNode.executeConvert(read.readMember(object, member));
                    return e;
                }
                if (PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.EmulateJython).booleanValue() && PythonContext.get(inliningTarget).getEnv().isHostObject(object) && read.isMemberInvocable(object, getter = ForeignObjectBuiltins.asJavaPrefixedMethod("get", member))) {
                    try {
                        Object object2 = toPythonNode.executeConvert(read.invokeMember(object, getter, new Object[0]));
                        return object2;
                    }
                    catch (UnsupportedTypeException unsupportedTypeException) {}
                }
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException throwable) {
            }
            finally {
                gil.acquire();
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, memberObj);
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        GetAttributeNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object name, @Bind(value="this") Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAttrError, @Cached ForeignGetattrNode foreignGetattrNode) {
            try {
                return objectGetattrNode.execute(frame, self, name);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, isAttrError);
                return foreignGetattrNode.execute(inliningTarget, self, name);
            }
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
        static int hash(Object self, @CachedLibrary(value="self") InteropLibrary library) {
            if (library.hasIdentity(self)) {
                try {
                    return library.identityHashCode(self);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return HashNode.hashCodeBoundary(self);
        }

        @CompilerDirectives.TruffleBoundary
        private static int hashCodeBoundary(Object self) {
            return self.hashCode();
        }
    }
}

