/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tokenize;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.tokenize.PTokenizerIter;
import com.oracle.graal.python.builtins.objects.tokenize.TokenizerIterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTokenizerIter})
public final class TokenizerIterBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TokenizerIterBuiltinsFactory.getFactories();
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T_EOF = PythonUtils.tsLiteral("EOF");

        NextNode() {
        }

        @Specialization
        static PTuple next(PTokenizerIter self, @Bind(value="this") Node inliningTarget, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            int endColumn;
            int startColumn;
            Token token = self.getNextToken();
            if (token.type == 60 || token.type == 0) {
                throw raiseNode.get(inliningTarget).raiseStopIteration(T_EOF);
            }
            if (token.type == 5 || token.type == 6) {
                startColumn = -1;
                endColumn = -1;
            } else {
                startColumn = token.sourceRange.startColumn;
                endColumn = token.sourceRange.endColumn;
            }
            if (token.type == 4) {
                --endColumn;
            }
            return factory.createTuple(new Object[]{fromJavaStringNode.execute(self.getTokenString(token), PythonUtils.TS_ENCODING), token.type, token.sourceRange.startLine, token.sourceRange.endLine, startColumn, endColumn, fromJavaStringNode.execute(self.getLine(token), PythonUtils.TS_ENCODING)});
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static PTokenizerIter iter(PTokenizerIter self) {
            return self;
        }
    }
}

