/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectStrAsObjectNode
extends PNodeWithContext {
    public final Object executeCached(Frame frame, Object object) {
        return this.execute(frame, this, object);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3);

    public final Object execute(Node inliningTarget, Object object) {
        return this.execute(null, inliningTarget, object);
    }

    @Specialization
    static Object str(TruffleString obj) {
        return obj;
    }

    @Specialization
    static TruffleString str(boolean object) {
        return object ? StringLiterals.T_TRUE : StringLiterals.T_FALSE;
    }

    @Specialization
    TruffleString str(long object, @Cached(inline=false) TruffleString.FromLongNode fromLongNode) {
        return fromLongNode.execute(object, PythonUtils.TS_ENCODING, false);
    }

    @Specialization(guards={"!isTruffleString(obj)"})
    static Object str(VirtualFrame frame, Node inliningTarget, Object obj, @Cached GetClassNode getClassNode, @Cached(parameters={"Str"}, inline=false) LookupSpecialMethodSlotNode lookupStr, @Cached(inline=false) CallUnaryMethodNode callStr, @Cached GetClassNode getResultClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached PRaiseNode.Lazy raiseNode) {
        Object type = getClassNode.execute(inliningTarget, obj);
        Object strDescr = lookupStr.execute((Frame)frame, type, obj);
        assert (strDescr != PNone.NO_VALUE);
        Object result = callStr.executeObject((Frame)frame, strDescr, obj);
        if ((result = TruffleStringMigrationHelpers.assertNoJavaString(result)) instanceof TruffleString || isSubtypeNode.execute(getResultClassNode.execute(inliningTarget, result), (Object)PythonBuiltinClassType.PString)) {
            return result;
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_STRING, SpecialMethodNames.T___STR__, result);
    }

    @NeverDefault
    public static PyObjectStrAsObjectNode create() {
        return PyObjectStrAsObjectNodeGen.create();
    }

    public static PyObjectStrAsObjectNode getUncached() {
        return PyObjectStrAsObjectNodeGen.getUncached();
    }
}

