/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSDirectoryStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSFileSystem;
import com.oracle.truffle.polyglot.enterprise.HSPath;
import com.oracle.truffle.polyglot.enterprise.HSPathGen;
import com.oracle.truffle.polyglot.enterprise.HSSeekableByteChannel;
import com.oracle.truffle.polyglot.enterprise.HSSeekableByteChannelGen;
import com.oracle.truffle.polyglot.enterprise.NativeDirectoryStreamFilterGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import org.graalvm.jniutils.HSObject;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativebridge.TypeLiteral;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class HSFileSystemGen {
    HSFileSystemGen() {
    }

    static HSFileSystem createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSFileSystem {
        private static final BinaryMarshaller<Charset> charsetMarshaller;
        private static final BinaryMarshaller<CopyOption> copyOptionMarshaller;
        private static final BinaryMarshaller<FileAttribute<?>> fileAttributeOfObjectMarshaller;
        private static final BinaryMarshaller<LinkOption> linkOptionMarshaller;
        private static final BinaryMarshaller<Map<String, Object>> mapOfStringObjectWithFileAttributeMapMarshaller;
        private static final BinaryMarshaller<Object> objectWithFileAttributeValueMarshaller;
        private static final BinaryMarshaller<Set<? extends AccessMode>> setOfExtendsAccessModeMarshaller;
        private static final BinaryMarshaller<Set<? extends OpenOption>> setOfExtendsOpenOptionMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkAccess(Path path, Set<? extends AccessMode> set, LinkOption ... linkOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)512);
                int n3 = setOfExtendsAccessModeMarshaller.inferSize(set) + 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize((Object)linkOptionArray[0]) : 0);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        setOfExtendsAccessModeMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, set);
                        if (linkOptionArray != null) {
                            cCharPointerBinaryOutput.writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)linkOption);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.checkAccessMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = 4 + (copyOptionArray != null && copyOptionArray.length > 0 ? copyOptionArray.length * copyOptionMarshaller.inferSize((Object)copyOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        if (copyOptionArray != null) {
                            cCharPointerBinaryOutput.writeInt(copyOptionArray.length);
                            for (CopyOption copyOption : copyOptionArray) {
                                copyOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)copyOption);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject(path2 != null ? ((HSObject)path2).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(3).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.copyMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = 4 + (fileAttributeArray != null && fileAttributeArray.length > 0 ? fileAttributeArray.length * fileAttributeOfObjectMarshaller.inferSize(fileAttributeArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        if (fileAttributeArray != null) {
                            cCharPointerBinaryOutput.writeInt(fileAttributeArray.length);
                            for (FileAttribute<?> fileAttribute : fileAttributeArray) {
                                fileAttributeOfObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, fileAttribute);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createDirectoryMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public void createLink(Path path, Path path2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                jValue.addressOf(2).setJObject(path2 != null ? ((HSObject)path2).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createLinkMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = 4 + (fileAttributeArray != null && fileAttributeArray.length > 0 ? fileAttributeArray.length * fileAttributeOfObjectMarshaller.inferSize(fileAttributeArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        if (fileAttributeArray != null) {
                            cCharPointerBinaryOutput.writeInt(fileAttributeArray.length);
                            for (FileAttribute<?> fileAttribute : fileAttributeArray) {
                                fileAttributeOfObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, fileAttribute);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject(path2 != null ? ((HSObject)path2).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(3).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createSymbolicLinkMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public void delete(Path path) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.deleteMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Charset getEncoding(Path path) {
            Charset charset;
            block6: {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                JNI.JByteArray jByteArray = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getEncodingMethod, jValue);
                int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                try {
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                    charset = (Charset)charsetMarshaller.read(binaryInput);
                    if (cCharPointer2 == cCharPointer) break block6;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free((PointerBase)cCharPointer2);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer2);
            }
            return charset;
        }

        public String getMimeType(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)((JNI.JString)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getMimeTypeMethod, jValue)));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public String getPathSeparator() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)((JNI.JString)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getPathSeparatorMethod, jValue)));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public String getSeparator() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)((JNI.JString)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getSeparatorMethod, jValue)));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public Path getTempDirectory() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getTempDirectoryMethod, jValue);
                return jObject.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, jObject) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSameFile(Path path, Path path2, LinkOption ... linkOptionArray) throws IOException {
            boolean bl;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize((Object)linkOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        if (linkOptionArray != null) {
                            cCharPointerBinaryOutput.writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)linkOption);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject(path2 != null ? ((HSObject)path2).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(3).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isSameFileMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = 4 + (copyOptionArray != null && copyOptionArray.length > 0 ? copyOptionArray.length * copyOptionMarshaller.inferSize((Object)copyOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        if (copyOptionArray != null) {
                            cCharPointerBinaryOutput.writeInt(copyOptionArray.length);
                            for (CopyOption copyOption : copyOptionArray) {
                                copyOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)copyOption);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject(path2 != null ? ((HSObject)path2).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(3).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.moveMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
            HSSeekableByteChannel hSSeekableByteChannel;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)512);
                int n3 = setOfExtendsOpenOptionMarshaller.inferSize(set) + 4 + (fileAttributeArray != null && fileAttributeArray.length > 0 ? fileAttributeArray.length * fileAttributeOfObjectMarshaller.inferSize(fileAttributeArray[0]) : 0);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        setOfExtendsOpenOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, set);
                        if (fileAttributeArray != null) {
                            cCharPointerBinaryOutput.writeInt(fileAttributeArray.length);
                            for (FileAttribute<?> fileAttribute : fileAttributeArray) {
                                fileAttributeOfObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, fileAttribute);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray);
                    JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.newByteChannelMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    HSSeekableByteChannel hSSeekableByteChannel2 = hSSeekableByteChannel = jObject.isNonNull() ? HSSeekableByteChannelGen.createNativeToHS(jNIEnv, jObject) : null;
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return hSSeekableByteChannel;
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(CurrentIsolate.getIsolate().rawValue());
                jValue.addressOf(2).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                jValue.addressOf(3).setLong(NativeObjectHandles.create(filter));
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.newDirectoryStreamMethod, jValue);
                return jObject.isNonNull() ? HSDirectoryStreamGen.createNativeToHS(jNIEnv, jObject) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public Path parsePath(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.parsePathMethod2, jValue);
                return jObject.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, jObject) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path parsePath(URI uRI) {
            HSPath hSPath;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = uRIMarshaller.inferSize((Object)uRI);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        uRIMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)uRI);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.parsePathMethod3, (JNI.JValue)cCharPointerBinaryOutput);
                    HSPath hSPath2 = hSPath = jObject.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, jObject) : null;
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return hSPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> readAttributes(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
            Map map;
            block20: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize((Object)linkOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        if (linkOptionArray != null) {
                            cCharPointerBinaryOutput.writeInt(linkOptionArray.length);
                            for (LinkOption object2 : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)object2);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
                    cCharPointerBinaryOutput.addressOf(3).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readAttributesMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n5 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n5);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n5, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n5);
                    map = (Map)mapOfStringObjectWithFileAttributeMapMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return map;
        }

        public Path readSymbolicLink(Path path) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readSymbolicLinkMethod, jValue);
                return jObject.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, jObject) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)512);
                int n3 = objectWithFileAttributeValueMarshaller.inferSize(object) + 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize((Object)linkOptionArray[0]) : 0);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithFileAttributeValueMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        if (linkOptionArray != null) {
                            cCharPointerBinaryOutput.writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)linkOption);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
                    cCharPointerBinaryOutput.addressOf(3).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.setAttributeMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public void setCurrentWorkingDirectory(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.setCurrentWorkingDirectoryMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public Path toAbsolutePath(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toAbsolutePathMethod, jValue);
                return jObject.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, jObject) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path toRealPath(Path path, LinkOption ... linkOptionArray) throws IOException {
            HSPath hSPath;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize((Object)linkOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        if (linkOptionArray != null) {
                            cCharPointerBinaryOutput.writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)linkOption);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject(path != null ? ((HSObject)path).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray);
                    JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toRealPathMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    HSPath hSPath2 = hSPath = jObject.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, jObject) : null;
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return hSPath;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            charsetMarshaller = jNIConfig.lookupMarshaller(Charset.class, new Class[0]);
            copyOptionMarshaller = jNIConfig.lookupMarshaller(CopyOption.class, new Class[0]);
            fileAttributeOfObjectMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<FileAttribute<?>>(){}, new Class[0]);
            linkOptionMarshaller = jNIConfig.lookupMarshaller(LinkOption.class, new Class[0]);
            mapOfStringObjectWithFileAttributeMapMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Map<String, Object>>(){}, new Class[]{PolyglotJNIConfig.FileAttributeMap.class});
            objectWithFileAttributeValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.FileAttributeValue.class});
            setOfExtendsAccessModeMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Set<? extends AccessMode>>(){}, new Class[0]);
            setOfExtendsOpenOptionMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Set<? extends OpenOption>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod checkAccessMethod;
            final JNICalls.JNIMethod copyMethod;
            final JNICalls.JNIMethod createDirectoryMethod;
            final JNICalls.JNIMethod createLinkMethod;
            final JNICalls.JNIMethod createSymbolicLinkMethod;
            final JNICalls.JNIMethod deleteMethod;
            final JNICalls.JNIMethod getEncodingMethod;
            final JNICalls.JNIMethod getMimeTypeMethod;
            final JNICalls.JNIMethod getPathSeparatorMethod;
            final JNICalls.JNIMethod getSeparatorMethod;
            final JNICalls.JNIMethod getTempDirectoryMethod;
            final JNICalls.JNIMethod isSameFileMethod;
            final JNICalls.JNIMethod moveMethod;
            final JNICalls.JNIMethod newByteChannelMethod;
            final JNICalls.JNIMethod newDirectoryStreamMethod;
            final JNICalls.JNIMethod parsePathMethod2;
            final JNICalls.JNIMethod parsePathMethod3;
            final JNICalls.JNIMethod readAttributesMethod;
            final JNICalls.JNIMethod readSymbolicLinkMethod;
            final JNICalls.JNIMethod setAttributeMethod;
            final JNICalls.JNIMethod setCurrentWorkingDirectoryMethod;
            final JNICalls.JNIMethod toAbsolutePathMethod;
            final JNICalls.JNIMethod toRealPathMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.checkAccessMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"checkAccess", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)V");
                this.copyMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"copy", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)V");
                this.createDirectoryMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"createDirectory", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)V");
                this.createLinkMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"createLink", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;)V");
                this.createSymbolicLinkMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"createSymbolicLink", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)V");
                this.deleteMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"delete", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)V");
                this.getEncodingMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getEncoding", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)[B");
                this.getMimeTypeMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getMimeType", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)Ljava/lang/String;");
                this.getPathSeparatorMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getPathSeparator", (String)"(Lorg/graalvm/polyglot/io/FileSystem;)Ljava/lang/String;");
                this.getSeparatorMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getSeparator", (String)"(Lorg/graalvm/polyglot/io/FileSystem;)Ljava/lang/String;");
                this.getTempDirectoryMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getTempDirectory", (String)"(Lorg/graalvm/polyglot/io/FileSystem;)Ljava/nio/file/Path;");
                this.isSameFileMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isSameFile", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)Z");
                this.moveMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"move", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)V");
                this.newByteChannelMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"newByteChannel", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)Ljava/nio/channels/SeekableByteChannel;");
                this.newDirectoryStreamMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"newDirectoryStream", (String)"(Lorg/graalvm/polyglot/io/FileSystem;JLjava/nio/file/Path;J)Ljava/nio/file/DirectoryStream;");
                this.parsePathMethod2 = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"parsePath", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/lang/String;)Ljava/nio/file/Path;");
                this.parsePathMethod3 = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"parsePath", (String)"(Lorg/graalvm/polyglot/io/FileSystem;[B)Ljava/nio/file/Path;");
                this.readAttributesMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"readAttributes", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/lang/String;[B)[B");
                this.readSymbolicLinkMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"readSymbolicLink", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.setAttributeMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"setAttribute", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/lang/String;[B)V");
                this.setCurrentWorkingDirectoryMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"setCurrentWorkingDirectory", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)V");
                this.toAbsolutePathMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"toAbsolutePath", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.toRealPathMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"toRealPath", (String)"(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)Ljava/nio/file/Path;");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Charset> charsetMarshaller;
        private static final BinaryMarshaller<CopyOption> copyOptionMarshaller;
        private static final BinaryMarshaller<FileAttribute<?>> fileAttributeOfObjectMarshaller;
        private static final BinaryMarshaller<LinkOption> linkOptionMarshaller;
        private static final BinaryMarshaller<Map<String, Object>> mapOfStringObjectWithFileAttributeMapMarshaller;
        private static final BinaryMarshaller<Object> objectWithFileAttributeValueMarshaller;
        private static final BinaryMarshaller<Set<? extends AccessMode>> setOfExtendsAccessModeMarshaller;
        private static final BinaryMarshaller<Set<? extends OpenOption>> setOfExtendsOpenOptionMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void checkAccess(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Set set = (Set)setOfExtendsAccessModeMarshaller.read(binaryInput);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    linkOptionArray = new LinkOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = (LinkOption)linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                fileSystem.checkAccess(path, set, linkOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void copy(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                CopyOption[] copyOptionArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    copyOptionArray = new CopyOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CopyOption copyOption;
                        copyOptionArray[i2] = copyOption = (CopyOption)copyOptionMarshaller.read(binaryInput);
                    }
                } else {
                    copyOptionArray = null;
                }
                fileSystem.copy(path, path2, copyOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void createDirectory(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                FileAttribute[] fileAttributeArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    fileAttributeArray = new FileAttribute[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileAttribute fileAttribute;
                        fileAttributeArray[i2] = fileAttribute = (FileAttribute)fileAttributeOfObjectMarshaller.read(binaryInput);
                    }
                } else {
                    fileAttributeArray = null;
                }
                fileSystem.createDirectory(path, fileAttributeArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void createLink(FileSystem fileSystem, Path path, Path path2) {
            try {
                fileSystem.createLink(path, path2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void createSymbolicLink(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                FileAttribute[] fileAttributeArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    fileAttributeArray = new FileAttribute[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileAttribute fileAttribute;
                        fileAttributeArray[i2] = fileAttribute = (FileAttribute)fileAttributeOfObjectMarshaller.read(binaryInput);
                    }
                } else {
                    fileAttributeArray = null;
                }
                fileSystem.createSymbolicLink(path, path2, fileAttributeArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void delete(FileSystem fileSystem, Path path) {
            try {
                fileSystem.delete(path);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] getEncoding(FileSystem fileSystem, Path path) {
            try {
                Charset charset = fileSystem.getEncoding(path);
                int n2 = charsetMarshaller.inferSize((Object)charset);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                charsetMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)charset);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static String getMimeType(FileSystem fileSystem, Path path) {
            try {
                String string = fileSystem.getMimeType(path);
                return string;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static String getPathSeparator(FileSystem fileSystem) {
            try {
                String string = fileSystem.getPathSeparator();
                return string;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static String getSeparator(FileSystem fileSystem) {
            try {
                String string = fileSystem.getSeparator();
                return string;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path getTempDirectory(FileSystem fileSystem) {
            try {
                Path path = fileSystem.getTempDirectory();
                return path;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isSameFile(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                int n2;
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                int n3 = binaryInput.readInt();
                if (n3 != -1) {
                    linkOptionArray = new LinkOption[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        LinkOption linkOption;
                        linkOptionArray[n2] = linkOption = (LinkOption)linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                n2 = fileSystem.isSameFile(path, path2, linkOptionArray) ? 1 : 0;
                return n2 != 0;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void move(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                CopyOption[] copyOptionArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    copyOptionArray = new CopyOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CopyOption copyOption;
                        copyOptionArray[i2] = copyOption = (CopyOption)copyOptionMarshaller.read(binaryInput);
                    }
                } else {
                    copyOptionArray = null;
                }
                fileSystem.move(path, path2, copyOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static SeekableByteChannel newByteChannel(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                FileAttribute[] fileAttributeArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Set set = (Set)setOfExtendsOpenOptionMarshaller.read(binaryInput);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    fileAttributeArray = new FileAttribute[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileAttribute fileAttribute;
                        fileAttributeArray[i2] = fileAttribute = (FileAttribute)fileAttributeOfObjectMarshaller.read(binaryInput);
                    }
                } else {
                    fileAttributeArray = null;
                }
                SeekableByteChannel seekableByteChannel = fileSystem.newByteChannel(path, set, fileAttributeArray);
                return seekableByteChannel;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static DirectoryStream<Path> newDirectoryStream(FileSystem fileSystem, long l2, Path path, long l3) {
            try {
                DirectoryStream directoryStream = fileSystem.newDirectoryStream(path, l3 != 0L ? NativeDirectoryStreamFilterGen.create(NativeIsolate.get((long)l2), l3) : null);
                return directoryStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path parsePath(FileSystem fileSystem, String string) {
            try {
                Path path = fileSystem.parsePath(string);
                return path;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path parsePath(FileSystem fileSystem, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                URI uRI = (URI)uRIMarshaller.read(binaryInput);
                Path path = fileSystem.parsePath(uRI);
                return path;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] readAttributes(FileSystem fileSystem, Path path, String string, byte[] byArray) {
            try {
                Map map;
                int n2;
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                int n3 = binaryInput.readInt();
                if (n3 != -1) {
                    linkOptionArray = new LinkOption[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = (LinkOption)linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = (n2 = mapOfStringObjectWithFileAttributeMapMarshaller.inferSize((Object)(map = fileSystem.readAttributes(path, string, linkOptionArray)))) > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n2) : BinaryOutput.create((byte[])byArray);
                mapOfStringObjectWithFileAttributeMapMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)map);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path readSymbolicLink(FileSystem fileSystem, Path path) {
            try {
                Path path2 = fileSystem.readSymbolicLink(path);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void setAttribute(FileSystem fileSystem, Path path, String string, byte[] byArray) {
            try {
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithFileAttributeValueMarshaller.read(binaryInput);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    linkOptionArray = new LinkOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = (LinkOption)linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                fileSystem.setAttribute(path, string, object, linkOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void setCurrentWorkingDirectory(FileSystem fileSystem, Path path) {
            try {
                fileSystem.setCurrentWorkingDirectory(path);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path toAbsolutePath(FileSystem fileSystem, Path path) {
            try {
                Path path2 = fileSystem.toAbsolutePath(path);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path toRealPath(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    linkOptionArray = new LinkOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = (LinkOption)linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                Path path2 = fileSystem.toRealPath(path, linkOptionArray);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            charsetMarshaller = jNIConfig.lookupMarshaller(Charset.class, new Class[0]);
            copyOptionMarshaller = jNIConfig.lookupMarshaller(CopyOption.class, new Class[0]);
            fileAttributeOfObjectMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<FileAttribute<?>>(){}, new Class[0]);
            linkOptionMarshaller = jNIConfig.lookupMarshaller(LinkOption.class, new Class[0]);
            mapOfStringObjectWithFileAttributeMapMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Map<String, Object>>(){}, new Class[]{PolyglotJNIConfig.FileAttributeMap.class});
            objectWithFileAttributeValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.FileAttributeValue.class});
            setOfExtendsAccessModeMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Set<? extends AccessMode>>(){}, new Class[0]);
            setOfExtendsOpenOptionMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Set<? extends OpenOption>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }
    }
}

