/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativeIsolateSourceCache;
import java.lang.ref.Reference;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class NativeContextDispatch
extends AbstractPolyglotImpl.AbstractContextDispatch {
    private final EnterprisePolyglotImpl impl;
    private final AbstractPolyglotImpl.APIAccess apiAccess;
    private final ThreadLocal<ExplicitlyEnteredIsolate> explicitIsolateStack;

    NativeContextDispatch(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        super((AbstractPolyglotImpl)enterprisePolyglotImpl);
        this.impl = enterprisePolyglotImpl;
        this.apiAccess = enterprisePolyglotImpl.getAPIAccess();
        this.explicitIsolateStack = new ThreadLocal();
    }

    public final void setContextAPIReference(Object object, Reference<Context> reference) {
        ((NativeContext)((Object)object)).setContextAPIReference(reference);
    }

    public final Object asValue(Object object, Object object2) {
        return this.apiAccess.contextAsValue((Object)((NativeContext)((Object)object)).getLocalContext(), object2);
    }

    public final Object eval(Object object, String string, Object object2) {
        return this.parseEval(object, string, object2, true);
    }

    public final Object parse(Object object, String string, Object object2) {
        return this.parseEval(object, string, object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseEval(Object object, String string, Object object2, boolean bl) {
        NativeContext nativeContext = (NativeContext)((Object)object);
        Context context = nativeContext.getLocalContext();
        Object object3 = this.enterIfNeeded(context);
        try {
            Object object4;
            long l2 = nativeContext.getSourceCache().translate(object2);
            try {
                object4 = nativeContext.getPolyglotIsolateServices().parseEval((Object)nativeContext, string, l2, bl);
            }
            catch (Throwable throwable) {
                if (!NativeIsolateSourceCache.isSourceRemotelyCacheable(object2, this.apiAccess)) {
                    nativeContext.getSourceCache().release(l2);
                }
                throw throwable;
            }
            if (!NativeIsolateSourceCache.isSourceRemotelyCacheable(object2, this.apiAccess)) {
                nativeContext.getSourceCache().release(l2);
            }
            return object4;
        }
        finally {
            this.leaveIfNeeded(context, object3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initializeLanguage(Object object, String string) {
        Context context = ((NativeContext)((Object)object)).getLocalContext();
        Object object2 = this.enterIfNeeded(context);
        try {
            boolean bl = this.initializeLanguageImpl(object, string);
            return bl;
        }
        finally {
            this.leaveIfNeeded(context, object2);
        }
    }

    abstract boolean initializeLanguageImpl(Object var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(Object object, boolean bl) {
        block8: {
            NativeContext nativeContext;
            block7: {
                boolean bl2;
                NativeIsolate nativeIsolate;
                block6: {
                    nativeContext = (NativeContext)((Object)object);
                    nativeIsolate = nativeContext.getIsolate();
                    boolean bl3 = this.impl.requireContextRegistered(nativeContext);
                    if (!bl3) break block7;
                    bl2 = false;
                    try {
                        NativeIsolateThread nativeIsolateThread = nativeIsolate.tryEnter();
                        if (nativeIsolateThread != null) {
                            try {
                                this.closeImpl(object, bl);
                                bl2 = true;
                                break block6;
                            }
                            finally {
                                nativeIsolateThread.leave();
                                this.clearExplicitContextStack(nativeContext);
                            }
                        }
                        this.apiAccess.contextClose((Object)nativeContext.getLocalContext(), bl);
                    }
                    catch (Throwable throwable) {
                        this.impl.releaseContextRegisteredRequirement(nativeContext, !nativeIsolate.isActive() && bl2);
                        throw throwable;
                    }
                }
                this.impl.releaseContextRegisteredRequirement(nativeContext, !nativeIsolate.isActive() && bl2);
                break block8;
            }
            this.apiAccess.contextClose((Object)nativeContext.getLocalContext(), bl);
            this.clearExplicitContextStack(nativeContext);
        }
    }

    private void clearExplicitContextStack(NativeContext nativeContext) {
        ExplicitlyEnteredIsolate explicitlyEnteredIsolate = this.explicitIsolateStack.get();
        if (explicitlyEnteredIsolate != null && explicitlyEnteredIsolate.jniContext == nativeContext && !EnterpriseEngineAccessor.ENGINE.isContextEntered(this.apiAccess.getContextReceiver((Object)nativeContext.getLocalContext()))) {
            while (explicitlyEnteredIsolate != null && explicitlyEnteredIsolate.jniContext == nativeContext) {
                explicitlyEnteredIsolate.nativeIsolateThread.leave();
                explicitlyEnteredIsolate = explicitlyEnteredIsolate.previous;
            }
            this.explicitIsolateStack.set(explicitlyEnteredIsolate);
        }
    }

    abstract void closeImpl(Object var1, boolean var2);

    public final void explicitEnter(Object object) {
        NativeContext nativeContext = (NativeContext)((Object)object);
        this.apiAccess.contextEnter((Object)nativeContext.getLocalContext());
        try {
            NativeIsolateThread nativeIsolateThread = nativeContext.getIsolate().enter();
            this.explicitIsolateStack.set(new ExplicitlyEnteredIsolate(nativeContext, nativeIsolateThread, this.explicitIsolateStack.get()));
            this.explicitEnterImpl(object);
        }
        catch (Throwable throwable) {
            this.apiAccess.contextLeave((Object)nativeContext.getLocalContext());
            throw throwable;
        }
    }

    abstract void explicitEnterImpl(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void explicitLeave(Object object) {
        NativeContext nativeContext = (NativeContext)((Object)object);
        try {
            if (nativeContext.getIsolate().isActive()) {
                this.explicitLeaveImpl(object);
                ExplicitlyEnteredIsolate explicitlyEnteredIsolate = this.explicitIsolateStack.get();
                this.explicitIsolateStack.set(explicitlyEnteredIsolate.previous);
                explicitlyEnteredIsolate.nativeIsolateThread.leave();
            }
        }
        finally {
            this.apiAccess.contextLeave((Object)nativeContext.getLocalContext());
        }
    }

    abstract void explicitLeaveImpl(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getBindings(Object object, String string) {
        Context context = ((NativeContext)((Object)object)).getLocalContext();
        Object object2 = this.enterIfNeeded(context);
        try {
            Object object3 = this.getBindingsImpl(object, string);
            return object3;
        }
        finally {
            this.leaveIfNeeded(context, object2);
        }
    }

    abstract Object getBindingsImpl(Object var1, String var2);

    public abstract Object getPolyglotBindings(Object var1);

    private Object enterIfNeeded(Object object) {
        Object object2 = this.apiAccess.getContextReceiver(object);
        return EnterpriseEngineAccessor.ENGINE.enterIfNeeded(object2);
    }

    private void leaveIfNeeded(Object object, Object object2) {
        Object object3 = this.apiAccess.getContextReceiver(object);
        EnterpriseEngineAccessor.ENGINE.leaveIfNeeded(object3, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onContextCollected(Object object) {
        NativeContext nativeContext = (NativeContext)((Object)object);
        NativeIsolate nativeIsolate = nativeContext.getIsolate();
        NativeIsolateThread nativeIsolateThread = nativeIsolate.tryEnter();
        if (nativeIsolateThread != null) {
            try {
                this.onContextCollectedImpl(object);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }
    }

    abstract void onContextCollectedImpl(Object var1);

    static AbstractPolyglotImpl.AbstractContextDispatch resolveNativeDelegate(Object object) {
        return EnterprisePolyglotImpl.instance.getAPIAccess().getContextDispatch(object);
    }

    static Object resolveReceiver(Object object) {
        return EnterprisePolyglotImpl.instance.getAPIAccess().getContextReceiver(object);
    }

    private static final class ExplicitlyEnteredIsolate {
        final NativeContext jniContext;
        final NativeIsolateThread nativeIsolateThread;
        final ExplicitlyEnteredIsolate previous;

        ExplicitlyEnteredIsolate(NativeContext nativeContext, NativeIsolateThread nativeIsolateThread, ExplicitlyEnteredIsolate explicitlyEnteredIsolate) {
            this.jniContext = nativeContext;
            this.nativeIsolateThread = nativeIsolateThread;
            this.previous = explicitlyEnteredIsolate;
        }
    }
}

