/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeOptionDescriptorIterator;
import com.oracle.truffle.polyglot.enterprise.NativeOptionDescriptorIteratorGen;
import com.oracle.truffle.polyglot.enterprise.NativeOptionDescriptors;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.Iterator;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.word.WordFactory;

final class NativeOptionDescriptorsGen {
    NativeOptionDescriptorsGen() {
    }

    static NativeOptionDescriptors createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionDescriptors createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionDescriptors create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativeOptionDescriptorsGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativeOptionDescriptorsGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativeOptionDescriptors {
        private static final BinaryMarshaller<OptionDescriptor> optionDescriptorMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        public OptionDescriptor get(String string) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.get0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), string);
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                OptionDescriptor optionDescriptor = (OptionDescriptor)optionDescriptorMarshaller.read(binaryInput);
                return optionDescriptor;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Iterator<OptionDescriptor> iterator() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long l2 = StartPoint.iterator0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                NativeOptionDescriptorIterator nativeOptionDescriptorIterator = l2 != 0L ? NativeOptionDescriptorIteratorGen.create(this.getIsolate(), l2) : null;
                return nativeOptionDescriptorIterator;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native byte[] get0(long var0, long var2, String var4);

        private static native long iterator0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            optionDescriptorMarshaller = jNIConfig.lookupMarshaller(OptionDescriptor.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<OptionDescriptor> optionDescriptorMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOptionDescriptorsGen_00024StartPoint_get0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray get(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeOptionDescriptorsGen::get", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                OptionDescriptors optionDescriptors = (OptionDescriptors)NativeObjectHandles.resolve((long)l3, OptionDescriptors.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                OptionDescriptor optionDescriptor = optionDescriptors.get(JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString));
                int n2 = optionDescriptorMarshaller.inferSize((Object)optionDescriptor);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    optionDescriptorMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)optionDescriptor);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOptionDescriptorsGen_00024StartPoint_iterator0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long iterator(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            long l4;
            block8: {
                JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeOptionDescriptorsGen::iterator", (JNI.JNIEnv)jNIEnv);
                try {
                    OptionDescriptors optionDescriptors = (OptionDescriptors)NativeObjectHandles.resolve((long)l3, OptionDescriptors.class);
                    Iterator iterator = optionDescriptors.iterator();
                    l4 = NativeObjectHandles.create((Object)iterator);
                    if (jNIMethodScope == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (jNIMethodScope != null) {
                            try {
                                jNIMethodScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                        return 0L;
                    }
                }
                jNIMethodScope.close();
            }
            return l4;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            optionDescriptorMarshaller = jNIConfig.lookupMarshaller(OptionDescriptor.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

