/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.API;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFIParserException;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

@Bind.DefaultExpression(value="get($node)")
final class NFIContext {
    TruffleLanguage.Env env;
    final ReentrantLock apiCacheLock = new ReentrantLock();
    final Map<String, API> apiCache = new ConcurrentHashMap<String, API>();
    private static final TruffleLanguage.ContextReference<NFIContext> REFERENCE = TruffleLanguage.ContextReference.create(NFILanguage.class);

    NFIContext(TruffleLanguage.Env env) {
        this.env = env;
    }

    void patch(TruffleLanguage.Env newEnv) {
        this.env = newEnv;
        this.apiCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    API getAPI(String backendId, Node node) {
        API ret = this.apiCache.get(backendId);
        if (ret != null) {
            return ret;
        }
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, ReentrantLock::lockInterruptibly, (Object)this.apiCacheLock);
        try {
            ret = this.apiCache.get(backendId);
            if (ret != null) {
                API aPI = ret;
                return aPI;
            }
            for (LanguageInfo language : this.env.getInternalLanguages().values()) {
                if ("nfi".equals(language.getId())) continue;
                NFIBackendFactory backendFactory = (NFIBackendFactory)this.env.lookup(language, NFIBackendFactory.class);
                if (backendFactory == null || !backendFactory.getBackendId().equals(backendId)) continue;
                this.env.initializeLanguage(language);
                NFIBackend backend = backendFactory.createBackend(NFILanguage.get(null).nfiState);
                API api = new API(backendId, backend);
                this.apiCache.put(backendFactory.getBackendId(), api);
                API aPI = api;
                return aPI;
            }
        }
        finally {
            this.apiCacheLock.unlock();
        }
        throw new NFIParserException(String.format("Unknown NFI backend '%s'.", backendId), false);
    }

    static NFIContext get(Node node) {
        return (NFIContext)REFERENCE.get(node);
    }
}

