/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.AbstractTranscoder;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.JavaStringCodec;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public final class DefaultTranscoder
extends AbstractTranscoder {
    private static final Set<MediaType> supportedTypes = new HashSet<MediaType>();
    private final Marshaller marshaller;

    public DefaultTranscoder(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                return this.convertToOctetStream(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return this.convertToObject(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.TEXT_PLAIN)) {
                return this.convertToTextPlain(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
                return content;
            }
            throw Log.CONTAINER.unsupportedConversion(Util.toStr(content), contentType, destinationType);
        }
        catch (IOException | ClassNotFoundException | InterruptedException | EncodingException e) {
            throw Log.CONTAINER.errorTranscoding(Util.toStr(content), contentType, destinationType, e);
        }
    }

    private Object convertToTextPlain(Object content, MediaType contentType, MediaType destinationType) {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            return StandardConversions.convertCharset(content, StandardCharsets.UTF_8, destinationType.getCharset());
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            if (content instanceof byte[]) {
                return StandardConversions.convertCharset(content, StandardCharsets.UTF_8, destinationType.getCharset());
            }
            return content.toString().getBytes(destinationType.getCharset());
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToText(content, contentType, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return content;
        }
        throw Log.CONTAINER.unsupportedConversion(Util.toStr(content), contentType, destinationType);
    }

    private Object convertToObject(Object content, MediaType contentType, MediaType destinationType) throws IOException, ClassNotFoundException {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            String classType = destinationType.getClassType();
            if (classType != null && !classType.startsWith("java.lang") && !classType.equals(JavaStringCodec.BYTE_ARRAY.getName())) {
                Object unmarshalled = this.marshaller.objectFromByteBuffer((byte[])content);
                if (unmarshalled.getClass().getName().equals(classType)) {
                    return unmarshalled;
                }
            } else {
                return content;
            }
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return content;
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToObject(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return content instanceof byte[] ? new String((byte[])content, destinationType.getCharset()) : content.toString();
        }
        throw Log.CONTAINER.unsupportedConversion(Util.toStr(content), contentType, destinationType);
    }

    public Object convertToOctetStream(Object content, MediaType contentType, MediaType destinationType) throws IOException, InterruptedException {
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            if (content instanceof byte[]) {
                return content;
            }
            if (content instanceof String) {
                return content.toString().getBytes(StandardCharsets.UTF_8);
            }
            return this.marshaller.objectToByteBuffer(content);
        }
        return content;
    }

    @Override
    public Set<MediaType> getSupportedMediaTypes() {
        return supportedTypes;
    }

    private boolean in(MediaType mediaType, Set<MediaType> set) {
        return set.stream().anyMatch(s -> s.match(mediaType));
    }

    @Override
    public boolean supportsConversion(MediaType mediaType, MediaType other) {
        return this.in(mediaType, supportedTypes) && this.in(other, supportedTypes);
    }

    static {
        supportedTypes.add(MediaType.APPLICATION_OBJECT);
        supportedTypes.add(MediaType.APPLICATION_OCTET_STREAM);
        supportedTypes.add(MediaType.APPLICATION_WWW_FORM_URLENCODED);
        supportedTypes.add(MediaType.TEXT_PLAIN);
    }
}

