/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.controllers.views.context;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.japura.Application;
import org.japura.controller.Controller;
import org.japura.controller.Group;
import org.japura.controller.messages.ScreenShotMessage;
import org.japura.debug.controllers.views.context.ControllerComponent;
import org.japura.message.Message;
import org.japura.message.Subscriber;
import org.japura.message.SubscriberFilter;

class GroupComponent
extends JPanel {
    private static final long serialVersionUID = 1L;

    public GroupComponent(Group group, boolean withScreenshot) {
        this.setBackground(new Color(200, 220, 190));
        Border out = BorderFactory.createLineBorder(Color.BLACK, 2);
        Border in = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.setBorder(BorderFactory.createCompoundBorder(out, in));
        this.setLayout(new BorderLayout(0, 5));
        JPanel northPanel = new JPanel();
        northPanel.setOpaque(false);
        northPanel.setLayout(new GridLayout(3, 1));
        northPanel.add(new JLabel("GROUP"));
        northPanel.add(new JLabel("Name: " + group.getName()));
        northPanel.add(new JLabel("Id: " + group.getId()));
        JPanel centerPanel = new JPanel();
        centerPanel.setOpaque(false);
        centerPanel.setLayout(new FlowLayout(0, 10, 0));
        Collection controllers = group.getAll();
        JPanel controllersPanel = new JPanel();
        controllersPanel.setOpaque(false);
        controllersPanel.setLayout(new GridLayout(controllers.size(), 1, 0, 10));
        for (Controller controller : controllers) {
            controllersPanel.add(new ControllerComponent(controller));
        }
        centerPanel.add(controllersPanel);
        if (withScreenshot) {
            ScreenShotMessage ssm = new ScreenShotMessage();
            Controller rootController = group.getRootController();
            ssm.addSubscriberFilter((SubscriberFilter)new Filter(rootController));
            Application.getMessageManager().publish(true, (Message)ssm, (Object)this);
            Image image = ssm.getScreenShot();
            int s = 400;
            if (image.getWidth(null) > s) {
                image = image.getScaledInstance(s, -1, 4);
            }
            if (image.getHeight(null) > s) {
                image = image.getScaledInstance(-1, s, 4);
            }
            JLabel preview = new JLabel();
            preview.setIcon(new ImageIcon(image));
            preview.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            centerPanel.add(preview);
        }
        this.add((Component)northPanel, "North");
        this.add((Component)centerPanel, "Center");
    }

    private static class Filter
    implements SubscriberFilter {
        private Controller controller;

        public Filter(Controller controller) {
            this.controller = controller;
        }

        public boolean accepts(Subscriber subscriber) {
            return this.controller.equals(subscriber);
        }
    }
}

