/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.tasks.executions;

import java.util.Collection;
import org.japura.task.Task;
import org.japura.task.TaskStatus;
import org.japura.task.messages.notify.TaskExecutionMessage;
import org.japura.util.info.InfoNode;

public class Execution {
    private int level;
    private String sessionId;
    private boolean parallel;
    private String taskId;
    private String taskClass;
    private String taskName;
    private Collection<InfoNode> taskInfoNodes;
    private Collection<InfoNode> sessionInfoNodes;
    private Collection<InfoNode> executorInfoNodes;
    private Collection<InfoNode> contextInfoNodes;
    private TaskStatus status;

    public Execution(TaskExecutionMessage msg) {
        this.parallel = msg.isParallel();
        Task task = msg.getTask();
        this.sessionId = msg.getSessionId();
        String packageName = task.getClass().getPackage().getName();
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        String className = task.getClass().getName();
        this.taskClass = className.substring(packageName.length(), className.length());
        this.taskId = task.getId();
        this.level = task.getNestedLevel();
        this.taskName = task.getName();
        this.status = task.getStatus();
        this.taskInfoNodes = task.getInfoNodes();
        this.executorInfoNodes = task.getTaskExecutor().getInfoNodes();
        this.sessionInfoNodes = msg.getSessionInfoNodes();
        this.contextInfoNodes = msg.getContextInfoNodes();
    }

    public Collection<InfoNode> getContextInfoNodes() {
        return this.contextInfoNodes;
    }

    public Collection<InfoNode> getTaskInfoNodes() {
        return this.taskInfoNodes;
    }

    public Collection<InfoNode> getExecutorInfoNodes() {
        return this.executorInfoNodes;
    }

    public Collection<InfoNode> getSessionInfoNodes() {
        return this.sessionInfoNodes;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getLevel() {
        return this.level;
    }
}

