/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.tasks.executions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.japura.debug.tasks.executions.EmptySpace;
import org.japura.debug.tasks.executions.Execution;
import org.japura.debug.tasks.executions.LineEnd;
import org.japura.debug.tasks.executions.LineHorizontal;
import org.japura.debug.tasks.executions.LineMiddle;
import org.japura.debug.tasks.executions.LineParallel;
import org.japura.debug.tasks.executions.LineVertical;
import org.japura.debug.tasks.executions.SessionExecutions;
import org.japura.debug.tasks.executions.TaskPanel;
import org.japura.debug.tasks.executions.TaskPanelListener;
import org.japura.task.messages.notify.TaskExecutionMessage;

public class ExecutionViewPanel
extends JPanel {
    private static final long serialVersionUID = 4L;
    private TaskPanelListener listener;
    private List<SessionExecutions> executions = new ArrayList<SessionExecutions>();
    private Map<Execution, ExecutionPanel> executionViewPanels = new HashMap<Execution, ExecutionPanel>();
    private int executionsLimit = 50;

    public ExecutionViewPanel(TaskPanelListener listener) {
        this.listener = listener;
        this.setBackground(Color.WHITE);
        this.setLayout((LayoutManager)new MigLayout("wrap 1, ins 10 5 10 5, gap 0 0", "grow", ""));
    }

    public void clear() {
        this.executions.clear();
        this.refresh();
    }

    public void perform(TaskExecutionMessage msg) {
        Execution e = new Execution(msg);
        if (this.executions.size() == 0) {
            SessionExecutions ec = new SessionExecutions(e.getSessionId());
            ec.add(e);
            this.executions.add(ec);
        } else {
            SessionExecutions ec = this.executions.get(0);
            if (ec.getSessionId().equals(e.getSessionId())) {
                ec.add(0, e);
            } else {
                ec = new SessionExecutions(e.getSessionId());
                ec.add(e);
                this.executions.add(0, ec);
            }
        }
        if (this.executions.size() > this.executionsLimit) {
            this.executions.remove(this.executions.size() - 1);
        }
        this.refresh();
    }

    public void updateSelection(Execution e) {
        for (Map.Entry<Execution, ExecutionPanel> entry : this.executionViewPanels.entrySet()) {
            Execution e2 = entry.getKey();
            if (e2.equals(e)) {
                entry.getValue().connectorPanel.setOpaque(true);
                continue;
            }
            entry.getValue().connectorPanel.setOpaque(false);
        }
        this.repaint();
    }

    private void refresh() {
        this.executionViewPanels.clear();
        this.removeAll();
        if (this.executions.size() == 0) {
            return;
        }
        for (int j = 0; j < this.executions.size(); ++j) {
            SessionExecutions ec = this.executions.get(j);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ec.size() - 1; ++i) {
                sb.append("[]");
            }
            sb.append("[grow]");
            this.add((Component)new LineHorizontal(), "grow x, wrap");
            JPanel sessionExecutionsPanel = new JPanel();
            sessionExecutionsPanel.setOpaque(false);
            sessionExecutionsPanel.setLayout((LayoutManager)new MigLayout("wrap 1,ins 0 0 0 0,  gap  0 0 0 0", "grow", sb.toString()));
            this.add((Component)sessionExecutionsPanel, "grow");
            for (int i = 0; i < ec.size(); ++i) {
                Execution e = (Execution)ec.get(i);
                JPanel executionContainer = new JPanel();
                executionContainer.setOpaque(false);
                if (i == ec.size() - 1) {
                    executionContainer.setLayout((LayoutManager)new MigLayout("wrap 1, ins 0 0 0 0,  gap  0 0", "grow", "[][][grow]"));
                } else {
                    executionContainer.setLayout((LayoutManager)new MigLayout(" wrap 1, ins 0 0 0 0,  gap  0 0", "grow", "[][][]"));
                }
                if (j == 0 && i == 0) {
                    executionContainer.add((Component)new EmptySpace(), "");
                } else {
                    executionContainer.add((Component)new LineVertical(), "");
                }
                int level = e.getLevel();
                ExecutionPanel executionPanel = new ExecutionPanel(new TaskPanel(e, this.listener));
                this.executionViewPanels.put(e, executionPanel);
                if (i == 0) {
                    if (j == 0) {
                        executionContainer.add((Component)new LineEnd(level), "grow y, split 2");
                        executionContainer.add((Component)executionPanel, "grow x");
                    } else if (e.isParallel()) {
                        executionContainer.add((Component)new LineParallel(level), "grow y, split 2");
                        executionContainer.add((Component)executionPanel, "grow x");
                    } else {
                        executionContainer.add((Component)new LineMiddle(level), "grow y, split 2");
                        executionContainer.add((Component)executionPanel, "grow x");
                    }
                } else if (e.isParallel()) {
                    executionContainer.add((Component)new LineParallel(level), "grow y, split 2");
                    executionContainer.add((Component)executionPanel, "grow x");
                } else {
                    executionContainer.add((Component)new LineMiddle(level), "grow y, split 2");
                    executionContainer.add((Component)executionPanel, "grow x");
                }
                if (i == ec.size() - 1) {
                    executionContainer.add((Component)new LineVertical(), "grow y");
                    sessionExecutionsPanel.add((Component)executionContainer, "grow");
                    continue;
                }
                executionContainer.add((Component)new LineVertical(), "");
                sessionExecutionsPanel.add((Component)executionContainer, "grow x");
            }
        }
        this.add((Component)new LineHorizontal(), " grow x");
        this.revalidate();
    }

    private static class ExecutionPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private ConnectorPanel connectorPanel = new ConnectorPanel();

        public ExecutionPanel(TaskPanel tp) {
            this.setOpaque(false);
            this.setLayout((LayoutManager)new MigLayout(" ins 0 0 0 0", "[]15[grow]"));
            this.add(tp);
            this.add((Component)this.connectorPanel, "grow x");
            this.connectorPanel.setOpaque(false);
        }
    }

    private static class ConnectorPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ConnectorPanel() {
            this.setBackground(Color.lightGray);
            this.setPreferredSize(new Dimension(50, 20));
        }
    }
}

