/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.tasks.executions;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.japura.debug.tasks.executions.AbstractLine;

class LineParallel
extends AbstractLine {
    private static final long serialVersionUID = 1L;
    private int gap = 20;
    private int h = 50;
    private int l = 15;

    public LineParallel(int level) {
        super(level);
    }

    @Override
    public Dimension getPreferredSize() {
        if (super.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension(this.gap + this.w, Math.max(this.h, this.l));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        int cy = this.getHeight() / 2;
        int x = this.gap;
        g2.setStroke(this.getStroke());
        if (this.h > 0) {
            g2.drawLine(x, 0, x, this.getHeight());
        }
        if (this.w > 0 && this.l > 0) {
            int x2;
            int x1;
            int y;
            int i;
            g2.drawLine(x, cy, this.getWidth() - this.l, cy);
            for (i = 0; i < this.l / 2; ++i) {
                y = cy - this.l / 2 + i;
                x1 = this.getWidth() - this.l;
                x2 = x1 + i * 2;
                g2.drawLine(x1, y, x2, y);
            }
            for (i = 0; i <= this.l / 2; ++i) {
                y = cy + i;
                x1 = this.getWidth() - this.l;
                x2 = x1 + this.l - i * 2;
                g2.drawLine(x1, y, x2, y);
            }
        }
    }

    public static void main(String[] das) {
        JFrame f = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        LineParallel l2 = new LineParallel(0);
        panel.add(l2);
        f.add(panel);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

