/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.tasks.executions;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.miginfocom.swing.MigLayout;
import org.japura.debug.tasks.executions.Execution;
import org.japura.debug.tasks.executions.TaskPanelListener;
import org.japura.task.TaskStatus;

public class TaskPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Execution e;
    private TaskPanelListener listener;

    public TaskPanel(Execution e, TaskPanelListener listener) {
        this.e = e;
        this.listener = listener;
        TaskStatus status = e.getStatus();
        this.setBackground(Color.WHITE);
        if (status.equals((Object)TaskStatus.ERROR)) {
            this.updateBorder(Color.RED);
        } else if (status.equals((Object)TaskStatus.CANCELED)) {
            this.updateBorder(Color.YELLOW);
        } else if (status.equals((Object)TaskStatus.DONE)) {
            this.updateBorder(Color.GREEN);
        } else if (status.equals((Object)TaskStatus.DISCARDED)) {
            this.updateBorder(Color.ORANGE);
        } else {
            this.updateBorder(Color.BLACK);
        }
        this.setLayout((LayoutManager)new MigLayout());
        this.add((Component)new JLabel("Class: " + e.getTaskClass()), "wrap");
        this.add((Component)new JLabel("Name: " + e.getTaskName()), "wrap");
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TaskPanel.this.listener.action(TaskPanel.this.getE());
            }
        };
        this.addMouseListener(ma);
    }

    public Execution getE() {
        return this.e;
    }

    private void updateBorder(Color color) {
        Border in = BorderFactory.createLineBorder(Color.GRAY, 1);
        Border out = BorderFactory.createLineBorder(color, 3);
        CompoundBorder in2 = BorderFactory.createCompoundBorder(out, in);
        Border out2 = BorderFactory.createLineBorder(Color.GRAY, 1);
        this.setBorder(BorderFactory.createCompoundBorder(out2, in2));
    }
}

