/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ProxyBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.specimpl.ResteasyUriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyUriBuilder;

public class ClientWebTarget
implements ResteasyWebTarget {
    protected ResteasyClient client;
    protected UriBuilder uriBuilder;
    protected ClientConfiguration configuration;
    protected boolean chunked = false;

    protected ClientWebTarget(ResteasyClient client, ClientConfiguration configuration) {
        this.configuration = new ClientConfiguration(configuration);
        this.client = client;
    }

    public ClientWebTarget(ResteasyClient client, String uri, ClientConfiguration configuration) throws IllegalArgumentException, NullPointerException {
        this(client, configuration);
        this.uriBuilder = ClientWebTarget.uriBuilderFromUri(uri);
    }

    public ClientWebTarget(ResteasyClient client, URI uri, ClientConfiguration configuration) throws NullPointerException {
        this(client, configuration);
        this.uriBuilder = ClientWebTarget.uriBuilderFromUri(uri);
    }

    public ClientWebTarget(ResteasyClient client, UriBuilder uriBuilder, ClientConfiguration configuration) throws NullPointerException {
        this(client, configuration);
        this.uriBuilder = uriBuilder.clone();
    }

    private static UriBuilder uriBuilderFromUri(URI uri) {
        return new ResteasyUriBuilderImpl().uri(uri);
    }

    private static UriBuilder uriBuilderFromUri(String uri) {
        return new ResteasyUriBuilderImpl().uri(uri);
    }

    public ResteasyWebTarget clone() {
        this.client.abortIfClosed();
        UriBuilder copy = this.uriBuilder.clone();
        return this.newInstance(this.client, copy, this.configuration);
    }

    public ResteasyClient getResteasyClient() {
        this.client.abortIfClosed();
        return this.client;
    }

    public <T> T proxy(Class<T> proxyInterface) {
        this.client.abortIfClosed();
        return (T)this.createProxyBuilder(proxyInterface, this).build();
    }

    public <T> ProxyBuilder<T> proxyBuilder(Class<T> proxyInterface) {
        this.client.abortIfClosed();
        if (proxyInterface == null) {
            throw new NullPointerException(Messages.MESSAGES.proxyInterfaceWasNull());
        }
        return this.createProxyBuilder(proxyInterface, this);
    }

    protected <T> ProxyBuilder<T> createProxyBuilder(Class<T> proxyInterface, ClientWebTarget cwt) {
        return ProxyBuilder.builder(proxyInterface, (WebTarget)cwt);
    }

    public URI getUri() {
        this.client.abortIfClosed();
        return this.uriBuilder.build(new Object[0]);
    }

    public UriBuilder getUriBuilder() {
        this.client.abortIfClosed();
        return this.uriBuilder.clone();
    }

    public Configuration getConfiguration() {
        this.client.abortIfClosed();
        return this.configuration;
    }

    public ResteasyWebTarget path(String path) throws NullPointerException {
        this.client.abortIfClosed();
        if (path == null) {
            throw new NullPointerException(Messages.MESSAGES.pathWasNull());
        }
        UriBuilder copy = this.uriBuilder.clone().path(path);
        return this.newInstance(this.client, copy, this.configuration);
    }

    public ResteasyWebTarget path(Class<?> resource) throws IllegalArgumentException {
        this.client.abortIfClosed();
        if (resource == null) {
            throw new NullPointerException(Messages.MESSAGES.resourceWasNull());
        }
        UriBuilder copy = this.uriBuilder.clone().path(resource);
        return this.newInstance(this.client, copy, this.configuration);
    }

    public ResteasyWebTarget path(Method method) throws IllegalArgumentException {
        this.client.abortIfClosed();
        if (method == null) {
            throw new NullPointerException(Messages.MESSAGES.methodWasNull());
        }
        UriBuilder copy = this.uriBuilder.clone().path(method);
        return this.newInstance(this.client, copy, this.configuration);
    }

    public ResteasyWebTarget resolveTemplate(String name, Object value) throws NullPointerException {
        this.client.abortIfClosed();
        if (name == null) {
            throw new NullPointerException(Messages.MESSAGES.nameWasNull());
        }
        if (value == null) {
            throw new NullPointerException(Messages.MESSAGES.valueWasNull());
        }
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.clone().resolveTemplate(name, (Object)val);
        ClientWebTarget target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public ResteasyWebTarget resolveTemplates(Map<String, Object> templateValues) throws NullPointerException {
        this.client.abortIfClosed();
        if (templateValues == null) {
            throw new NullPointerException(Messages.MESSAGES.templateValuesWasNull());
        }
        if (templateValues.isEmpty()) {
            return this;
        }
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException(Messages.MESSAGES.templateValuesEntryWasNull());
            }
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.clone().resolveTemplates(vals);
        ClientWebTarget target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public ResteasyWebTarget resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws NullPointerException {
        this.client.abortIfClosed();
        if (name == null) {
            throw new NullPointerException(Messages.MESSAGES.nameWasNull());
        }
        if (value == null) {
            throw new NullPointerException(Messages.MESSAGES.valueWasNull());
        }
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.clone().resolveTemplate(name, (Object)val, encodeSlashInPath);
        ClientWebTarget target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public ResteasyWebTarget resolveTemplateFromEncoded(String name, Object value) throws NullPointerException {
        this.client.abortIfClosed();
        if (name == null) {
            throw new NullPointerException(Messages.MESSAGES.nameWasNull());
        }
        if (value == null) {
            throw new NullPointerException(Messages.MESSAGES.valueWasNull());
        }
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.clone().resolveTemplateFromEncoded(name, (Object)val);
        ClientWebTarget target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public ResteasyWebTarget resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws NullPointerException {
        this.client.abortIfClosed();
        if (templateValues == null) {
            throw new NullPointerException(Messages.MESSAGES.templateValuesWasNull());
        }
        if (templateValues.isEmpty()) {
            return this;
        }
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException(Messages.MESSAGES.templateValuesEntryWasNull());
            }
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.clone().resolveTemplatesFromEncoded(vals);
        ClientWebTarget target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public ResteasyWebTarget resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws NullPointerException {
        this.client.abortIfClosed();
        if (templateValues == null) {
            throw new NullPointerException(Messages.MESSAGES.templateValuesWasNull());
        }
        if (templateValues.isEmpty()) {
            return this;
        }
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException(Messages.MESSAGES.templateValuesEntryWasNull());
            }
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.clone().resolveTemplates(vals, encodeSlashInPath);
        ClientWebTarget target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public ResteasyWebTarget matrixParam(String name, Object ... values) throws NullPointerException {
        this.client.abortIfClosed();
        if (name == null) {
            throw new NullPointerException(Messages.MESSAGES.nameWasNull());
        }
        UriBuilder copy = this.uriBuilder.clone();
        if (values.length == 1 && values[0] == null) {
            copy.replaceMatrixParam(name, (Object[])null);
        } else {
            String[] stringValues = this.toStringValues(values);
            copy.matrixParam(name, (Object[])stringValues);
        }
        return this.newInstance(this.client, copy, this.configuration);
    }

    private String[] toStringValues(Object[] values) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = this.configuration.toString(values[i]);
        }
        return stringValues;
    }

    public ResteasyWebTarget queryParam(String name, Object ... values) throws NullPointerException {
        this.client.abortIfClosed();
        if (name == null) {
            throw new NullPointerException(Messages.MESSAGES.nameWasNull());
        }
        UriBuilder copy = this.uriBuilder.clone();
        if (values == null || values.length == 1 && values[0] == null) {
            copy.replaceQueryParam(name, (Object[])null);
        } else {
            String[] stringValues = this.toStringValues(values);
            copy.queryParam(name, (Object[])stringValues);
        }
        return this.newInstance(this.client, copy, this.configuration);
    }

    public ResteasyWebTarget queryParams(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        this.client.abortIfClosed();
        if (parameters == null) {
            throw new NullPointerException(Messages.MESSAGES.parametersWasNull());
        }
        UriBuilder copy = this.uriBuilder.clone();
        for (Map.Entry entry : parameters.entrySet()) {
            String[] stringValues = this.toStringValues(((List)entry.getValue()).toArray());
            copy.queryParam((String)entry.getKey(), (Object[])stringValues);
        }
        return this.newInstance(this.client, copy, this.configuration);
    }

    public ResteasyWebTarget queryParamNoTemplate(String name, Object ... values) throws NullPointerException {
        this.client.abortIfClosed();
        if (name == null) {
            throw new NullPointerException(Messages.MESSAGES.nameWasNull());
        }
        if (values.length == 1 && values[0].getClass().isArray() && !values[0].getClass().getComponentType().isPrimitive()) {
            values = (Object[])values[0];
        }
        String[] stringValues = this.toStringValues(values);
        ResteasyUriBuilder copy = this.uriBuilder instanceof ResteasyUriBuilder ? (ResteasyUriBuilder)this.uriBuilder.clone() : ResteasyUriBuilder.fromTemplate((String)this.uriBuilder.toTemplate());
        copy.clientQueryParam(name, (Object[])stringValues);
        return this.newInstance(this.client, (UriBuilder)copy, this.configuration);
    }

    public ResteasyWebTarget queryParamsNoTemplate(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        this.client.abortIfClosed();
        if (parameters == null) {
            throw new NullPointerException(Messages.MESSAGES.parametersWasNull());
        }
        ResteasyUriBuilder copy = this.uriBuilder instanceof ResteasyUriBuilder ? (ResteasyUriBuilder)this.uriBuilder.clone() : ResteasyUriBuilder.fromTemplate((String)this.uriBuilder.toTemplate());
        for (Map.Entry entry : parameters.entrySet()) {
            String[] stringValues;
            for (String val : stringValues = this.toStringValues(((List)entry.getValue()).toArray())) {
                copy.clientQueryParam((String)entry.getKey(), new Object[]{val});
            }
        }
        return this.newInstance(this.client, (UriBuilder)copy, this.configuration);
    }

    protected ClientWebTarget newInstance(ResteasyClient client, UriBuilder uriBuilder, ClientConfiguration configuration) {
        return new ClientWebTarget(client, uriBuilder, configuration);
    }

    public Invocation.Builder request() {
        this.client.abortIfClosed();
        ClientInvocationBuilder builder = this.createClientInvocationBuilder(this.client, this.uriBuilder.build(new Object[0]), this.configuration);
        builder.setChunked(this.chunked);
        builder.setTarget((WebTarget)this);
        return builder;
    }

    public Invocation.Builder request(String ... acceptedResponseTypes) {
        this.client.abortIfClosed();
        ClientInvocationBuilder builder = this.createClientInvocationBuilder(this.client, this.uriBuilder.build(new Object[0]), this.configuration);
        builder.getHeaders().accept(acceptedResponseTypes);
        builder.setChunked(this.chunked);
        builder.setTarget((WebTarget)this);
        return builder;
    }

    public Invocation.Builder request(MediaType ... acceptedResponseTypes) {
        this.client.abortIfClosed();
        ClientInvocationBuilder builder = this.createClientInvocationBuilder(this.client, this.uriBuilder.build(new Object[0]), this.configuration);
        builder.getHeaders().accept(acceptedResponseTypes);
        builder.setChunked(this.chunked);
        builder.setTarget((WebTarget)this);
        return builder;
    }

    protected ClientInvocationBuilder createClientInvocationBuilder(ResteasyClient client, URI uri, ClientConfiguration configuration) {
        return new ClientInvocationBuilder(client, uri, configuration);
    }

    public ResteasyWebTarget property(String name, Object value) {
        this.client.abortIfClosed();
        if (name == null) {
            throw new NullPointerException(Messages.MESSAGES.nameWasNull());
        }
        this.configuration.property(name, value);
        return this;
    }

    public ResteasyWebTarget register(Class<?> componentClass) {
        this.client.abortIfClosed();
        this.configuration.register((Class)componentClass);
        return this;
    }

    public ResteasyWebTarget register(Class<?> componentClass, int priority) {
        this.client.abortIfClosed();
        this.configuration.register((Class)componentClass, priority);
        return this;
    }

    public ResteasyWebTarget register(Class<?> componentClass, Class<?> ... contracts) {
        this.client.abortIfClosed();
        this.configuration.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    public ResteasyWebTarget register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.client.abortIfClosed();
        this.configuration.register((Class)componentClass, (Map)contracts);
        return this;
    }

    public ResteasyWebTarget register(Object component) {
        this.client.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    public ResteasyWebTarget register(Object component, int priority) {
        this.client.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    public ResteasyWebTarget register(Object component, Class<?> ... contracts) {
        this.client.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public ResteasyWebTarget register(Object component, Map<Class<?>, Integer> contracts) {
        this.client.abortIfClosed();
        this.configuration.register(component, (Map)contracts);
        return this;
    }

    public ResteasyWebTarget setChunked(boolean chunked) {
        this.chunked = chunked;
        return this;
    }
}

