/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.function.Supplier;
import jodd.bean.BeanUtilBean;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.Getter;
import jodd.introspector.PropertyDescriptor;
import jodd.introspector.Setter;

public class BeanProperty {
    final String fullName;
    final ClassIntrospector introspector;
    Object bean;
    private Object lastBean;
    private ClassDescriptor cd;
    String name;
    boolean last;
    boolean first;
    String indexString;
    final boolean isForced;
    String lastName;
    private boolean updateProperty = true;
    private PropertyDescriptor propertyDescriptor;
    private PropertyDescriptor lastPropertyDescriptor;
    String index;

    BeanProperty(BeanUtilBean beanUtilBean, Object bean, String propertyName, boolean isSet) {
        this.introspector = beanUtilBean.introspector;
        this.setName(propertyName);
        this.updateBean(bean);
        this.last = true;
        this.first = true;
        this.fullName = bean.getClass().getSimpleName() + '#' + propertyName;
        this.isForced = isSet && beanUtilBean.isForced;
    }

    public void setName(String name) {
        this.lastName = this.name;
        this.name = name;
        this.updateProperty = true;
    }

    private void setBean(Object bean) {
        this.lastBean = this.bean;
        this.bean = bean;
        this.cd = bean == null ? null : this.introspector.lookup(bean.getClass());
        this.first = false;
        this.updateProperty = true;
    }

    public void updateBean(Object bean) {
        this.setBean(bean);
        if (this.cd != null && this.cd.isSupplier()) {
            Object newBean = ((Supplier)this.bean).get();
            this.setBean(newBean);
        } else {
            this.lastBean = null;
        }
    }

    public void updateBeanClassFromProperty() {
        Class c = this.propertyDescriptor.getType();
        this.setBean(null);
        this.cd = this.introspector.lookup(c);
    }

    public boolean isExistingParentNull() {
        return this.lastPropertyDescriptor != null && this.lastBean == null;
    }

    public boolean currentPropertyExistOnParent(boolean declared) {
        PropertyDescriptor pd = this.propertyDescriptor;
        if (pd == null) {
            ClassDescriptor lastClassDescriptor = this.lastPropertyDescriptor.getClassDescriptor();
            pd = lastClassDescriptor.getPropertyDescriptor(this.lastName, declared);
            ClassDescriptor cs = this.introspector.lookup(pd.getType());
            pd = cs.getPropertyDescriptor(this.name, declared);
        }
        return pd != null;
    }

    private void loadPropertyDescriptor() {
        if (this.updateProperty) {
            this.lastPropertyDescriptor = this.propertyDescriptor;
            this.propertyDescriptor = this.cd == null ? null : this.cd.getPropertyDescriptor(this.name, true);
            this.updateProperty = false;
        }
    }

    public Getter getGetter(boolean declared) {
        this.loadPropertyDescriptor();
        return this.propertyDescriptor != null ? this.propertyDescriptor.getGetter(declared) : null;
    }

    public Setter getSetter(boolean declared) {
        this.loadPropertyDescriptor();
        return this.propertyDescriptor != null ? this.propertyDescriptor.getSetter(declared) : null;
    }

    public boolean isMap() {
        return this.cd != null && this.cd.isMap();
    }

    public String toString() {
        return this.fullName + " (" + (this.bean != null ? this.bean.getClass().getSimpleName() : "?") + '#' + this.name + ')';
    }
}

