/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.List;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;

public final class ANXUtils {
    public static final int BTC_VOLUME_AND_AMOUNT_INT_2_DECIMAL_FACTOR_2 = 100000000;
    public static final int VOLUME_AND_AMOUNT_MAX_SCALE = 8;

    private ANXUtils() {
    }

    public static boolean findLimitOrder(List<LimitOrder> orders, LimitOrder order, String id) {
        boolean found = false;
        for (LimitOrder openOrder : orders) {
            if (!openOrder.getId().equalsIgnoreCase(id) || !order.getCurrencyPair().equals((Object)openOrder.getCurrencyPair()) || order.getTradableAmount().compareTo(openOrder.getTradableAmount()) != 0 || order.getLimitPrice().compareTo(openOrder.getLimitPrice()) != 0) continue;
            found = true;
        }
        return found;
    }

    public static int getMaxPriceScale(CurrencyPair currencyPair) {
        if (currencyPair.base.equals((Object)Currency.BTC) || currencyPair.base.equals((Object)Currency.LTC)) {
            return 5;
        }
        return 8;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Problem encoding, probably bug in code.", e);
        }
    }

    public static BigDecimal percentToFactor(BigDecimal percent) {
        int PERCENT_DECIMAL_SHIFT = 2;
        return percent.movePointLeft(PERCENT_DECIMAL_SHIFT);
    }
}

