/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2;

import java.io.IOException;
import java.math.BigDecimal;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.anx.v2.dto.ANXException;
import org.knowm.xchange.anx.v2.dto.account.ANXAccountInfoWrapper;
import org.knowm.xchange.anx.v2.dto.account.ANXBitcoinDepositAddressWrapper;
import org.knowm.xchange.anx.v2.dto.account.ANXWalletHistoryWrapper;
import org.knowm.xchange.anx.v2.dto.account.ANXWithdrawalResponseWrapper;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXDepthWrapper;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXDepthsWrapper;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXTickerWrapper;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXTickersWrapper;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXTradesWrapper;
import org.knowm.xchange.anx.v2.dto.trade.ANXGenericResponse;
import org.knowm.xchange.anx.v2.dto.trade.ANXLagWrapper;
import org.knowm.xchange.anx.v2.dto.trade.ANXOpenOrderWrapper;
import org.knowm.xchange.anx.v2.dto.trade.ANXOrderResultWrapper;
import org.knowm.xchange.anx.v2.dto.trade.ANXTradeResultWrapper;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="api/2")
@Produces(value={"application/json"})
public interface ANXV2 {
    @GET
    @Path(value="money/order/lag")
    public ANXLagWrapper getLag() throws ANXException, IOException;

    @GET
    @Path(value="{ident}{currency}/money/ticker")
    public ANXTickerWrapper getTicker(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2) throws ANXException, IOException;

    @GET
    @Path(value="{ident}{currency}/money/ticker")
    public ANXTickersWrapper getTickers(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2, @QueryParam(value="extraCcyPairs") String var3) throws ANXException, IOException;

    @GET
    @Path(value="{ident}{currency}/money/depth/fetch")
    public ANXDepthWrapper getPartialDepth(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2) throws ANXException, IOException;

    @GET
    @Path(value="{ident}{currency}/money/depth/full")
    public ANXDepthWrapper getFullDepth(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2) throws ANXException, IOException;

    @GET
    @Path(value="{ident}{currency}/money/depth/full")
    public ANXDepthsWrapper getFullDepths(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2, @QueryParam(value="extraCcyPairs") String var3) throws ANXException, IOException;

    @GET
    @Path(value="{ident}{currency}/money/trade/fetch")
    public ANXTradesWrapper getTrades(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2, @QueryParam(value="since") long var3) throws ANXException, IOException;

    @POST
    @Path(value="money/info")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXAccountInfoWrapper getAccountInfo(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws ANXException, IOException;

    @POST
    @Path(value="money/{currency}/address")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXBitcoinDepositAddressWrapper requestDepositAddress(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @PathParam(value="currency") String var4) throws ANXException, IOException;

    @POST
    @Path(value="money/{currency}/send_simple")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXWithdrawalResponseWrapper withdrawBtc(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @PathParam(value="currency") String var4, @FormParam(value="address") String var5, @FormParam(value="amount_int") int var6, @FormParam(value="fee_int") int var7, @FormParam(value="no_instant") boolean var8, @FormParam(value="green") boolean var9) throws ANXException, IOException;

    @POST
    @Path(value="{baseCurrency}{counterCurrency}/money/orders")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXOpenOrderWrapper getOpenOrders(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @PathParam(value="baseCurrency") String var4, @PathParam(value="counterCurrency") String var5) throws ANXException, IOException;

    @POST
    @Path(value="money/orders")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXOpenOrderWrapper getOpenOrders(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws ANXException, IOException;

    @POST
    @Path(value="money/trade/list")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXTradeResultWrapper getExecutedTrades(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="from") Long var4, @FormParam(value="to") Long var5) throws ANXException, IOException;

    @POST
    @Path(value="{baseCurrency}{counterCurrency}/money/order/result")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXOrderResultWrapper getOrderResult(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @PathParam(value="baseCurrency") String var4, @PathParam(value="counterCurrency") String var5, @FormParam(value="order") String var6, @FormParam(value="type") String var7) throws ANXException, IOException;

    @POST
    @Path(value="{baseCurrency}{counterCurrency}/money/order/add")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXGenericResponse placeOrder(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @PathParam(value="baseCurrency") String var4, @PathParam(value="counterCurrency") String var5, @FormParam(value="type") String var6, @FormParam(value="amount") BigDecimal var7, @FormParam(value="price") BigDecimal var8) throws ANXException, IOException;

    @POST
    @Path(value="{baseCurrency}{counterCurrency}/money/order/cancel")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXGenericResponse cancelOrder(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="oid") String var4, @PathParam(value="baseCurrency") String var5, @PathParam(value="counterCurrency") String var6) throws ANXException, IOException;

    @POST
    @Path(value="money/wallet/history")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ANXWalletHistoryWrapper getWalletHistory(@HeaderParam(value="Rest-Key") String var1, @HeaderParam(value="Rest-Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currency") String var4, @FormParam(value="page") Integer var5, @FormParam(value="from") Long var6, @FormParam(value="to") Long var7) throws ANXException, IOException;
}

