/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.anx.v2.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.anx.v2.ANXAdapters;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXDepthWrapper;
import org.knowm.xchange.anx.v2.dto.marketdata.ANXTrade;
import org.knowm.xchange.anx.v2.service.ANXMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class ANXMarketDataService
extends ANXMarketDataServiceRaw
implements MarketDataService {
    public ANXMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return ANXAdapters.adaptTicker(this.getANXTicker(currencyPair));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        ANXDepthWrapper anxDepthWrapper = null;
        if (args.length > 0) {
            if (!(args[0] instanceof String)) throw new ExchangeException("Orderbook type argument must be a String!");
            anxDepthWrapper = "full" == args[0] ? this.getANXFullOrderBook(currencyPair) : this.getANXPartialOrderBook(currencyPair);
        } else {
            anxDepthWrapper = this.getANXFullOrderBook(currencyPair);
        }
        List<LimitOrder> asks = ANXAdapters.adaptOrders(anxDepthWrapper.getAnxDepth().getAsks(), currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), "ask", "");
        List<LimitOrder> bids = ANXAdapters.adaptOrders(anxDepthWrapper.getAnxDepth().getBids(), currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), "bid", "");
        Date date = new Date(anxDepthWrapper.getAnxDepth().getMicroTime() / 1000L);
        return new OrderBook(date, asks, bids);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        long sinceTimeStamp = 0L;
        if (args != null && args.length == 1) {
            Serializable arg;
            if (args[0] instanceof Number) {
                arg = (Number)args[0];
                sinceTimeStamp = ((Number)arg).longValue();
            } else if (args[0] instanceof Date) {
                arg = (Date)args[0];
                sinceTimeStamp = ((Date)arg).getTime();
            } else {
                throw new IllegalArgumentException("Extra argument #1, the last trade time, must be a Date or Long (millisecond timestamp) (was " + args[0].getClass() + ")");
            }
        }
        List<ANXTrade> anxTrades = super.getANXTrades(currencyPair, sinceTimeStamp);
        return ANXAdapters.adaptTrades(anxTrades);
    }
}

