/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.v1;

import java.io.IOException;
import java.util.ArrayList;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bittrex.v1.BittrexAdapters;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.v1.service.BittrexAccountService;
import org.knowm.xchange.bittrex.v1.service.BittrexMarketDataService;
import org.knowm.xchange.bittrex.v1.service.BittrexMarketDataServiceRaw;
import org.knowm.xchange.bittrex.v1.service.BittrexTradeService;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.nonce.AtomicLongIncrementalTime2013NonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BittrexExchange
extends BaseExchange
implements Exchange {
    private SynchronizedValueFactory<Long> nonceFactory = new AtomicLongIncrementalTime2013NonceFactory();

    protected void initServices() {
        this.marketDataService = new BittrexMarketDataService(this);
        this.accountService = new BittrexAccountService(this);
        this.tradeService = new BittrexTradeService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://bittrex.com/api/");
        exchangeSpecification.setHost("bittrex.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Bittrex");
        exchangeSpecification.setExchangeDescription("Bittrex is a bitcoin and altcoin exchange.");
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public void remoteInit() throws IOException, ExchangeException {
        BittrexMarketDataServiceRaw dataService = (BittrexMarketDataServiceRaw)this.marketDataService;
        ArrayList<BittrexSymbol> bittrexSymbols = dataService.getBittrexSymbols();
        this.exchangeMetaData = BittrexAdapters.adaptMetaData(bittrexSymbols, this.exchangeMetaData);
    }
}

