/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.MessageFormat;
import java.util.Map;
import org.knowm.xchange.dsx.dto.account.DSXCurrencyAmount;

public class DSXAccountInfo {
    private final int transactionCount;
    private final int openOrders;
    private final long serverTime;
    private final Rights rights;
    private final Map<String, DSXCurrencyAmount> funds;

    public DSXAccountInfo(@JsonProperty(value="transactionCount") int transactionCount, @JsonProperty(value="openOrders") int openOrders, @JsonProperty(value="serverTime") long serverTime, @JsonProperty(value="rights") Rights rights, @JsonProperty(value="funds") Map<String, DSXCurrencyAmount> funds) {
        this.transactionCount = transactionCount;
        this.openOrders = openOrders;
        this.serverTime = serverTime;
        this.rights = rights;
        this.funds = funds;
    }

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public int getOpenOrders() {
        return this.openOrders;
    }

    public long getServerTime() {
        return this.serverTime;
    }

    public Rights getRights() {
        return this.rights;
    }

    public Map<String, DSXCurrencyAmount> getFunds() {
        return this.funds;
    }

    public String toString() {
        return MessageFormat.format("DSXAccountInfo[transactionCount={0}, openOrders={1}, serverTime={2}, rights={3}, funds=''{4}''', total={5}]", this.transactionCount, this.openOrders, this.serverTime, this.rights, this.funds);
    }

    public static class Rights {
        private final boolean info;
        private final boolean trade;

        private Rights(@JsonProperty(value="info") boolean info, @JsonProperty(value="trade") boolean trade) {
            this.info = info;
            this.trade = trade;
        }

        public boolean isInfo() {
            return this.info;
        }

        public boolean isTrade() {
            return this.trade;
        }

        public String toString() {
            return MessageFormat.format("Rights[info={0}, trade={1}, withdraw={2}]", this.info, this.trade);
        }
    }
}

