/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx.service;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dsx.DSXAuthenticatedV2;
import org.knowm.xchange.dsx.dto.trade.DSXActiveOrdersReturn;
import org.knowm.xchange.dsx.dto.trade.DSXCancelAllOrdersResult;
import org.knowm.xchange.dsx.dto.trade.DSXCancelAllOrdersReturn;
import org.knowm.xchange.dsx.dto.trade.DSXCancelOrderResult;
import org.knowm.xchange.dsx.dto.trade.DSXCancelOrderReturn;
import org.knowm.xchange.dsx.dto.trade.DSXFeesResult;
import org.knowm.xchange.dsx.dto.trade.DSXFeesReturn;
import org.knowm.xchange.dsx.dto.trade.DSXOrder;
import org.knowm.xchange.dsx.dto.trade.DSXOrderHistoryResult;
import org.knowm.xchange.dsx.dto.trade.DSXOrderHistoryReturn;
import org.knowm.xchange.dsx.dto.trade.DSXOrderStatusResult;
import org.knowm.xchange.dsx.dto.trade.DSXOrderStatusReturn;
import org.knowm.xchange.dsx.dto.trade.DSXTradeHistoryResult;
import org.knowm.xchange.dsx.dto.trade.DSXTradeHistoryReturn;
import org.knowm.xchange.dsx.dto.trade.DSXTradeResult;
import org.knowm.xchange.dsx.dto.trade.DSXTradeReturn;
import org.knowm.xchange.dsx.dto.trade.DSXTransHistoryResult;
import org.knowm.xchange.dsx.dto.trade.DSXTransHistoryReturn;
import org.knowm.xchange.dsx.service.DSXBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class DSXTradeServiceRaw
extends DSXBaseService {
    private static final String MSG_NO_TRADES = "no trades";
    private static final String MSG_BAD_STATUS = "bad status";
    private static final String MSG_NO_ORDERS = "No open orders!";

    protected DSXTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<Long, DSXOrder> getDSXActiveOrders(String pair) throws IOException {
        DSXActiveOrdersReturn orders = this.dsx.getActiveOrders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), pair);
        if (MSG_NO_ORDERS.equals(orders.getError())) {
            return new HashMap<Long, DSXOrder>();
        }
        this.checkResult(orders);
        return (Map)orders.getReturnValue();
    }

    public DSXTradeResult tradeDSX(DSXOrder order) throws IOException {
        String pair = order.getPair().toLowerCase();
        DSXTradeReturn ret = this.dsx.Trade(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), order.getType(), order.getRate(), order.getAmount(), pair, order.getOrderType());
        this.checkResult(ret);
        return (DSXTradeResult)ret.getReturnValue();
    }

    public DSXCancelOrderResult cancelDSXOrder(long orderId) throws IOException {
        DSXCancelOrderReturn ret = this.dsx.CancelOrder(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        if (MSG_BAD_STATUS.equals(ret.getError())) {
            return null;
        }
        this.checkResult(ret);
        return (DSXCancelOrderResult)ret.getReturnValue();
    }

    public DSXCancelAllOrdersResult cancelAllDSXOrders() throws IOException {
        DSXCancelAllOrdersReturn ret = this.dsx.cancelAllOrders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (MSG_BAD_STATUS.equals(ret.getError())) {
            return null;
        }
        this.checkResult(ret);
        return (DSXCancelAllOrdersResult)ret.getReturnValue();
    }

    public DSXOrderStatusResult getOrderStatus(Long orderId) throws IOException {
        DSXOrderStatusReturn ret = this.dsx.getOrderStatus(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        if (MSG_BAD_STATUS.equals(ret.getError())) {
            return null;
        }
        this.checkResult(ret);
        return (DSXOrderStatusResult)ret.getReturnValue();
    }

    public DSXFeesResult getFees() throws IOException {
        DSXFeesReturn res = this.dsx.getFees(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (MSG_BAD_STATUS.equals(res.getError())) {
            return null;
        }
        this.checkResult(res);
        return (DSXFeesResult)res.getReturnValue();
    }

    public Map<Long, DSXTradeHistoryResult> getDSXTradeHistory(Long count, Long fromId, Long endId, DSXAuthenticatedV2.SortOrder order, Long since, Long end, String pair) throws IOException {
        DSXTradeHistoryReturn dsxTradeHistory = this.dsx.TradeHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), count, fromId, endId, order, since, end, pair);
        String error = dsxTradeHistory.getError();
        if (MSG_NO_TRADES.equals(error)) {
            return Collections.emptyMap();
        }
        this.checkResult(dsxTradeHistory);
        return (Map)dsxTradeHistory.getReturnValue();
    }

    public Map<Long, DSXTransHistoryResult> getDSXTransHistory(Long count, Long fromId, Long endId, DSXAuthenticatedV2.SortOrder order, Long since, Long end, DSXTransHistoryResult.Type type, DSXTransHistoryResult.Status status, String currency) throws IOException {
        DSXTransHistoryReturn dsxTransHistory = this.dsx.TransHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), count, fromId, endId, order, since, end, type, status, currency);
        String error = dsxTransHistory.getError();
        if (MSG_NO_TRADES.equals(error)) {
            return Collections.emptyMap();
        }
        this.checkResult(dsxTransHistory);
        return (Map)dsxTransHistory.getReturnValue();
    }

    public Map<Long, DSXOrderHistoryResult> getDSXOrderHistory(Long count, Long fromId, Long endId, DSXAuthenticatedV2.SortOrder order, Long since, Long end, String pair) throws IOException {
        DSXOrderHistoryReturn dsxOrderHistory = this.dsx.OrderHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), count, fromId, endId, order, since, end, pair);
        String error = dsxOrderHistory.getError();
        if (MSG_NO_TRADES.equals(error)) {
            return Collections.emptyMap();
        }
        this.checkResult(dsxOrderHistory);
        return (Map)dsxOrderHistory.getReturnValue();
    }
}

