/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.gatecoin.GatecoinAuthenticated;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinBalanceResult;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinDepositAddressResult;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinWithdrawResult;
import org.knowm.xchange.gatecoin.service.GatecoinBaseService;
import org.knowm.xchange.gatecoin.service.GatecoinDigest;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class GatecoinAccountServiceRaw
extends GatecoinBaseService {
    private final GatecoinDigest signatureCreator;
    private final GatecoinAuthenticated gatecoinAuthenticated;

    protected GatecoinAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.gatecoinAuthenticated = (GatecoinAuthenticated)RestProxyFactory.createProxy(GatecoinAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri());
        this.signatureCreator = GatecoinDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public GatecoinBalanceResult getGatecoinBalance() throws IOException {
        ExchangeSpecification spec = this.exchange.getExchangeSpecification();
        GatecoinBalanceResult gatecoinBalanceResult = this.gatecoinAuthenticated.getUserBalance(spec.getApiKey(), spec.getUserName(), (ParamsDigest)this.signatureCreator, GatecoinAccountServiceRaw.getNow());
        if (gatecoinBalanceResult.getResponseStatus().getMessage().equalsIgnoreCase("ok")) {
            return gatecoinBalanceResult;
        }
        throw new ExchangeException("Error getting balance. " + gatecoinBalanceResult.getResponseStatus().getMessage());
    }

    public GatecoinWithdrawResult withdrawGatecoinFunds(String currency, BigDecimal amount, String address) throws IOException {
        GatecoinWithdrawResult gatecoinWithdrawalResult = this.gatecoinAuthenticated.withdrawBitcoin(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinAccountServiceRaw.getNow(), currency, address, amount);
        if (gatecoinWithdrawalResult.getResponseStatus().getMessage().equalsIgnoreCase("ok")) {
            return gatecoinWithdrawalResult;
        }
        throw new ExchangeException("Error withdrawaing funds " + gatecoinWithdrawalResult.getResponseStatus().getMessage());
    }

    public GatecoinDepositAddressResult getGatecoinDepositAddress() throws IOException {
        GatecoinDepositAddressResult gatecoinDepositAddressResult = this.gatecoinAuthenticated.getDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinAccountServiceRaw.getNow());
        if (gatecoinDepositAddressResult.getResponseStatus().getMessage().equalsIgnoreCase("ok")) {
            return gatecoinDepositAddressResult;
        }
        throw new ExchangeException("Requesting Deposit address failed: " + gatecoinDepositAddressResult.getResponseStatus().getMessage());
    }
}

