/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin.service;

import javax.crypto.Mac;
import javax.ws.rs.HeaderParam;
import net.iharder.Base64;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class GatecoinDigest
extends BaseParamsDigest {
    private GatecoinDigest(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA256");
    }

    public static GatecoinDigest createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new GatecoinDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        return this.digest(restInvocation.getHttpMethod(), restInvocation.getInvocationUrl(), restInvocation.getReqContentType(), restInvocation.getParamValue(HeaderParam.class, "API_REQUEST_DATE").toString());
    }

    String digest(String httpMethod, String invocationUrl, String reqContentType, String now) {
        Mac mac256 = this.getMac();
        mac256.update(httpMethod.toLowerCase().getBytes());
        mac256.update(invocationUrl.toLowerCase().getBytes());
        if (!"GET".equals(httpMethod)) {
            mac256.update(reqContentType.toLowerCase().getBytes());
        }
        mac256.update(now.toLowerCase().getBytes());
        return Base64.encodeBytes((byte[])mac256.doFinal());
    }
}

