/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.gatecoin.GatecoinAdapters;
import org.knowm.xchange.gatecoin.dto.trade.GatecoinOrder;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinCancelOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinPlaceOrderResult;
import org.knowm.xchange.gatecoin.service.GatecoinTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamTransactionId;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.DateUtils;

public class GatecoinTradeService
extends GatecoinTradeServiceRaw
implements TradeService {
    public GatecoinTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        GatecoinOrderResult openOrdersResult = this.getGatecoinOpenOrders();
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (GatecoinOrder gatecoinOrder : openOrdersResult.getOrders()) {
            Order.OrderType orderType = gatecoinOrder.getSide() == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
            String id = gatecoinOrder.getClOrderId();
            BigDecimal price = gatecoinOrder.getPrice();
            CurrencyPair ccyPair = new CurrencyPair(gatecoinOrder.getCode().substring(0, 3), gatecoinOrder.getCode().substring(3, 6));
            limitOrders.add(new LimitOrder(orderType, gatecoinOrder.getRemainingQuantity(), ccyPair, id, DateUtils.fromMillisUtc((long)(Long.valueOf(gatecoinOrder.getDate()) * 1000L)), price));
        }
        return new OpenOrders(limitOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        String ccyPair = marketOrder.getCurrencyPair().toString().replace("/", "");
        GatecoinPlaceOrderResult gatecoinPlaceOrderResult = marketOrder.getType() == Order.OrderType.BID ? this.placeGatecoinOrder(marketOrder.getTradableAmount(), BigDecimal.ZERO, "BID", ccyPair) : this.placeGatecoinOrder(marketOrder.getTradableAmount(), BigDecimal.ZERO, "ASK", ccyPair);
        return gatecoinPlaceOrderResult.getOrderId();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        String ccyPair = limitOrder.getCurrencyPair().toString().replace("/", "");
        GatecoinPlaceOrderResult gatecoinOrderResult = limitOrder.getType() == Order.OrderType.BID ? this.placeGatecoinOrder(limitOrder.getTradableAmount(), limitOrder.getLimitPrice(), "BID", ccyPair) : this.placeGatecoinOrder(limitOrder.getTradableAmount(), limitOrder.getLimitPrice(), "ASK", ccyPair);
        return gatecoinOrderResult.getOrderId();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        GatecoinCancelOrderResult response = null;
        response = orderId != null && !orderId.isEmpty() ? this.cancelGatecoinOrder(orderId) : this.cancelAllGatecoinOrders();
        if (response != null && response.getResponseStatus() != null && response.getResponseStatus().getMessage() != null) {
            return response.getResponseStatus().getMessage().equalsIgnoreCase("OK");
        }
        return false;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            this.cancelOrder(((CancelOrderByIdParams)orderParams).orderId);
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        String txIdStr;
        Integer limit = null;
        Long txId = null;
        if (params instanceof TradeHistoryParamPaging) {
            limit = ((TradeHistoryParamPaging)params).getPageLength();
        }
        if (params instanceof TradeHistoryParamTransactionId && (txIdStr = ((TradeHistoryParamTransactionId)params).getTransactionId()) != null) {
            txId = Long.valueOf(txIdStr);
        }
        return GatecoinAdapters.adaptTradeHistory(this.getGatecoinUserTrades(limit, txId));
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new GatecoinTradeHistoryParams(1000);
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public static class GatecoinTradeHistoryParams
    implements TradeHistoryParamPaging,
    TradeHistoryParamTransactionId {
        Integer pageLength;
        String transactionId;

        public GatecoinTradeHistoryParams(Integer pageLength) {
            this.pageLength = pageLength;
        }

        public GatecoinTradeHistoryParams(Integer pageLength, String transactionId) {
            this.pageLength = pageLength;
            this.transactionId = transactionId;
        }

        public void setPageLength(Integer pageLength) {
            this.pageLength = pageLength;
        }

        public Integer getPageLength() {
            return this.pageLength;
        }

        public void setPageNumber(Integer pageNumber) {
        }

        public Integer getPageNumber() {
            return null;
        }

        public void setTransactionId(String txId) {
            this.transactionId = txId;
        }

        public String getTransactionId() {
            return this.transactionId;
        }
    }
}

