/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.livecoin;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.livecoin.LivecoinAdapters;
import org.knowm.xchange.livecoin.dto.marketdata.LivecoinRestriction;
import org.knowm.xchange.livecoin.service.LivecoinMarketDataService;
import org.knowm.xchange.livecoin.service.LivecoinMarketDataServiceRaw;
import org.knowm.xchange.utils.nonce.CurrentTimeNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class LivecoinExchange
extends BaseExchange
implements Exchange {
    private SynchronizedValueFactory<Long> nonceFactory = new CurrentTimeNonceFactory();

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://api.livecoin.net");
        exchangeSpecification.setHost("api.livecoin.net");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Livecoin");
        exchangeSpecification.setExchangeDescription("Livecoin - A convenient way to buy and sell Bitcoin");
        return exchangeSpecification;
    }

    protected void initServices() {
        this.marketDataService = new LivecoinMarketDataService(this);
        this.accountService = null;
        this.tradeService = null;
    }

    public void remoteInit() throws IOException {
        List<LivecoinRestriction> products = ((LivecoinMarketDataServiceRaw)this.marketDataService).getConbaseExProducts();
        this.exchangeMetaData = LivecoinAdapters.adaptToExchangeMetaData(this.exchangeMetaData, products);
    }
}

