/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.livecoin.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import org.knowm.xchange.livecoin.service.LivecoinAsksBidsData;

public class LivecoinOrderBook {
    private final Long timestamp;
    private final LivecoinAsksBidsData[] asks;
    private final LivecoinAsksBidsData[] bids;

    public LivecoinOrderBook(@JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="asks") Object[][] asks, @JsonProperty(value="bids") Object[][] bids) {
        int i;
        this.timestamp = timestamp;
        if (bids != null && bids.length > 0) {
            this.bids = new LivecoinAsksBidsData[bids.length];
            for (i = 0; i < bids.length; ++i) {
                this.bids[i] = LivecoinOrderBook.convertToOrderBookEntry(bids[i]);
            }
        } else {
            this.bids = null;
        }
        if (asks != null && asks.length > 0) {
            this.asks = new LivecoinAsksBidsData[asks.length];
            for (i = 0; i < asks.length; ++i) {
                this.asks[i] = LivecoinOrderBook.convertToOrderBookEntry(asks[i]);
            }
        } else {
            this.asks = null;
        }
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public LivecoinAsksBidsData[] getAsks() {
        return this.asks;
    }

    public LivecoinAsksBidsData[] getBids() {
        return this.bids;
    }

    private static LivecoinAsksBidsData convertToOrderBookEntry(Object[] dataObject) {
        if (dataObject != null && dataObject.length == 2) {
            BigDecimal volume = new BigDecimal((String)dataObject[0]);
            BigDecimal price = new BigDecimal((String)dataObject[1]);
            return new LivecoinAsksBidsData(price, volume);
        }
        return null;
    }

    public String toString() {
        return "LivecoinOrderBook [timestamp=" + this.timestamp + ", asks=" + Arrays.toString(this.asks) + ", bids=" + Arrays.toString(this.bids) + "]";
    }
}

