/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.internal.async.client.AsyncMongoDatabase;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.internal.AggregatePublisherImpl;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ListCollectionsPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoCollectionImpl;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

public final class MongoDatabaseImpl
implements MongoDatabase {
    private final AsyncMongoDatabase wrapped;

    MongoDatabaseImpl(AsyncMongoDatabase wrapped) {
        this.wrapped = (AsyncMongoDatabase)Assertions.notNull((String)"wrapped", (Object)wrapped);
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.wrapped.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.wrapped.withReadConcern(readConcern));
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> clazz) {
        return new MongoCollectionImpl(this.wrapped.getCollection(collectionName, clazz));
    }

    @Override
    public Publisher<Document> runCommand(Bson command) {
        return this.runCommand(command, Document.class);
    }

    @Override
    public Publisher<Document> runCommand(Bson command, ReadPreference readPreference) {
        return this.runCommand(command, readPreference, Document.class);
    }

    @Override
    public <TResult> Publisher<TResult> runCommand(Bson command, Class<TResult> clazz) {
        return Publishers.publish(callback -> this.wrapped.runCommand(command, clazz, callback));
    }

    @Override
    public <TResult> Publisher<TResult> runCommand(Bson command, ReadPreference readPreference, Class<TResult> clazz) {
        return Publishers.publish(callback -> this.wrapped.runCommand(command, readPreference, clazz, callback));
    }

    @Override
    public Publisher<Document> runCommand(ClientSession clientSession, Bson command) {
        return this.runCommand(clientSession, command, Document.class);
    }

    @Override
    public Publisher<Document> runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference) {
        return this.runCommand(clientSession, command, readPreference, Document.class);
    }

    @Override
    public <TResult> Publisher<TResult> runCommand(ClientSession clientSession, Bson command, Class<TResult> clazz) {
        return Publishers.publish(callback -> this.wrapped.runCommand(clientSession.getWrapped(), command, clazz, callback));
    }

    @Override
    public <TResult> Publisher<TResult> runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> clazz) {
        return Publishers.publish(callback -> this.wrapped.runCommand(clientSession.getWrapped(), command, readPreference, clazz, callback));
    }

    @Override
    public Publisher<Void> drop() {
        return Publishers.publish(arg_0 -> ((AsyncMongoDatabase)this.wrapped).drop(arg_0));
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return Publishers.publish(callback -> this.wrapped.drop(clientSession.getWrapped(), callback));
    }

    @Override
    public Publisher<String> listCollectionNames() {
        return Publishers.publish(this.wrapped.listCollectionNames());
    }

    @Override
    public Publisher<String> listCollectionNames(ClientSession clientSession) {
        return Publishers.publish(this.wrapped.listCollectionNames(clientSession.getWrapped()));
    }

    @Override
    public ListCollectionsPublisher<Document> listCollections() {
        return this.listCollections((Class)Document.class);
    }

    public <C> ListCollectionsPublisher<C> listCollections(Class<C> clazz) {
        return new ListCollectionsPublisherImpl(this.wrapped.listCollections(clazz));
    }

    @Override
    public ListCollectionsPublisher<Document> listCollections(ClientSession clientSession) {
        return this.listCollections(clientSession, (Class)Document.class);
    }

    public <C> ListCollectionsPublisher<C> listCollections(ClientSession clientSession, Class<C> clazz) {
        return new ListCollectionsPublisherImpl(this.wrapped.listCollections(clientSession.getWrapped(), clazz));
    }

    @Override
    public Publisher<Void> createCollection(String collectionName) {
        return this.createCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public Publisher<Void> createCollection(String collectionName, CreateCollectionOptions options) {
        return Publishers.publish(callback -> this.wrapped.createCollection(collectionName, options, callback));
    }

    @Override
    public Publisher<Void> createCollection(ClientSession clientSession, String collectionName) {
        return this.createCollection(clientSession, collectionName, new CreateCollectionOptions());
    }

    @Override
    public Publisher<Void> createCollection(ClientSession clientSession, String collectionName, CreateCollectionOptions options) {
        return Publishers.publish(callback -> this.wrapped.createCollection(clientSession.getWrapped(), collectionName, options, callback));
    }

    @Override
    public Publisher<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline) {
        return this.createView(viewName, viewOn, pipeline, new CreateViewOptions());
    }

    @Override
    public Publisher<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        return Publishers.publish(callback -> this.wrapped.createView(viewName, viewOn, pipeline, createViewOptions, callback));
    }

    @Override
    public Publisher<Void> createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline) {
        return this.createView(clientSession, viewName, viewOn, pipeline, new CreateViewOptions());
    }

    @Override
    public Publisher<Void> createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        return Publishers.publish(callback -> this.wrapped.createView(clientSession.getWrapped(), viewName, viewOn, pipeline, createViewOptions, callback));
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl(this.wrapped.watch(pipeline, resultClass));
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return new ChangeStreamPublisherImpl(this.wrapped.watch(clientSession.getWrapped(), pipeline, resultClass));
    }

    @Override
    public AggregatePublisher<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregatePublisherImpl(this.wrapped.aggregate(pipeline, resultClass));
    }

    @Override
    public AggregatePublisher<Document> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return new AggregatePublisherImpl(this.wrapped.aggregate(clientSession.getWrapped(), pipeline, resultClass));
    }

    public AsyncMongoDatabase getWrapped() {
        return this.wrapped;
    }
}

