/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultParameterizedMapMetaDataModel;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.util.TypeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataModelFactory {
    private static MetaDataModelFactory instance = new MetaDataModelFactory();
    private DataTypeFactory factory = DataTypeFactory.getInstance();

    private MetaDataModelFactory() {
    }

    public static MetaDataModelFactory getInstance() {
        return instance;
    }

    public List<MetaDataField> getFieldsForClass(Class<?> clazz) {
        return this.getFieldsForClass(clazz, new ParsingContext());
    }

    public List<MetaDataField> getFieldsForClass(Class<?> clazz, ParsingContext context) {
        ArrayList<MetaDataField> result = new ArrayList<MetaDataField>();
        this.parseFields(clazz, context, result);
        return result;
    }

    protected MetaDataModel parseType(Type type, ParsingContext context) {
        if (type instanceof Class) {
            return this.parseClass((Class)type, context);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Class<?> raw = TypeResolver.erase(type);
            if (Collection.class.isAssignableFrom(raw)) {
                return new DefaultListMetaDataModel(this.parseType(paramType.getActualTypeArguments()[0], context));
            }
            if (Map.class.isAssignableFrom(raw)) {
                return new DefaultParameterizedMapMetaDataModel(this.parseType(paramType.getActualTypeArguments()[0], context), this.parseType(paramType.getActualTypeArguments()[1], context));
            }
            context.addResolvedVariables(TypeResolver.resolveVariables(type));
            return this.parseClass(raw, context);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return new DefaultListMetaDataModel(this.parseType(arrayType.getGenericComponentType(), context));
        }
        if (type instanceof TypeVariable) {
            Type actual = context.getResolvedVariables().get(type);
            if (actual == null || type.equals(actual)) {
                TypeVariable typeVariable = (TypeVariable)type;
                Type[] bounds = typeVariable.getBounds();
                if (bounds.length > 0) {
                    return this.parseType(bounds[0], context);
                }
                return context.OBJECT;
            }
            return this.parseType(actual, context);
        }
        if (type instanceof WildcardType) {
            WildcardType wildType = (WildcardType)type;
            Type[] lowerBounds = wildType.getLowerBounds();
            Type[] upperBounds = wildType.getUpperBounds();
            if (lowerBounds.length > 0) {
                return this.parseType(lowerBounds[0], context);
            }
            if (upperBounds.length > 0) {
                return this.parseType(upperBounds[0], context);
            }
            return context.OBJECT;
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    protected MetaDataModel parseClass(Class<?> klass, ParsingContext context) {
        if (Collection.class.isAssignableFrom(klass)) {
            Type declaring = TypeResolver.getGenericSuperclass(klass, Collection.class);
            if (declaring == null) {
                declaring = TypeResolver.getSuperclass(klass, Collection.class);
            }
            if (declaring != null) {
                return this.parseType(declaring, context);
            }
            return new DefaultListMetaDataModel(context.OBJECT);
        }
        if (klass.isArray()) {
            return new DefaultListMetaDataModel(this.parseClass(klass.getComponentType(), context), true);
        }
        if (Map.class.isAssignableFrom(klass)) {
            Type declaring = TypeResolver.getGenericSuperclass(klass, Map.class);
            if (declaring == null) {
                declaring = TypeResolver.getSuperclass(klass, Map.class);
            }
            if (declaring != null) {
                return this.parseType(declaring, context);
            }
            return new DefaultParameterizedMapMetaDataModel(context.OBJECT, context.OBJECT);
        }
        DataType dataType = this.factory.getDataType(klass);
        if (dataType == DataType.POJO) {
            return this.parseBeanType(klass, context);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    public static List<Field> getInheritedPrivateFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers())) continue;
                result.add(field);
            }
        }
        return result;
    }

    public Set<String> getParentNames(Class<?> clazz) {
        HashSet<String> parents = new HashSet<String>();
        for (Class<?> c : clazz.getInterfaces()) {
            if (c == null) continue;
            parents.add(c.getName());
            parents.addAll(this.getParentNames(c));
        }
        Class<?> parent = clazz.getSuperclass();
        if (parent != null) {
            parents.add(parent.getName());
            parents.addAll(this.getParentNames(parent));
        }
        return parents;
    }

    protected MetaDataModel parseBeanType(Class<?> klass, ParsingContext context) {
        if (context.getTypedObject(klass.getName()) != null) {
            return context.getTypedObject(klass.getName());
        }
        ArrayList<MetaDataField> fields = new ArrayList<MetaDataField>();
        DefaultPojoMetaDataModel typedObject = new DefaultPojoMetaDataModel(klass, fields);
        context.addTypedObject(klass.getName(), typedObject);
        context.addResolvedVariables(TypeResolver.resolveVariables(klass));
        this.parseFields(klass, context, fields);
        return typedObject;
    }

    private void parseFields(Class<?> klass, ParsingContext context, ArrayList<MetaDataField> fields) {
        if (!klass.equals(Object.class)) {
            try {
                List<Object> propertyDescriptors = null;
                if (klass.isInterface()) {
                    propertyDescriptors = new ArrayList<PropertyDescriptor>();
                    propertyDescriptors.addAll(Arrays.asList(Introspector.getBeanInfo(klass).getPropertyDescriptors()));
                    for (Class<?> interfaceType : TypeResolver.getSuperInterfaces(klass)) {
                        propertyDescriptors.addAll(Arrays.asList(Introspector.getBeanInfo(interfaceType).getPropertyDescriptors()));
                    }
                } else {
                    propertyDescriptors = Arrays.asList(Introspector.getBeanInfo(klass, Object.class).getPropertyDescriptors());
                }
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    MetaDataModel property;
                    if (propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null) {
                        Type propertyType = propertyDescriptor.getReadMethod().getGenericReturnType();
                        property = this.parseType(propertyType, context);
                        fields.add(new DefaultMetaDataField(propertyDescriptor.getName(), property));
                        continue;
                    }
                    if (propertyDescriptor.getReadMethod() != null) {
                        Type propertyType = propertyDescriptor.getReadMethod().getGenericReturnType();
                        property = this.parseType(propertyType, context);
                        fields.add(new DefaultMetaDataField(propertyDescriptor.getName(), property, MetaDataField.FieldAccessType.READ));
                        continue;
                    }
                    if (propertyDescriptor.getWriteMethod() == null) continue;
                    Type propertyType = propertyDescriptor.getWriteMethod().getGenericReturnType();
                    property = this.parseType(propertyType, context);
                    fields.add(new DefaultMetaDataField(propertyDescriptor.getName(), property, MetaDataField.FieldAccessType.WRITE));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ParsingContext {
        private Map<TypeVariable<?>, Type> resolvedVariables = new HashMap();
        public final MetaDataModel OBJECT = new DefaultPojoMetaDataModel(Object.class, new ArrayList<MetaDataField>());
        private final Map<String, MetaDataModel> typedObjects = new HashMap<String, MetaDataModel>();

        protected ParsingContext() {
            this.addTypedObject(Object.class.getName(), this.OBJECT);
        }

        public MetaDataModel getTypedObject(String typeName) {
            return this.typedObjects.get(typeName);
        }

        public void addTypedObject(String typeName, MetaDataModel typedObject) {
            if (!this.typedObjects.containsKey(typeName)) {
                this.typedObjects.put(typeName, typedObject);
            }
        }

        public Map<TypeVariable<?>, Type> getResolvedVariables() {
            return Collections.unmodifiableMap(this.resolvedVariables);
        }

        public void addResolvedVariables(Map<TypeVariable<?>, Type> map) {
            for (Map.Entry<TypeVariable<?>, Type> entry : map.entrySet()) {
                if (this.resolvedVariables.containsKey(entry.getKey())) {
                    if (entry.getValue() instanceof TypeVariable) continue;
                    this.resolvedVariables.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.resolvedVariables.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

