/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidocDocumentationCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidocDocumentationCodegen.class);
    public static final String SPEC_DIR = "specDir";
    public static final String SNIPPET_DIR = "snippetDir";
    public static final String HEADER_ATTRIBUTES_FLAG = "headerAttributes";
    protected String invokerPackage = "org.openapitools.client";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-client";
    protected String artifactVersion = "1.0.0";
    protected boolean headerAttributes = true;
    private IncludeMarkupLambda includeSpecMarkupLambda;
    private IncludeMarkupLambda includeSnippetMarkupLambda;
    private LinkMarkupLambda linkSnippetMarkupLambda;

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    static String sanitize(String name) {
        String sanitized = name == null ? "" : name.trim();
        sanitized = sanitized.replace("//", "/");
        return sanitized.startsWith(File.separator) || sanitized.startsWith("/") ? sanitized.substring(1) : sanitized;
    }

    @Override
    public String getName() {
        return "asciidoc";
    }

    @Override
    public String getHelp() {
        return "Generates asciidoc markup based documentation.";
    }

    public String getSpecDir() {
        return this.additionalProperties.get(SPEC_DIR).toString();
    }

    public String getSnippetDir() {
        return this.additionalProperties.get(SNIPPET_DIR).toString();
    }

    public AsciidocDocumentationCodegen() {
        this.featureSet = this.getFeatureSet().modify().securityFeatures(EnumSet.noneOf(SecurityFeature.class)).documentationFeatures(EnumSet.noneOf(DocumentationFeature.class)).globalFeatures(EnumSet.noneOf(GlobalFeature.class)).schemaSupportFeatures(EnumSet.noneOf(SchemaSupportFeature.class)).clientModificationFeatures(EnumSet.noneOf(ClientModificationFeature.class)).build();
        LOGGER.trace("start asciidoc codegen");
        this.outputFolder = "generated-code" + File.separator + "asciidoc";
        this.templateDir = "asciidoc-documentation";
        this.embeddedTemplateDir = "asciidoc-documentation";
        this.defaultIncludes = new HashSet();
        this.cliOptions.add(new CliOption("appName", "short name of the application"));
        this.cliOptions.add(new CliOption("appDescription", "description of the application"));
        this.cliOptions.add(new CliOption("infoUrl", "a URL where users can get more information about the application"));
        this.cliOptions.add(new CliOption("infoEmail", "an email address to contact for inquiries about the application"));
        this.cliOptions.add(new CliOption("licenseInfo", "a short description of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "a URL pointing to the full license"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml. This also becomes part of the generated library's filename"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename"));
        this.cliOptions.add(new CliOption(SNIPPET_DIR, "path with includable markup snippets (e.g. test output generated by restdoc, default: .)").defaultValue("."));
        this.cliOptions.add(new CliOption(SPEC_DIR, "path with includable markup spec files (e.g. handwritten additional docs, default: ..)").defaultValue(".."));
        this.cliOptions.add(CliOption.newBoolean(HEADER_ATTRIBUTES_FLAG, "generation of asciidoc header meta data attributes (set to false to suppress, default: true)", true));
        this.additionalProperties.put("appName", "OpenAPI Sample description");
        this.additionalProperties.put("appDescription", "A sample OpenAPI documentation");
        this.additionalProperties.put("infoUrl", "https://openapi-generator.tech");
        this.additionalProperties.put("infoEmail", "team@openapitools.org");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.adoc"));
        this.reservedWords = new HashSet();
        this.languageSpecificPrimitives = new HashSet();
        this.importMapping = new HashMap();
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    public boolean isHeaderAttributes() {
        return this.headerAttributes;
    }

    public void setHeaderAttributes(boolean headerAttributes) {
        this.headerAttributes = headerAttributes;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        String specDir = this.additionalProperties.get(SPEC_DIR) + "";
        if (!Files.isDirectory(Paths.get(specDir, new String[0]), new LinkOption[0])) {
            LOGGER.warn("base part for include markup lambda not found: " + specDir + " as " + Paths.get(specDir, new String[0]).toAbsolutePath());
        }
        this.includeSpecMarkupLambda = new IncludeMarkupLambda(specDir);
        this.additionalProperties.put("specinclude", this.includeSpecMarkupLambda);
        String snippetDir = this.additionalProperties.get(SNIPPET_DIR) + "";
        if (!Files.isDirectory(Paths.get(snippetDir, new String[0]), new LinkOption[0])) {
            LOGGER.warn("base part for include markup lambda not found: " + snippetDir + " as " + Paths.get(snippetDir, new String[0]).toAbsolutePath());
        }
        this.includeSnippetMarkupLambda = new IncludeMarkupLambda(snippetDir);
        this.additionalProperties.put("snippetinclude", this.includeSnippetMarkupLambda);
        this.linkSnippetMarkupLambda = new LinkMarkupLambda(snippetDir);
        this.additionalProperties.put("snippetlink", this.linkSnippetMarkupLambda);
        if (this.additionalProperties.containsKey(HEADER_ATTRIBUTES_FLAG)) {
            this.setHeaderAttributes(this.convertPropertyToBooleanAndWriteBack(HEADER_ATTRIBUTES_FLAG));
        } else {
            this.additionalProperties.put(HEADER_ATTRIBUTES_FLAG, this.headerAttributes);
        }
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
        if (this.includeSpecMarkupLambda != null) {
            LOGGER.debug("specs: : " + this.includeSpecMarkupLambda.resetCounter());
        }
        if (this.includeSnippetMarkupLambda != null) {
            LOGGER.debug("snippets: : " + this.includeSnippetMarkupLambda.resetCounter());
        }
        super.processOpenAPI(openAPI);
    }

    public class LinkMarkupLambda
    implements Mustache.Lambda {
        private long linkedCount = 0L;
        private long notFoundLinkCount = 0L;
        private String basePath;

        public LinkMarkupLambda(String basePath) {
            this.basePath = basePath;
        }

        public String resetCounter() {
            String msg = "linked:" + this.linkedCount + " notFound: " + this.notFoundLinkCount + " from " + this.basePath;
            this.linkedCount = 0L;
            this.notFoundLinkCount = 0L;
            return msg;
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            String content = frag.execute();
            String[] tokens = content.split(",", 2);
            String linkName = tokens.length > 0 ? tokens[0] : "";
            String relativeFileName = AsciidocDocumentationCodegen.sanitize(tokens.length > 1 ? tokens[1] : linkName);
            Path filePathToLinkTo = Paths.get(this.basePath, relativeFileName).toAbsolutePath();
            if (Files.isRegularFile(filePathToLinkTo, new LinkOption[0])) {
                LOGGER.debug("linking " + ++this.linkedCount + ". file into markup from: " + filePathToLinkTo.toString());
                out.write("\n" + linkName + " link:" + relativeFileName + "[]\n");
            } else {
                LOGGER.debug(++this.notFoundLinkCount + ". file not found, skip link for: " + filePathToLinkTo.toString());
                out.write("\n// file not found, no " + linkName + " link :" + relativeFileName + "[]\n");
            }
        }
    }

    public class IncludeMarkupLambda
    implements Mustache.Lambda {
        private long includeCount = 0L;
        private long notFoundCount = 0L;
        private String basePath;

        public IncludeMarkupLambda(String basePath) {
            this.basePath = basePath;
        }

        public String resetCounter() {
            String msg = "included: " + this.includeCount + " notFound: " + this.notFoundCount + " from " + this.basePath;
            this.includeCount = 0L;
            this.notFoundCount = 0L;
            return msg;
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            String relativeFileName = AsciidocDocumentationCodegen.sanitize(frag.execute());
            Path filePathToInclude = Paths.get(this.basePath, relativeFileName).toAbsolutePath();
            if (Files.isRegularFile(filePathToInclude, new LinkOption[0])) {
                LOGGER.debug("including " + ++this.includeCount + ". file into markup from: " + filePathToInclude.toString());
                out.write("\ninclude::" + relativeFileName + "[opts=optional]\n");
            } else {
                LOGGER.debug(++this.notFoundCount + ". file not found, skip include for: " + filePathToInclude.toString());
                out.write("\n// markup not found, no include ::" + relativeFileName + "[opts=optional]\n");
            }
        }
    }
}

