/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpDotNet2ClientCodegen
extends AbstractCSharpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpDotNet2ClientCodegen.class);
    public static final String CLIENT_PACKAGE = "clientPackage";
    protected String clientPackage = "Org.OpenAPITools.Client";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public CSharpDotNet2ClientCodegen() {
        this.featureSet = this.getFeatureSet().modify().includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).build();
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.DEPRECATED).build();
        this.importMapping.clear();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.setApiPackage(this.packageName + ".Api");
        this.setModelPackage(this.packageName + ".Model");
        this.setClientPackage(this.packageName + ".Client");
        this.setSourceFolder("src" + File.separator + "main" + File.separator + "CsharpDotNet2");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "C# package name (convention: Camel.Case).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("packageVersion", "C# package version.").defaultValue(this.packageVersion));
        this.cliOptions.add(new CliOption(CLIENT_PACKAGE, "C# client package name (convention: Camel.Case).").defaultValue(this.clientPackage));
    }

    @Override
    public void processOpts() {
        LOGGER.warn("Per Microsoft Product Lifecycle (https://support.microsoft.com/en-us/lifecycle/search?sort=PN&alpha=.NET%20Framework&Filter=FilterNO), support for .NET Framework 2.0 ended in 2011 so there may be security issues using the auto-generated C# 2.0 source code.");
        super.processOpts();
        if (this.additionalProperties.containsKey(CLIENT_PACKAGE)) {
            this.setClientPackage((String)this.additionalProperties.get(CLIENT_PACKAGE));
        } else {
            this.additionalProperties.put(CLIENT_PACKAGE, this.getClientPackage());
        }
        String clientPackage = this.getClientPackage();
        String clientPackagePath = clientPackage.replace(".", File.separator);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.sourceFolder + File.separator + clientPackagePath, "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", this.sourceFolder + File.separator + clientPackagePath, "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.sourceFolder + File.separator + clientPackagePath, "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("packages.config.mustache", "vendor", "packages.config"));
        this.supportingFiles.add(new SupportingFile("compile-mono.sh.mustache", "", "compile-mono.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String apiPackage() {
        return this.packageName + ".Api";
    }

    @Override
    public String modelPackage() {
        return this.packageName + ".Model";
    }

    public String getClientPackage() {
        return this.clientPackage;
    }

    public void setClientPackage(String clientPackage) {
        this.clientPackage = clientPackage;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "csharp-dotnet2";
    }

    @Override
    public String getHelp() {
        return "Generates a C# .Net 2.0 client library (beta).";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath.replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath.replace('/', File.separatorChar);
    }
}

