/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractEiffelCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EiffelClientCodegen
extends AbstractEiffelCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(EiffelClientCodegen.class);
    protected String libraryTarget = "openapi_eiffel_client";
    protected String packageName = "Eiffel";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs";
    protected String modelDocPath = "docs";
    protected String modelPath = "domain";
    protected UUID uuid;
    protected UUID uuidTest;

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "eiffel";
    }

    @Override
    public String getHelp() {
        return "Generates a Eiffel client library (beta).";
    }

    public EiffelClientCodegen() {
        this.featureSet = this.getFeatureSet().modify().includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}).build();
        this.uuid = UUID.randomUUID();
        this.uuidTest = UUID.randomUUID();
        this.outputFolder = "generated-code/Eiffel";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.modelTemplateFiles.put("model_generic.mustache", ".e");
        this.apiTemplateFiles.put("api.mustache", ".e");
        this.apiTestTemplateFiles.put("test/api_test.mustache", ".e");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "Eiffel";
        this.embeddedTemplateDir = "Eiffel";
        this.hideGenerationTimestamp = true;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("uuid", this.uuid.toString());
        this.additionalProperties.put("uuidTest", this.uuidTest.toString());
        this.additionalProperties.put("libraryTarget", this.libraryTarget);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        String authFolder = "src/framework/auth";
        String serializerFolder = "src/framework/serialization";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("ecf.mustache", "", "api_client.ecf"));
        this.supportingFiles.add(new SupportingFile("test/ecf_test.mustache", "test", "api_test.ecf"));
        this.supportingFiles.add(new SupportingFile("test/application.mustache", "test", "application.e"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", "src", "api_client.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_i.mustache", "src/framework", "api_i.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_client_request.mustache", "src/framework", "api_client_request.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_client_response.mustache", "src/framework", "api_client_response.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_error.mustache", "src/framework", "api_error.e"));
        this.supportingFiles.add(new SupportingFile("framework/configuration.mustache", "src/framework", "configuration.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/authentication.mustache", "src/framework/auth", "authentication.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/api_key_auth.mustache", "src/framework/auth", "api_key_auth.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/http_basic_auth.mustache", "src/framework/auth", "http_basic_auth.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/oauth.mustache", "src/framework/auth", "oauth.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_deserializer.mustache", "src/framework/serialization", "api_deserializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_json_deserializer.mustache", "src/framework/serialization", "api_json_deserializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_json_serializer.mustache", "src/framework/serialization", "api_json_serializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_serializer.mustache", "src/framework/serialization", "api_serializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/json_basic_reflector_deserializer.mustache", "src/framework/serialization", "json_basic_reflector_deserializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/json_type_utilities_ext.mustache", "src/framework/serialization", "json_type_utilities_ext.e"));
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "src" + File.separator + "api";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "src" + File.separator + this.modelPath;
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + "test" + File.separator + "apis";
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(property.name).toUpperCase(Locale.ROOT) + "_ENUM";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if ("INTEGER_32".equals(datatype) || "INTEGER_64".equals(datatype) || "REAL_32".equals(datatype) || "REAL_64".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("\\W+", "_").toLowerCase(Locale.ROOT);
        if (var.matches("\\d.*")) {
            return "val_" + var;
        }
        if (var.startsWith("_")) {
            return "val" + var;
        }
        return "val_" + var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("INTEGER_32".equals(datatype) || "INTEGER_64".equals(datatype) || "REAL_32".equals(datatype) || "REAL_64".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }
}

