/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.JbossFeature;
import org.openapitools.codegen.languages.features.SwaggerFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;

public class JavaResteasyEapServerCodegen
extends AbstractJavaJAXRSServerCodegen
implements JbossFeature,
BeanValidationFeatures,
SwaggerFeatures {
    protected boolean generateJbossDeploymentDescriptor = true;
    protected boolean useSwaggerFeature = false;

    public JavaResteasyEapServerCodegen() {
        this.featureSet = this.getFeatureSet().modify().includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).build();
        this.artifactId = "openapi-jaxrs-resteasy-eap-server";
        this.useBeanValidation = true;
        this.outputFolder = "generated-code/JavaJaxRS-Resteasy-eap";
        this.updateOption("artifactId", this.getArtifactId());
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "resteasy" + File.separator + "eap";
        this.cliOptions.add(CliOption.newBoolean("generateJbossDeploymentDescriptor", "Generate Jboss Deployment Descriptor", this.generateJbossDeploymentDescriptor));
        this.cliOptions.add(CliOption.newBoolean("useSwaggerFeature", "Use dynamic Swagger generator", this.useSwaggerFeature));
    }

    @Override
    public String getName() {
        return "jaxrs-resteasy-eap";
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS-Resteasy Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("generateJbossDeploymentDescriptor")) {
            boolean generateJbossDeploymentDescriptorProp = this.convertPropertyToBooleanAndWriteBack("generateJbossDeploymentDescriptor");
            this.setGenerateJbossDeploymentDescriptor(generateJbossDeploymentDescriptorProp);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey("useSwaggerFeature")) {
            this.setUseSwaggerFeature(this.convertPropertyToBoolean("useSwaggerFeature"));
        }
        this.writePropertyBack("useSwaggerFeature", this.useSwaggerFeature);
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("gradle.mustache", "", "build.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("settingsGradle.mustache", "", "settings.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.supportingFiles.add(new SupportingFile("JacksonConfig.mustache", (this.projectFolder + File.separator + "java" + '/' + this.invokerPackage).replace(".", "/"), "JacksonConfig.java"));
        if (this.generateJbossDeploymentDescriptor) {
            this.writeOptional(this.outputFolder, new SupportingFile("jboss-web.mustache", "src/main/webapp/WEB-INF", "jboss-web.xml"));
        }
        this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.projectFolder + File.separator + "java" + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null || opList.isEmpty()) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        return super.postProcessOperationsWithModels(objs, allModels);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("JsonProperty");
            if (BooleanUtils.toBoolean((Boolean)model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setGenerateJbossDeploymentDescriptor(boolean generateJbossDeploymentDescriptor) {
        this.generateJbossDeploymentDescriptor = generateJbossDeploymentDescriptor;
    }

    @Override
    public void setUseSwaggerFeature(boolean useSwaggerFeature) {
        this.useSwaggerFeature = useSwaggerFeature;
    }
}

