/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.utils.CamelizeOption;

public class StringUtils {
    public static final String NAME_CACHE_SIZE_PROPERTY = "org.openapitools.codegen.utils.namecache.cachesize";
    public static final String NAME_CACHE_EXPIRY_PROPERTY = "org.openapitools.codegen.utils.namecache.expireafter.seconds";
    private static Cache<Pair<String, CamelizeOption>, String> camelizedWordsCache;
    private static Cache<String, String> underscoreWordsCache;
    private static Cache<EscapedNameOptions, String> escapedWordsCache;
    private static Pattern capitalLetterPattern;
    private static Pattern lowercasePattern;
    private static Pattern pkgSeparatorPattern;
    private static Pattern dollarPattern;
    private static Pattern camelizeSlashPattern;
    private static Pattern camelizeUppercasePattern;
    private static Pattern camelizeUnderscorePattern;
    private static Pattern camelizeHyphenPattern;
    private static Pattern camelizeDollarPattern;
    private static Pattern camelizeSimpleUnderscorePattern;

    public static String underscore(String word) {
        return (String)underscoreWordsCache.get((Object)word, wordToUnderscore -> {
            String replacementPattern = "$1_$2";
            String result = pkgSeparatorPattern.matcher((CharSequence)wordToUnderscore).replaceAll("/");
            result = dollarPattern.matcher(result).replaceAll("__");
            result = capitalLetterPattern.matcher(result).replaceAll(replacementPattern);
            result = lowercasePattern.matcher(result).replaceAll(replacementPattern);
            result = result.replace('-', '_');
            result = result.replace(' ', '_');
            result = result.toLowerCase(Locale.ROOT);
            return result;
        });
    }

    public static String dashize(String word) {
        return StringUtils.underscore(word).replaceAll("[_ ]+", "-");
    }

    public static String camelize(String word) {
        return StringUtils.camelize(word, CamelizeOption.UPPERCASE_FIRST_CHAR);
    }

    public static String camelize(String inputWord, CamelizeOption camelizeOption) {
        ImmutablePair key = new ImmutablePair((Object)inputWord, (Object)camelizeOption);
        return (String)camelizedWordsCache.get((Object)key, pair -> {
            String word = (String)pair.getKey();
            CamelizeOption option = (CamelizeOption)((Object)((Object)pair.getValue()));
            Matcher m = camelizeSlashPattern.matcher(word);
            while (m.find()) {
                word = m.replaceFirst("." + m.group(1));
                m = camelizeSlashPattern.matcher(word);
            }
            String[] parts = word.split("\\.");
            StringBuilder f = new StringBuilder();
            for (String z : parts) {
                if (z.length() <= 0) continue;
                f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
            }
            word = f.toString();
            m = camelizeSlashPattern.matcher(word);
            while (m.find()) {
                word = m.replaceFirst(Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
                m = camelizeSlashPattern.matcher(word);
            }
            m = camelizeUppercasePattern.matcher(word);
            if (m.find()) {
                String rep = m.group(1) + m.group(2).toUpperCase(Locale.ROOT) + m.group(3);
                rep = camelizeDollarPattern.matcher(rep).replaceAll("\\\\\\$");
                word = m.replaceAll(rep);
            }
            m = camelizeUnderscorePattern.matcher(word);
            while (m.find()) {
                String upperCase;
                String original = m.group(2);
                word = original.equals(upperCase = original.toUpperCase(Locale.ROOT)) ? camelizeSimpleUnderscorePattern.matcher(word).replaceFirst("") : m.replaceFirst(upperCase);
                m = camelizeUnderscorePattern.matcher(word);
            }
            m = camelizeHyphenPattern.matcher(word);
            while (m.find()) {
                word = m.replaceFirst(m.group(2).toUpperCase(Locale.ROOT));
                m = camelizeHyphenPattern.matcher(word);
            }
            switch (option) {
                case LOWERCASE_FIRST_LETTER: {
                    word = StringUtils.lowercaseFirstLetter(word);
                    break;
                }
                case LOWERCASE_FIRST_CHAR: {
                    word = word.substring(0, 1).toLowerCase(Locale.ROOT) + word.substring(1);
                }
            }
            word = camelizeSimpleUnderscorePattern.matcher(word).replaceAll("");
            return word;
        });
    }

    private static String lowercaseFirstLetter(String word) {
        if (word.length() > 0) {
            int i = 0;
            char charAt = word.charAt(i);
            while (!(i + 1 >= word.length() || charAt >= 'a' && charAt <= 'z' || charAt >= 'A' && charAt <= 'Z')) {
                charAt = word.charAt(++i);
            }
            word = word.substring(0, ++i).toLowerCase(Locale.ROOT) + word.substring(i);
        }
        return word;
    }

    public static String escape(String name, Map<String, String> replacementMap, List<String> charactersToAllow, String appendToReplacement) {
        EscapedNameOptions ns = new EscapedNameOptions(name, replacementMap.keySet(), charactersToAllow, appendToReplacement);
        return (String)escapedWordsCache.get((Object)ns, wordToEscape -> {
            String result = name.chars().mapToObj(c -> {
                String character = String.valueOf((char)c);
                if (charactersToAllow != null && charactersToAllow.contains(character)) {
                    return character;
                }
                if (replacementMap.containsKey(character)) {
                    return (String)replacementMap.get(character) + (appendToReplacement != null ? appendToReplacement : "");
                }
                return character;
            }).reduce((c1, c2) -> c1 + c2).orElse(null);
            if (result != null) {
                return result;
            }
            throw new RuntimeException("Word '" + name + "' could not be escaped.");
        });
    }

    static {
        int cacheSize = Integer.parseInt(GlobalSettings.getProperty(NAME_CACHE_SIZE_PROPERTY, "200"));
        int cacheExpiry = Integer.parseInt(GlobalSettings.getProperty(NAME_CACHE_EXPIRY_PROPERTY, "5"));
        camelizedWordsCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpiry, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build();
        escapedWordsCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpiry, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build();
        underscoreWordsCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpiry, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build();
        capitalLetterPattern = Pattern.compile("([A-Z]+)([A-Z][a-z][a-z]+)");
        lowercasePattern = Pattern.compile("([a-z\\d])([A-Z])");
        pkgSeparatorPattern = Pattern.compile("\\.");
        dollarPattern = Pattern.compile("\\$");
        camelizeSlashPattern = Pattern.compile("\\/(.?)");
        camelizeUppercasePattern = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        camelizeUnderscorePattern = Pattern.compile("(_)(.)");
        camelizeHyphenPattern = Pattern.compile("(-)(.)");
        camelizeDollarPattern = Pattern.compile("\\$");
        camelizeSimpleUnderscorePattern = Pattern.compile("_");
    }

    private static class EscapedNameOptions {
        private String name;
        private String appendToReplacement;
        private Set<String> specialChars;
        private List<String> charactersToAllow;

        public EscapedNameOptions(String name, Set<String> specialChars, List<String> charactersToAllow, String appendToReplacement) {
            this.name = name;
            this.appendToReplacement = appendToReplacement;
            this.specialChars = specialChars != null ? Collections.unmodifiableSet(specialChars) : Collections.emptySet();
            this.charactersToAllow = charactersToAllow != null ? Collections.unmodifiableList(charactersToAllow) : Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EscapedNameOptions that = (EscapedNameOptions)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.appendToReplacement, that.appendToReplacement) && Objects.equals(this.specialChars, that.specialChars) && Objects.equals(this.charactersToAllow, that.charactersToAllow);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.appendToReplacement, this.specialChars, this.charactersToAllow);
        }
    }
}

