/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.demo.Demo;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.OutOfBoundsException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.service.Service;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class GeoWebCacheDispatcher
extends AbstractController {
    private static Log log = LogFactory.getLog(GeoWebCacheDispatcher.class);
    public static final String TYPE_SERVICE = "service";
    public static final String TYPE_DEMO = "demo";
    private TileLayerDispatcher tileLayerDispatcher = null;
    private StorageBroker storageBroker = null;
    private DefaultStorageFinder defaultStorageFinder = null;
    private HashMap<String, Service> services = null;
    private byte[] blankTile = null;
    private String servletPrefix = null;

    public void setStorageBroker(StorageBroker sb) {
        this.storageBroker = sb;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.tileLayerDispatcher = tileLayerDispatcher;
        log.info((Object)"set TileLayerDispatcher");
    }

    public void setDefaultStorageFinder(DefaultStorageFinder defaultStorageFinder) {
        this.defaultStorageFinder = defaultStorageFinder;
    }

    public void setServletPrefix(String servletPrefix) {
        this.servletPrefix = !servletPrefix.startsWith("/") ? "/" + servletPrefix : servletPrefix;
        log.info((Object)("Invoked setServletPrefix(" + servletPrefix + ")"));
    }

    private void loadServices() {
        WebApplicationContext context = (WebApplicationContext)this.getApplicationContext();
        Map serviceBeans = context.getBeansOfType(Service.class);
        Iterator beanIter = serviceBeans.keySet().iterator();
        this.services = new HashMap();
        while (beanIter.hasNext()) {
            Service aService = (Service)serviceBeans.get(beanIter.next());
            this.services.put(aService.getPathName(), aService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlankTile() {
        String blankTilePath = this.defaultStorageFinder.findEnvVar("GWC_BLANK_TILE_PATH");
        if (blankTilePath != null) {
            File fh = new File(blankTilePath);
            if (fh.exists() && fh.canRead() && fh.isFile()) {
                long fileSize = fh.length();
                this.blankTile = new byte[(int)fileSize];
                int total = 0;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fh);
                    int read = 0;
                    while (read != -1) {
                        read = fis.read(this.blankTile, total, this.blankTile.length - total);
                        if (read == -1) continue;
                        total += read;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (total == this.blankTile.length && total > 0) {
                    log.info((Object)("Loaded blank tile from " + blankTilePath));
                } else {
                    log.error((Object)("Failed to load blank tile from " + blankTilePath));
                }
                return;
            }
            log.error((Object)("" + blankTilePath + " does not exist or is not readable."));
        }
        InputStream is = null;
        try {
            is = GeoWebCacheDispatcher.class.getResourceAsStream("blank.png");
            this.blankTile = new byte[425];
            int ret = is.read(this.blankTile);
            log.info((Object)("Read " + ret + " from blank PNG file (expected 425)."));
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block13: {
            String[] requestComps = null;
            try {
                String normalizedURI = request.getRequestURI().replaceFirst(request.getContextPath(), "");
                if (this.servletPrefix != null) {
                    normalizedURI = normalizedURI.replaceFirst(this.servletPrefix, "");
                }
                requestComps = this.parseRequest(normalizedURI);
            }
            catch (GeoWebCacheException gwce) {
                GeoWebCacheDispatcher.writeError(response, 400, gwce.getMessage());
                return null;
            }
            try {
                if (requestComps == null) {
                    GeoWebCacheDispatcher.handleFrontPage(request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_SERVICE)) {
                    this.handleServiceRequest(requestComps[1], request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_DEMO) || requestComps[0].equalsIgnoreCase("demos")) {
                    this.handleDemoRequest(requestComps[1], request, response);
                } else {
                    GeoWebCacheDispatcher.writeError(response, 404, "Unknown path: " + requestComps[0]);
                }
            }
            catch (Exception e) {
                if (e instanceof RequestFilterException) {
                    RequestFilterException reqE = (RequestFilterException)e;
                    reqE.setHttpInfoHeader(response);
                    GeoWebCacheDispatcher.writeFixedResponse(response, reqE.getResponseCode(), reqE.getContenType(), reqE.getResponse());
                }
                if (!(e instanceof BadTileException) || log.isDebugEnabled()) {
                    log.error((Object)(e.getMessage() + " " + request.getRequestURL().toString()));
                }
                GeoWebCacheDispatcher.writeError(response, 400, e.getMessage());
                if (e instanceof GeoWebCacheException && !log.isDebugEnabled()) break block13;
                e.printStackTrace();
            }
        }
        return null;
    }

    public void destroy() {
        log.info((Object)"GeoWebCacheDispatcher.destroy() was invoked, shutting down.");
    }

    private String[] parseRequest(String servletPath) throws GeoWebCacheException {
        String[] retStrs = new String[2];
        String[] splitStr = servletPath.split("/");
        if (splitStr == null || splitStr.length < 2) {
            return null;
        }
        retStrs[0] = splitStr[1];
        if (splitStr.length > 2) {
            retStrs[1] = splitStr[2];
        }
        return retStrs;
    }

    private void handleServiceRequest(String serviceStr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Conveyor conv = null;
        Service service = this.findService(serviceStr);
        conv = service.getConveyor(request, response);
        if (conv.reqHandler == Conveyor.RequestHandler.SERVICE) {
            service.handleRequest(conv);
        } else {
            ConveyorTile convTile = (ConveyorTile)conv;
            TileLayer layer = this.tileLayerDispatcher.getTileLayer(convTile.getLayerId());
            convTile.setTileLayer(layer);
            layer.applyRequestFilters(convTile);
            try {
                layer.getTile(convTile);
                this.writeData(convTile);
            }
            catch (OutOfBoundsException e) {
                this.writeEmpty(convTile, e.getMessage());
            }
        }
    }

    private void handleDemoRequest(String action, HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        Demo.makeMap(this.tileLayerDispatcher, action, request, response);
    }

    private Service findService(String serviceStr) throws GeoWebCacheException {
        Service service;
        if (this.services == null) {
            this.loadServices();
            this.loadBlankTile();
        }
        if ((service = this.services.get(serviceStr)) == null) {
            serviceStr = serviceStr == null || serviceStr.length() == 0 ? ", try service/&lt;name of service&gt;" : " \"" + serviceStr + "\"";
            throw new GeoWebCacheException("Unable to find handler for service" + serviceStr);
        }
        return service;
    }

    private static void handleFrontPage(HttpServletRequest request, HttpServletResponse response) {
        String baseUrl;
        if (request.getRequestURL().toString().endsWith("/")) {
            baseUrl = "";
        } else {
            String[] strs = request.getRequestURL().toString().split("/");
            baseUrl = strs[strs.length - 1] + "/";
        }
        String message = "<html><body>\n<a id=\"logo\" href=\"http://geowebcache.org\"><img src=\"http://geowebcache.org/trac/chrome/site/geowebcache_logo.png\"height=\"100\" width=\"353\" border=\"0\"/></a>\n<h3>Welcome to GeoWebCache version 1.1.5b, built 2009-08-11</h3>\n<h3>Dynamic demos:</h3>\n<ul><li><a href=\"" + baseUrl + "demo\">Dynamically generated list of layers</a></li></ul>\n" + "<h3>GetCapabilities:</h3>\n" + "<ul><li><a href=\"" + baseUrl + "service/wms?service=WMS&version=1.1.1&request=getcapabilities&tiled=true\">WMS 1.1.1 GetCapabilities document</a></li>" + "<li>Note that this will only work with clients that are " + "<a href=\"http://wiki.osgeo.org/wiki/WMS_Tiling_Client_Recommendation\">WMS-C capable</a>.</li>\n" + "<li>Omitting tiled=true from the URL will omit the TileSet elements.</li></ul>\n" + "</body></html>\n";
        GeoWebCacheDispatcher.writePage(response, 200, message);
    }

    private static void writeError(HttpServletResponse response, int httpCode, String errorMsg) {
        log.debug((Object)errorMsg);
        errorMsg = "<html><body>\n<a id=\"logo\" href=\"http://geowebcache.org\"><img src=\"http://geowebcache.org/trac/chrome/site/geowebcache_logo.png\"height=\"100\" width=\"353\" border=\"0\"/></a>\n<h4>" + httpCode + ": " + errorMsg + "</h4>" + "</body></html>\n";
        GeoWebCacheDispatcher.writePage(response, httpCode, errorMsg);
    }

    private static void writePage(HttpServletResponse response, int httpCode, String message) {
        GeoWebCacheDispatcher.writeFixedResponse(response, httpCode, "text/html", message.getBytes());
    }

    private void writeData(ConveyorTile tile) throws IOException {
        GeoWebCacheDispatcher.writeFixedResponse(tile.servletResp, 200, tile.getMimeType().getMimeType(), tile.getContent());
    }

    private void writeEmpty(ConveyorTile tile, String message) {
        tile.servletResp.setHeader("geowebcache-message", message);
        TileLayer layer = tile.getLayer();
        if (layer != null) {
            layer.setExpirationHeader(tile.servletResp);
        }
        GeoWebCacheDispatcher.writeFixedResponse(tile.servletResp, 200, ImageMime.png.getMimeType(), this.blankTile);
    }

    private static void writeFixedResponse(HttpServletResponse response, int httpCode, String contentType, byte[] data) {
        response.setStatus(httpCode);
        response.setContentType(contentType);
        if (data != null) {
            response.setContentLength(data.length);
            try {
                ServletOutputStream os = response.getOutputStream();
                os.write(data);
            }
            catch (IOException ioe) {
                log.debug((Object)("Caught IOException: " + ioe.getMessage() + "\n\n" + ioe.toString()));
            }
        }
    }
}

