/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.conveyor;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.WFSObject;

public class ConveyorWFS
extends Conveyor {
    private static Log log = LogFactory.getLog(ConveyorWFS.class);
    WFSObject stObj = null;

    public ConveyorWFS(StorageBroker sb, String parameters, byte[] queryBlob, HttpServletRequest srq, HttpServletResponse srp) {
        super(sb, srq, srp);
        super.setRequestHandler(Conveyor.RequestHandler.SERVICE);
        if (queryBlob != null) {
            this.stObj = WFSObject.createQueryWFSObject(queryBlob);
        } else if (parameters != null) {
            this.stObj = WFSObject.createQueryWFSObject(parameters);
        }
    }

    public byte[] getQueryBlob() {
        return this.stObj.getQueryBlob();
    }

    public boolean persist() throws GeoWebCacheException {
        return this.storageBroker.put(this.stObj);
    }

    public String getMimeTypeString() {
        return this.stObj.getBlobFormat();
    }

    public void setMimeTypeString(String mimeType) {
        this.stObj.setBlobFormat(mimeType);
    }

    public boolean retrieve(int maxAge) throws GeoWebCacheException {
        try {
            return this.storageBroker.get(this.stObj);
        }
        catch (StorageException se) {
            throw new GeoWebCacheException(se.getMessage());
        }
    }

    public InputStream getInputStream() {
        return this.stObj.getInputStream();
    }

    public void setInputStream(InputStream is) {
        this.stObj.setInputStream(is);
    }
}

